/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.service.JSLanguageServiceAliveChecker;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceQueueImpl;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerState;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ThreeState;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u0013H\u00a6@\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010 \u001a\u00020\u0013H\u0003J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\rH\u0002J\u0006\u0010#\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceAliveChecker;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "processInit", "Lkotlinx/coroutines/sync/Mutex;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/sync/Mutex;)V", "failCount", "Ljava/util/concurrent/atomic/AtomicLong;", "hasInterpreter", "Lcom/intellij/util/ThreeState;", "currentProcess", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "getCurrentProcess", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "terminateStartedProcessUnderLock", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeOnce", "checkAlive", "checkServiceQueueAlive", "", "serviceQueue", "(Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkCanUseService", "resetState", "checkIfNodeInterpreterIsValid", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "printInvalidInterpreterDiagnostics", "scheduleDaemonRestart", "prevValue", "reportFailedStartAttempt", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceAliveChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceAliveChecker.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceAliveChecker\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,139:1\n116#2,11:140\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceAliveChecker.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceAliveChecker\n*L\n52#1:140,11\n*E\n"})
public abstract class JSLanguageServiceAliveChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Mutex processInit;
    @NotNull
    private final AtomicLong failCount;
    @NotNull
    private volatile ThreeState hasInterpreter;
    private static final long ALIVE_CHECK_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    public static final int ALIVE_CHECK_COUNT_LIMIT = 5;

    public JSLanguageServiceAliveChecker(@NotNull Project project, @NotNull CoroutineScope cs, @NotNull Mutex processInit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)processInit, (String)"processInit");
        this.project = project;
        this.cs = cs;
        this.processInit = processInit;
        this.failCount = new AtomicLong();
        this.hasInterpreter = ThreeState.UNSURE;
    }

    @Nullable
    public abstract JSLanguageServiceQueue getCurrentProcess();

    @Nullable
    public abstract Object terminateStartedProcessUnderLock(@NotNull Continuation<? super Unit> var1);

    public final void initializeOnce() {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JSLanguageServiceAliveChecker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch) && !JSLanguageServiceAliveChecker.access$getProject$p(this.this$0).isDisposed()) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = JSLanguageServiceAliveChecker.access$checkAlive(this.this$0, (Continuation)this);
                            if (v0 == var3_3) {
                                return var3_3;
                            }
                            ** GOTO lbl17
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        this.L$0 = $this$launch;
                        this.label = 2;
                        v1 = DelayKt.delay((long)JSLanguageServiceAliveChecker.Companion.getALIVE_CHECK_TIMEOUT(), (Continuation)((Continuation)this));
                        if (v1 != var3_3) ** GOTO lbl6
                        return var3_3;
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object checkAlive(Continuation<? super Unit> $completion) {
        if (!($completion instanceof checkAlive.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceAliveChecker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSLanguageServiceAliveChecker.access$checkAlive(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                JSLanguageServiceQueue.Holder.LOGGER.trace("Check alive is called");
                if (this.getCurrentProcess() == null) ** GOTO lbl65
                $this$withLock_u24default$iv = this.processInit;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-JSLanguageServiceAliveChecker$checkAlive$2 = 0;
                process = this.getCurrentProcess();
                if (process == null) ** GOTO lbl58
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)process);
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-JSLanguageServiceAliveChecker$checkAlive$2;
                $continuation.label = 2;
                v1 = this.checkServiceQueueAlive(process, (Continuation<? super Boolean>)$continuation);
                ** if (v1 != var10_4) goto lbl43
lbl42:
                // 1 sources

                return var10_4;
lbl43:
                // 1 sources

                ** GOTO lbl54
            }
            case 2: {
                $i$a$-withLock$default-JSLanguageServiceAliveChecker$checkAlive$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                process = (JSLanguageServiceQueue)$continuation.L$1;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl54:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) {
                        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            Object L$0;
                            Object L$1;
                            int I$0;
                            int I$1;
                            int label;
                            final /* synthetic */ JSLanguageServiceAliveChecker this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        JSLanguageServiceQueue.Holder.LOGGER.debug("Dispose by alive checker");
                                        var2_3 = JSLanguageServiceAliveChecker.access$getProcessInit$p(this.this$0);
                                        var4_4 = this.this$0;
                                        owner$iv = null;
                                        $i$f$withLock = 0;
                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = var4_4;
                                        this.I$0 = $i$f$withLock;
                                        this.label = 1;
                                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                        if (v0 == var8_2) {
                                            return var8_2;
                                        }
                                        ** GOTO lbl26
                                    }
                                    case 1: {
                                        $i$f$withLock = this.I$0;
                                        var4_4 = (JSLanguageServiceAliveChecker)this.L$1;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl26:
                                        // 3 sources

                                        $i$a$-withLock$default-JSLanguageServiceAliveChecker$checkAlive$2$1$1 = 0;
                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = null;
                                        this.I$0 = $i$f$withLock;
                                        this.I$1 = $i$a$-withLock$default-JSLanguageServiceAliveChecker$checkAlive$2$1$1;
                                        this.label = 2;
                                        v1 = var4_4.terminateStartedProcessUnderLock((Continuation<? super Unit>)this);
                                        ** if (v1 != var8_2) goto lbl36
lbl35:
                                        // 1 sources

                                        return var8_2;
lbl36:
                                        // 1 sources

                                        ** GOTO lbl46
                                    }
                                    case 2: {
                                        $i$a$-withLock$default-JSLanguageServiceAliveChecker$checkAlive$2$1$1 = this.I$1;
                                        $i$f$withLock = this.I$0;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl46:
                                            // 2 sources

                                            var7_11 = Unit.INSTANCE;
                                        }
                                        catch (Throwable var6_10) {
                                            throw var6_10;
                                        }
                                        finally {
                                            $this$withLock_u24default$iv.unlock(owner$iv);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
lbl58:
                    // 4 sources

                    var7_14 = Unit.INSTANCE;
                }
                catch (Throwable var5_11) {
                    throw var5_11;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
lbl65:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object checkServiceQueueAlive(JSLanguageServiceQueue serviceQueue, Continuation<? super Boolean> $completion) {
        TypeScriptServerState serverState;
        JSLanguageServiceQueue.Holder.LOGGER.trace("Check alive process queue " + serviceQueue.hashCode());
        JSLanguageServiceExecutor.State state = serviceQueue.getState();
        if (!serviceQueue.isValid()) {
            this.failCount.incrementAndGet();
            return Boxing.boxBoolean((boolean)false);
        }
        if (state == JSLanguageServiceExecutor.State.STARTED) {
            this.failCount.set(0L);
        }
        TypeScriptLanguageServiceQueueImpl typeScriptLanguageServiceQueueImpl = serviceQueue instanceof TypeScriptLanguageServiceQueueImpl ? (TypeScriptLanguageServiceQueueImpl)serviceQueue : null;
        TypeScriptServerState typeScriptServerState = serverState = typeScriptLanguageServiceQueueImpl != null ? typeScriptLanguageServiceQueueImpl.getServerState() : null;
        if (serverState != null) {
            return CoroutinesKt.readAction(() -> JSLanguageServiceAliveChecker.checkServiceQueueAlive$lambda$1(serverState), $completion);
        }
        return Boxing.boxBoolean((boolean)true);
    }

    public final boolean checkCanUseService() {
        return this.hasInterpreter != ThreeState.NO && this.failCount.get() < 5L;
    }

    public final void resetState() {
        this.failCount.set(0L);
        this.hasInterpreter = ThreeState.UNSURE;
    }

    public final boolean checkIfNodeInterpreterIsValid(@Nullable NodeJsInterpreter interpreter2) {
        ThreeState prevValue = this.hasInterpreter;
        this.hasInterpreter = ThreeState.Companion.fromBoolean(interpreter2 != null);
        if (interpreter2 != null) {
            return true;
        }
        JSLanguageServiceQueue.Holder.LOGGER.warn("No interpreter found - cannot create language service queue.");
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            this.printInvalidInterpreterDiagnostics();
        }
        this.scheduleDaemonRestart(prevValue);
        return false;
    }

    @TestOnly
    private final void printInvalidInterpreterDiagnostics() {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.Companion.getSettings(this.project);
        NodeJsInterpreter invalidInterpreter = TypeScriptLanguageServiceUtil.getNodeInterpreter(this.project, settings);
        if (invalidInterpreter == null) {
            JSLanguageServiceQueue.Holder.LOGGER.error("Cannot resolve NodeJS interpreter: " + settings.getNodeInterpreterRefName());
        } else {
            JSLanguageServiceQueue.Holder.LOGGER.error("Failed to validate NodeJS interpreter: " + invalidInterpreter.validate(this.project));
        }
    }

    private final void scheduleDaemonRestart(ThreeState prevValue) {
        if (prevValue != this.hasInterpreter && this.project.isOpen()) {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(() -> JSLanguageServiceAliveChecker.scheduleDaemonRestart$lambda$3(this));
        }
    }

    public final void reportFailedStartAttempt() {
        this.failCount.incrementAndGet();
    }

    private static final boolean checkServiceQueueAlive$lambda$1(TypeScriptServerState $serverState) {
        return $serverState.isServiceValid();
    }

    private static final void scheduleDaemonRestart$lambda$3$lambda$2(JSLanguageServiceAliveChecker this$0) {
        DaemonCodeAnalyzer.getInstance((Project)this$0.project).restart();
    }

    private static final void scheduleDaemonRestart$lambda$3(JSLanguageServiceAliveChecker this$0) {
        ApplicationKt.getApplication().invokeLater(() -> JSLanguageServiceAliveChecker.scheduleDaemonRestart$lambda$3$lambda$2(this$0), this$0.project.getDisposed());
    }

    public static final /* synthetic */ Project access$getProject$p(JSLanguageServiceAliveChecker $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$checkAlive(JSLanguageServiceAliveChecker $this, Continuation $completion) {
        return $this.checkAlive((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$checkServiceQueueAlive(JSLanguageServiceAliveChecker $this, JSLanguageServiceQueue serviceQueue, Continuation $completion) {
        return $this.checkServiceQueueAlive(serviceQueue, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Mutex access$getProcessInit$p(JSLanguageServiceAliveChecker $this) {
        return $this.processInit;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceAliveChecker$Companion;", "", "<init>", "()V", "ALIVE_CHECK_TIMEOUT", "", "getALIVE_CHECK_TIMEOUT", "()J", "ALIVE_CHECK_COUNT_LIMIT", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final long getALIVE_CHECK_TIMEOUT() {
            return ALIVE_CHECK_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

