/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.concurrency.ThreadContext;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u0006\u0010\r\u001a\u00020\u000e\u001a2\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u001c\u0010\u0011\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012H\u0087@\u00a2\u0006\u0002\u0010\u0015\u001aC\u0010\u0016\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102-\u0010\u0011\u001a)\b\u0001\u0012\u0004\u0012\u00020\u0018\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00190\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0017\u00a2\u0006\u0002\b\u001aH\u0087@\u00a2\u0006\u0002\u0010\u001b\"\u0014\u0010\u0003\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"normalizedNameAndPath", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentThreadDebugInfo", "getCurrentThreadDebugInfo", "()Ljava/lang/String;", "debugString", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "getDebugString", "(Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;)Ljava/lang/String;", "adjustIntoIdentifier", "Lcom/intellij/psi/PsiElement;", "originalElement", "isCommandFromDispatchThread", "", "readActionWithSuspend", "T", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readAndWriteActionWithSuspend", "Lkotlin/Function2;", "Lcom/intellij/openapi/application/ReadAndWriteScope;", "Lcom/intellij/openapi/application/ReadResult;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.impl"})
public final class JSLanguageServiceUtilKt {
    @Nullable
    public static final String normalizedNameAndPath(@NotNull VirtualFile $this$normalizedNameAndPath) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizedNameAndPath, (String)"<this>");
        return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks($this$normalizedNameAndPath);
    }

    @NotNull
    public static final String getCurrentThreadDebugInfo() {
        return "[Thread " + Thread.currentThread().getId() + "]";
    }

    @NotNull
    public static final String getDebugString(@NotNull JSLanguageServiceCommand $this$debugString) {
        Intrinsics.checkNotNullParameter((Object)$this$debugString, (String)"<this>");
        return $this$debugString.getCommand() + "@" + System.identityHashCode($this$debugString);
    }

    @NotNull
    public static final PsiElement adjustIntoIdentifier(@NotNull PsiElement originalElement) {
        ASTNode name;
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        PsiElement originalElement2 = originalElement;
        if (originalElement2 instanceof JSImplicitElement) {
            Object object = ObjectUtils.coalesce((Object)originalElement2.getParent(), (Object)originalElement2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
            originalElement2 = (PsiElement)object;
        }
        if (originalElement2 instanceof PsiNameIdentifierOwner) {
            PsiElement identifier = ((PsiNameIdentifierOwner)originalElement2).getNameIdentifier();
            Object object = ObjectUtils.coalesce((Object)identifier, (Object)originalElement2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
            originalElement2 = (PsiElement)object;
        } else if (originalElement2 instanceof JSReferenceExpression) {
            Object object = ObjectUtils.coalesce((Object)((JSReferenceExpression)originalElement2).getReferenceNameElement(), (Object)originalElement2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
            originalElement2 = (PsiElement)object;
        } else if (originalElement2 instanceof JSThisExpression) {
            Object object = ObjectUtils.coalesce((Object)((JSThisExpression)originalElement2).getFirstChild(), (Object)originalElement2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
            originalElement2 = (PsiElement)object;
        } else if (originalElement2 instanceof XmlTag && (name = XmlChildRole.START_TAG_NAME_FINDER.findChild(originalElement2.getNode())) != null) {
            Object object = ObjectUtils.coalesce((Object)name.getPsi(), (Object)originalElement2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
            originalElement2 = (PsiElement)object;
        }
        return originalElement2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCommandFromDispatchThread() {
        if (ApplicationKt.getApplication().isDispatchThread()) return true;
        CoroutineName coroutineName = (CoroutineName)ThreadContext.currentThreadContext().get((CoroutineContext.Key)CoroutineName.Key);
        if (!Intrinsics.areEqual((Object)(coroutineName != null ? coroutineName.getName() : null), (Object)"runUpdateSessionForInputEvent")) return false;
        return true;
    }

    @RequiresReadLockAbsence
    @Nullable
    public static final <T> Object readActionWithSuspend(@NotNull Function1<? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $completion) {
        ThreadingAssertions.assertNoReadAccess();
        return CoroutinesKt.readAction(() -> JSLanguageServiceUtilKt.readActionWithSuspend$lambda$0(block), $completion);
    }

    @RequiresReadLockAbsence
    @Nullable
    public static final <T> Object readAndWriteActionWithSuspend(@NotNull Function2<? super ReadAndWriteScope, ? super Continuation<? super ReadResult<? extends T>>, ? extends Object> block, @NotNull Continuation<? super T> $completion) {
        ThreadingAssertions.assertNoReadAccess();
        return CoroutinesKt.readAndEdtWriteAction(arg_0 -> JSLanguageServiceUtilKt.readAndWriteActionWithSuspend$lambda$1(block, arg_0), $completion);
    }

    private static final Object readActionWithSuspend$lambda$0(Function1 $block) {
        return com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>($block, null){
            int label;
            final /* synthetic */ Function1<Continuation<? super T>, Object> $block;
            {
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$block.invoke((Object)((Object)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final ReadResult readAndWriteActionWithSuspend$lambda$1(Function2 $block, ReadAndWriteScope $this$readAndEdtWriteAction) {
        Intrinsics.checkNotNullParameter((Object)$this$readAndEdtWriteAction, (String)"$this$readAndEdtWriteAction");
        return (ReadResult)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)new Function2<CoroutineScope, Continuation<? super ReadResult<? extends T>>, Object>($block, $this$readAndEdtWriteAction, null){
            int label;
            final /* synthetic */ Function2<ReadAndWriteScope, Continuation<? super ReadResult<? extends T>>, Object> $block;
            final /* synthetic */ ReadAndWriteScope $this_readAndEdtWriteAction;
            {
                this.$block = $block;
                this.$this_readAndEdtWriteAction = $this_readAndEdtWriteAction;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$block.invoke((Object)this.$this_readAndEdtWriteAction, (Object)((Object)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ReadResult<? extends T>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }
}

