/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.hint;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.psi.JSArgumentsHolder;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/typescript/hint/TypeScriptParameterInfoHandler;", "Lcom/intellij/javascript/JSParameterInfoHandler;", "<init>", "()V", "fillSignaturesForArgumentList", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "argList", "Lcom/intellij/lang/javascript/psi/JSArgumentsHolder;", "skipTypeScript", "", "intellij.javascript.impl"})
public final class TypeScriptParameterInfoHandler
extends JSParameterInfoHandler {
    @Override
    @Nullable
    protected Sequence<JSFunctionType> fillSignaturesForArgumentList(@NotNull JSArgumentsHolder argList) {
        Intrinsics.checkNotNullParameter((Object)argList, (String)"argList");
        Sequence<JSFunctionType> result2 = super.fillSignaturesForArgumentList(argList);
        if (result2 != null) {
            return result2;
        }
        PsiFile file = argList.getContainingFile();
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow || !TypeScriptLanguageServiceUtil.useServiceParameterInfo(project2, virtualFile)) {
            return null;
        }
        Intrinsics.checkNotNull((Object)virtualFile);
        TypeScriptService service = TypeScriptServiceHolder.getForFile(project2, virtualFile);
        if (service == null) {
            return null;
        }
        Intrinsics.checkNotNull((Object)file);
        Future<Stream<JSFunctionType>> future = service.getSignatureHelp(file, argList.getTextOffset());
        Stream<JSFunctionType> stream = JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.getShortTimeout());
        return stream != null ? StreamsKt.asSequence(stream) : null;
    }

    @Override
    protected boolean skipTypeScript() {
        return false;
    }
}

