/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class ConstantUtils {
    @Contract(value="null -> false")
    public static boolean isZero(@Nullable JSExpression expression) {
        if (!(expression instanceof JSLiteralExpression) || !((JSLiteralExpression)expression).isNumericLiteral()) {
            return false;
        }
        Object value = ExpressionUtil.computeConstantExpression(expression);
        return value instanceof Integer && (Integer)value == 0;
    }

    @Contract(value="null -> false")
    public static boolean isOne(@Nullable JSExpression expression) {
        if (!(expression instanceof JSLiteralExpression) || !((JSLiteralExpression)expression).isNumericLiteral()) {
            return false;
        }
        Object value = ExpressionUtil.computeConstantExpression(expression);
        return value instanceof Integer && (Integer)value == 1;
    }
}

