/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.jpb.model.inspection.fix.MakeEmbeddableEntitySerializableFix;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.model.annotations.mapping.PersistentObjectImpl;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.model.xml.persistence.mapping.AccessType;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.actions.ParametersKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastVisibility;

public final class JpaInspectionUtil {
    public static final String DEFAULT_PARAMETER_NAME = "o";

    private JpaInspectionUtil() {
    }

    public static <T extends PsiReference & EmptyResolveMessageProvider> boolean checkMemberAnnotations(UAnnotated annotationOwner, ProblemsHolder holder, Class<T> referenceClass) {
        return JpaInspectionUtil.checkMemberAnnotations(annotationOwner, holder, referenceClass, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    public static <T extends PsiReference & EmptyResolveMessageProvider> boolean checkMemberAnnotations(UAnnotated annotationOwner, ProblemsHolder holder, Class<T> referenceClass, ProblemHighlightType highlightType) {
        Ref hasErrors = new Ref((Object)Boolean.FALSE);
        Processor processor = t -> {
            boolean badResolve;
            boolean bl = !t.isSoft() && (t instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)t).multiResolve(false).length == 0 : t.resolve() == null) ? true : (badResolve = false);
            if (badResolve) {
                String message = MessageFormat.format(((EmptyResolveMessageProvider)t).getUnresolvedMessagePattern(), t.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(t.getElement(), t.getRangeInElement(), message, highlightType, holder.isOnTheFly(), ((LocalQuickFixProvider)t).getQuickFixes()));
                hasErrors.set((Object)Boolean.TRUE);
                return true;
            }
            return true;
        };
        StreamEx.of((Collection)annotationOwner.getUAnnotations()).map(uAnnotation -> uAnnotation.getSourcePsi()).nonNull().flatMap(annotation -> JpaInspectionUtil.getAllInjectionHosts(annotation).stream()).forEach(literal -> JpaUtil.processReferencesOfType(literal.getReferences(), referenceClass, processor));
        return (Boolean)hasErrors.get() == false;
    }

    private static List<PsiLanguageInjectionHost> getAllInjectionHosts(PsiElement annotation) {
        SmartList hosts = new SmartList();
        annotation.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((List)hosts){
            final /* synthetic */ List val$hosts;
            {
                this.val$hosts = list;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    this.val$hosts.add((PsiLanguageInjectionHost)element);
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/JpaInspectionUtil$1", "visitElement"));
            }
        });
        return hosts;
    }

    public static AccessType getMemberAccessType(PsiElement psiElement) {
        if (!(psiElement instanceof PsiMember)) {
            return null;
        }
        PsiMember getter = (PsiMember)psiElement;
        String accessAnnotationFqn = JpaAnnotationConstants.ACCESS_ANNO.fqn((PsiElement)getter);
        PsiAnnotation psiAnnotation = getter.getAnnotation(accessAnnotationFqn);
        if (psiAnnotation == null) {
            PsiField field = PropertyUtilBase.findPropertyFieldByMember((PsiMember)getter);
            if (field == null) {
                return null;
            }
            psiAnnotation = field.getAnnotation(accessAnnotationFqn);
        }
        if (psiAnnotation == null) {
            return null;
        }
        return (AccessType)PersistentObjectImpl.ACCESS_VALUE_ATTR_META.getJam(PsiElementRef.real((PsiElement)psiAnnotation), (Enum)AccessType.FIELD).getValue();
    }

    public static boolean checkMethodParameters(UMethod uMethod, ProblemsHolder holder, PsiType ... types) {
        boolean result = true;
        List parameters = uMethod.getUastParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            UParameter uParameter = (UParameter)parameters.get(i);
            PsiElement anchorSourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)uParameter);
            if (anchorSourcePsi == null) continue;
            PsiType parameterType = uParameter.getType();
            if (i < types.length) {
                PsiType type = types[i];
                if (parameterType.equals(type)) continue;
                holder.registerProblem(anchorSourcePsi, JpaHighlightingMessages.message("method.0.should.take.parameter.of.type.1.here", uMethod.getName(), type.getPresentableText()), JpaInspectionUtil.createChangeParameterByIndexFix(uMethod.getJavaPsi(), i, type));
                result = false;
                continue;
            }
            holder.registerProblem(anchorSourcePsi, JpaHighlightingMessages.message("method.0.should.take.1.parameters.only", uMethod.getName(), types.length), new LocalQuickFix[]{QuickFixFactory.getInstance().createRemoveUnusedParameterFix((PsiParameter)uParameter.getJavaPsi())});
            result = false;
        }
        if (parameters.size() < types.length) {
            PsiElement methodSourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)uMethod);
            if (methodSourcePsi == null) {
                return true;
            }
            holder.registerProblem(methodSourcePsi, JpaHighlightingMessages.message("method.0.should.take.parameter.of.type.1.here", uMethod.getName(), types[parameters.size()].getPresentableText()), JpaInspectionUtil.createChangeParameterByIndexFix(uMethod.getJavaPsi(), parameters.size(), types[parameters.size()]));
            result = false;
        }
        return result;
    }

    private static LocalQuickFix[] createChangeParameterByIndexFix(PsiMethod psiMethod, int parameterIndex, PsiType updatedType) {
        SmartPsiElementPointer elementPointer = SmartPointerManager.createPointer((PsiElement)psiMethod);
        return IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createChangeParametersActions((JvmMethod)psiMethod, (ChangeParametersRequest)MethodRequestsKt.updateMethodParametersRequest(() -> (JvmMethod)elementPointer.getElement(), existingParameters -> {
            if (parameterIndex < existingParameters.size()) {
                String parameterName = (String)((Object)((ExpectedParameter)existingParameters.get(parameterIndex)).getSemanticNames().stream().findFirst().orElse(DEFAULT_PARAMETER_NAME + parameterIndex));
                existingParameters.set(parameterIndex, ParametersKt.expectedParameter((JvmType)updatedType, (String[])new String[]{parameterName}));
            } else {
                existingParameters.add(parameterIndex, ParametersKt.expectedParameter((JvmType)updatedType, (String[])new String[]{DEFAULT_PARAMETER_NAME}));
            }
            return existingParameters;
        })), (PsiFile)psiMethod.getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public static boolean checkMethodReturnType(UMethod uMethod, ProblemsHolder holder, PsiType returnType) {
        if (!returnType.equals(uMethod.getReturnType())) {
            PsiElement anchor;
            UTypeReferenceExpression returnTypeReference = uMethod.getReturnTypeReference();
            PsiElement sourcePsi = returnTypeReference == null ? uMethod.getSourcePsi() : returnTypeReference.getSourcePsi();
            PsiElement psiElement = anchor = sourcePsi == null ? UDeclarationKt.getAnchorPsi((UDeclaration)uMethod) : sourcePsi;
            if (anchor == null) {
                return false;
            }
            holder.registerProblem(anchor, JpaHighlightingMessages.message("method.0.should.return.1", uMethod.getName(), returnType.getCanonicalText()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodReturnFix(uMethod.getJavaPsi(), returnType, false)});
            return false;
        }
        return true;
    }

    public static boolean checkNoArgConstructorExists(UClass aClass, ProblemsHolder holder, UastVisibility ... allowedModifiers) {
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance((PsiElement)aClass.getJavaPsi());
        if (templateHelper != null && templateHelper.isDontNeedNoArgConstructor(aClass)) {
            return true;
        }
        List constructors = (List)((StreamEx)StreamEx.of((Object[])aClass.getMethods()).filter(method -> method.isConstructor())).collect(Collectors.toList());
        if (constructors.isEmpty()) {
            return true;
        }
        boolean isNoArgConstructorPresent = StreamEx.of((Collection)constructors).findAny(constructor -> constructor.getUastParameters().isEmpty() && ContainerUtil.newHashSet((Object[])allowedModifiers).contains(constructor.getVisibility())).isPresent();
        if (isNoArgConstructorPresent) {
            return true;
        }
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)aClass);
        if (sourcePsi == null) {
            return true;
        }
        holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("class.0.should.have.1.no.arg.constructor", aClass.getName(), Arrays.asList(allowedModifiers)), IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createConstructorActions((JvmClass)aClass.getJavaPsi(), (CreateConstructorRequest)MethodRequestsKt.constructorRequest((Project)sourcePsi.getProject(), (List)ContainerUtil.emptyList())), (PsiFile)sourcePsi.getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY));
        return false;
    }

    public static boolean checkClassExtends(PsiClass aClass, String baseClass, boolean shouldExtend, PsiElement anchor, ProblemsHolder holder) {
        if (anchor == null || aClass == null) {
            return false;
        }
        PsiClass aBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(baseClass, GlobalSearchScope.allScope((Project)aClass.getProject()));
        if (aBaseClass == null) {
            return false;
        }
        if (aClass.isInheritor(aBaseClass, true) != shouldExtend) {
            String message = aClass.isInterface() ? JpaHighlightingMessages.message(shouldExtend ? "interface.should.extend" : "interface.should.not.extend", aClass.getName(), baseClass) : (aBaseClass.isInterface() == aClass.isInterface() ? JpaHighlightingMessages.message(shouldExtend ? "class.should.extend" : "class.should.not.extend", aClass.getName(), baseClass) : JpaHighlightingMessages.message(shouldExtend ? "class.should.implement" : "class.should.not.implement", aClass.getName(), baseClass));
            if ("java.io.Serializable".equals(baseClass)) {
                holder.registerProblem(anchor, message, new LocalQuickFix[]{new MakeEmbeddableEntitySerializableFix(anchor.getText())});
            } else {
                holder.registerProblem(anchor, message, new LocalQuickFix[0]);
            }
            return true;
        }
        return false;
    }

    public static UTypeReferenceExpression getMemberTypeReference(UDeclaration memberDeclaration) {
        UDeclaration typeDeclaration = JpaInspectionUtil.findActualMemberTypeDeclaration(memberDeclaration);
        if (typeDeclaration instanceof UVariable) {
            return ((UVariable)typeDeclaration).getTypeReference();
        }
        if (typeDeclaration instanceof UMethod) {
            return ((UMethod)typeDeclaration).getReturnTypeReference();
        }
        return null;
    }

    public static PsiType getMemberType(UDeclaration memberDeclaration) {
        UDeclaration typeDeclaration = JpaInspectionUtil.findActualMemberTypeDeclaration(memberDeclaration);
        if (typeDeclaration instanceof UVariable) {
            return ((UVariable)typeDeclaration).getType();
        }
        if (typeDeclaration instanceof UMethod) {
            return ((UMethod)typeDeclaration).getReturnType();
        }
        return null;
    }

    private static UDeclaration findActualMemberTypeDeclaration(UDeclaration memberDeclaration) {
        if (memberDeclaration instanceof UVariable) {
            return memberDeclaration;
        }
        if (memberDeclaration instanceof UMethod) {
            List uastParameters = ((UMethod)memberDeclaration).getUastParameters();
            if (uastParameters.isEmpty()) {
                return memberDeclaration;
            }
            if (uastParameters.size() == 1) {
                return (UDeclaration)uastParameters.get(0);
            }
            return null;
        }
        return null;
    }
}

