/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.DeploymentCache;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class LoadFilesAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(LoadFilesAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            LoadFilesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadFilesAction.$$$reportNull$$$0(1);
        }
        boolean invokedAtRemoteBrowser = e.getData(WebDeploymentDataKeys.SERVER_TREE) != null;
        Collection<WebServerGroupingWrap> wraps = LoadFilesAction.getExtraWraps(e, invokedAtRemoteBrowser, this.isChooseServer(), this.isHandleVcsChanges());
        if (!this.isChooseServer()) {
            if (invokedAtRemoteBrowser) {
                e.getPresentation().setText(this.getLoadHereMessage());
            } else if (!wraps.isEmpty()) {
                e.getPresentation().setText(this.getLoadToServerMessage(wraps.iterator().next()));
            }
        }
        e.getPresentation().setEnabled(!wraps.isEmpty());
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(!wraps.isEmpty());
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected abstract Supplier<String> getLoadHereMessage();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected abstract Supplier<String> getLoadToServerMessage(WebServerGroupingWrap var1);

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected abstract String getServerChooserTitle();

    @NotNull
    static Collection<WebServerGroupingWrap> getExtraWraps(AnActionEvent e, boolean invokedAtRemoteBrowser, boolean chooseServer, boolean handleVcsChanges) {
        Collection<Object> wraps;
        if (chooseServer && invokedAtRemoteBrowser) {
            wraps = Collections.emptyList();
        } else {
            Project project;
            wraps = LoadFilesAction.isEnabled(e, chooseServer, handleVcsChanges);
            if (chooseServer && wraps.size() == 1 && e.isFromContextMenu() && ((WebServerGroupingWrap)wraps.iterator().next()).isSingleServer() && ((project = e.getProject()) == null || PublishConfig.getInstance(project).getDefaultServerOrGroupName() != null && StringUtil.equals((CharSequence)((WebServerGroupingWrap)wraps.iterator().next()).getName(), (CharSequence)PublishConfig.getInstance(project).getDefaultServerOrGroupName()))) {
                wraps = Collections.emptyList();
            }
        }
        List<WebServerGroupingWrap> list = wraps;
        if (list == null) {
            LoadFilesAction.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected boolean isChooseServer() {
        return false;
    }

    protected boolean isHandleVcsChanges() {
        return true;
    }

    @NotNull
    private static Collection<WebServerGroupingWrap> isEnabled(AnActionEvent e, boolean chooseServer, boolean handleVcsChanged) {
        Change[] changes;
        if ("RemoteHostDialogPopup".equals(e.getPlace())) {
            List<WebServerGroupingWrap> list = Collections.emptyList();
            if (list == null) {
                LoadFilesAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault()) {
            List<WebServerGroupingWrap> list = Collections.emptyList();
            if (list == null) {
                LoadFilesAction.$$$reportNull$$$0(4);
            }
            return list;
        }
        PublishConfig publishConfig2 = PublishConfig.getInstance(project);
        if (handleVcsChanged && (changes = (Change[])e.getData(VcsDataKeys.CHANGES)) != null) {
            return LoadFilesAction.findSuitableWraps(project, publishConfig2, changes, chooseServer);
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files != null) {
            return LoadFilesAction.findSuitableWraps(project, publishConfig2, files, chooseServer);
        }
        FileObject[] nodes = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (nodes != null) {
            Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
            LOG.assertTrue(server != null);
            if (server.validateFast() != null) {
                List<WebServerGroupingWrap> list = Collections.emptyList();
                if (list == null) {
                    LoadFilesAction.$$$reportNull$$$0(5);
                }
                return list;
            }
            for (FileObject node : nodes) {
                if (publishConfig2.getNearestMappingDeploy2Local(node, false, (Mappable)server).getFirst() == null && ((List)publishConfig2.getChildMappingsDeploy2Local(node, (Mappable)server).getFirst()).isEmpty()) continue;
                List<WebServerGroupingWrap> list = Collections.singletonList(WebServerGroupingWrap.wrap(server.computeWebServerConfig()));
                if (list == null) {
                    LoadFilesAction.$$$reportNull$$$0(6);
                }
                return list;
            }
        }
        List<WebServerGroupingWrap> list = Collections.emptyList();
        if (list == null) {
            LoadFilesAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static Collection<WebServerGroupingWrap> findWraps(@NotNull Project project, @NotNull PublishConfig publishConfig2, @NotNull Condition<WebServerConfig> include, boolean chooseServer) {
        List wraps;
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(8);
        }
        if (publishConfig2 == null) {
            LoadFilesAction.$$$reportNull$$$0(9);
        }
        if (include == null) {
            LoadFilesAction.$$$reportNull$$$0(10);
        }
        if (chooseServer) {
            wraps = GroupedServersConfigManager.getInstance(project).getGroupedServers();
        } else {
            WebServerGroupingWrap wrap = publishConfig2.findDefaultServerOrGroupAsWrap();
            wraps = ContainerUtil.createMaybeSingletonList((Object)wrap);
        }
        ArrayList<WebServerGroupingWrap> result = new ArrayList<WebServerGroupingWrap>();
        block0: for (WebServerGroupingWrap wrap : wraps) {
            for (WebServerConfig server : wrap.getServers()) {
                if (!server.needsTransfer() || server.getFileTransferConfig().validateFast() != null || !include.value((Object)server)) continue;
                result.add(wrap);
                continue block0;
            }
        }
        ArrayList<WebServerGroupingWrap> arrayList = result;
        if (arrayList == null) {
            LoadFilesAction.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static Collection<WebServerGroupingWrap> findSuitableWraps(@NotNull Project project, @NotNull PublishConfig publishConfig2, VirtualFile @NotNull [] roots, boolean chooseServer) {
        DeploymentCache deploymentCache;
        Collection<WebServerGroupingWrap> wraps;
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(12);
        }
        if (publishConfig2 == null) {
            LoadFilesAction.$$$reportNull$$$0(13);
        }
        if (roots == null) {
            LoadFilesAction.$$$reportNull$$$0(14);
        }
        if ((wraps = (deploymentCache = DeploymentCache.getInstance(project)).getSuitableWrapsForFiles(publishConfig2, chooseServer, roots)) != null) {
            Collection<WebServerGroupingWrap> collection = wraps;
            if (collection == null) {
                LoadFilesAction.$$$reportNull$$$0(15);
            }
            return collection;
        }
        wraps = LoadFilesAction.findWraps(project, publishConfig2, (Condition<WebServerConfig>)((Condition)server -> LoadFilesAction.checkServer(publishConfig2, server, roots)), chooseServer);
        deploymentCache.setSuitableWrapsForFiles(publishConfig2, chooseServer, roots, wraps);
        Collection<WebServerGroupingWrap> collection = wraps;
        if (collection == null) {
            LoadFilesAction.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    private static Collection<WebServerGroupingWrap> findSuitableWraps(@NotNull Project project, @NotNull PublishConfig publishConfig2, Change @NotNull [] changes, boolean chooseServer) {
        DeploymentCache deploymentCache;
        Collection<WebServerGroupingWrap> servers;
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(17);
        }
        if (publishConfig2 == null) {
            LoadFilesAction.$$$reportNull$$$0(18);
        }
        if (changes == null) {
            LoadFilesAction.$$$reportNull$$$0(19);
        }
        if ((servers = (deploymentCache = DeploymentCache.getInstance(project)).getSuitableWrapsForChanges(publishConfig2, chooseServer, changes)) != null) {
            Collection<WebServerGroupingWrap> collection = servers;
            if (collection == null) {
                LoadFilesAction.$$$reportNull$$$0(20);
            }
            return collection;
        }
        servers = LoadFilesAction.findWraps(project, publishConfig2, (Condition<WebServerConfig>)((Condition)server -> LoadFilesAction.checkServer(publishConfig2, server, changes)), chooseServer);
        deploymentCache.setSuitableWrapsForChanges(publishConfig2, chooseServer, changes, servers);
        Collection<WebServerGroupingWrap> collection = servers;
        if (collection == null) {
            LoadFilesAction.$$$reportNull$$$0(21);
        }
        return collection;
    }

    private static boolean checkServer(PublishConfig publishConfig2, WebServerConfig server, Change[] changes) {
        for (Change change : changes) {
            ContentRevision afterRevision;
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (!(beforeRevision != null ? publishConfig2.getNearestMappingForLocal(beforeRevision.getFile().getPath(), false, true, false, (Mappable)server).getFirst() != null : (afterRevision = change.getAfterRevision()) != null && publishConfig2.getNearestMappingForLocal(afterRevision.getFile().getPath(), false, true, false, (Mappable)server).getFirst() != null)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkServer(PublishConfig publishConfig2, WebServerConfig server, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            if (!PublishActionUtil.checkMapping(publishConfig2, server, root.getPath(), true)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Collection<WebServerGroupingWrap> servers;
        Project project;
        if (e == null) {
            LoadFilesAction.$$$reportNull$$$0(22);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        PublishConfig publishConfig2 = PublishConfig.getInstance(project);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        FileObject[] remoteFiles = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        VfsUtilCore.DistinctVFilesRootsCollection roots = files != null ? new VfsUtilCore.DistinctVFilesRootsCollection(files) : null;
        RemoteConnection connection = (RemoteConnection)e.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        if (changes != null) {
            servers = LoadFilesAction.findSuitableWraps(project, publishConfig2, changes, this.isChooseServer());
        } else if (files != null) {
            servers = LoadFilesAction.findSuitableWraps(project, publishConfig2, files, this.isChooseServer());
        } else {
            Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
            if (server == null) {
                return;
            }
            servers = Collections.singletonList(WebServerGroupingWrap.wrap(server.computeWebServerConfig()));
        }
        LOG.assertTrue(!servers.isEmpty());
        if (servers.size() == 1 && !this.isChooseServer()) {
            this.execute(project, publishConfig2, servers.iterator().next(), changes, changeLists, remoteFiles, connection, (Collection<VirtualFile>)roots);
        } else {
            PublishActionUtil.chooseServerFromWraps(publishConfig2, servers, e, this.getServerChooserTitle(), true).onSuccess(arg_0 -> this.lambda$actionPerformed$2(project, publishConfig2, changes, changeLists, remoteFiles, connection, (Collection)roots, arg_0));
        }
    }

    protected void execute(@NotNull Project project, final PublishConfig publishConfig2, @NotNull WebServerGroupingWrap wrap, Change[] changes, ChangeList[] changeLists, FileObject[] remoteFiles, @Nullable RemoteConnection connection, Collection<VirtualFile> roots) {
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(23);
        }
        if (wrap == null) {
            LoadFilesAction.$$$reportNull$$$0(24);
        }
        Condition condition = changes != null ? server -> LoadFilesAction.checkServer(publishConfig2, server, changes) : (roots != null ? server -> LoadFilesAction.checkServer(publishConfig2, server, roots.toArray(VirtualFile.EMPTY_ARRAY)) : serverConfig -> true);
        for (WebServerConfig server2 : wrap.getServers()) {
            int result;
            if (!server2.needsTransfer()) continue;
            String validationError = server2.getFileTransferConfig().validateFast();
            if (validationError != null) {
                FileTransferToolWindow.printWithTimestamp(project, server2, WDBundle.message("server.is.not.configured.properly.0", validationError), ConsoleViewContentType.ERROR_OUTPUT, publishConfig2.getTraceLevel());
                continue;
            }
            if (!condition.value((Object)server2)) {
                FileTransferToolWindow.printWithTimestamp(project, server2, WDBundle.message("server.is.ignored.no.related.mappings.found", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT, publishConfig2.getTraceLevel());
                continue;
            }
            if (this.supportConfirmation() && publishConfig2.isConfirmBeforeUploading() && (result = Messages.showYesNoCancelDialog((String)WDBundle.message("confirm.before.files.uploading.message", server2.getName()), (String)WDBundle.message("confirm.before.files.uploading.title", new Object[0]), (String)WDBundle.message("confirm.before.files.uploading.yes", new Object[0]), (String)WDBundle.message("confirm.before.files.uploading.no", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    if (exitCode == 0 && isSelected) {
                        publishConfig2.setConfirmBeforeUploading(false);
                    }
                }
            })) != 0) {
                return;
            }
            this.execute(project, publishConfig2, Deployable.create(server2, project), changes, changeLists, remoteFiles, connection, roots);
        }
    }

    protected boolean supportConfirmation() {
        return false;
    }

    protected abstract void execute(@NotNull Project var1, PublishConfig var2, @NotNull Deployable var3, Change[] var4, ChangeList[] var5, FileObject[] var6, @Nullable RemoteConnection var7, Collection<VirtualFile> var8);

    private /* synthetic */ void lambda$actionPerformed$2(Project project, PublishConfig publishConfig2, Change[] changes, ChangeList[] changeLists, FileObject[] remoteFiles, RemoteConnection connection, Collection roots, WebServerGroupingWrap server) {
        this.execute(project, publishConfig2, server, changes, changeLists, remoteFiles, connection, (Collection<VirtualFile>)roots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 8, 9, 10, 12, 13, 14, 17, 18, 19, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraWraps";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "isEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findWraps";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableWraps";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findWraps";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableWraps";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 8, 9, 10, 12, 13, 14, 17, 18, 19, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }
}

