/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.AbstractSimpleLocalModel;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalAnnotationModel
extends AbstractSimpleLocalModel<PsiClass> {
    @NotNull
    private final PsiClass myClass;
    @NotNull
    protected final Module myModule;
    @NotNull
    protected final Set<String> myActiveProfiles;
    protected final boolean myTestContext;
    private final CachedValue<Collection<ContextJavaBean>> myLocalContextBeansCachedValue;
    private final CachedValue<Set<Pair<LocalModel<?>, LocalModelDependency>>> myDependentLocalModelsCachedValue;
    private final boolean myDeclaredInLibrary;

    public LocalAnnotationModel(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            LocalAnnotationModel.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            LocalAnnotationModel.$$$reportNull$$$0(2);
        }
        this(aClass, module, activeProfiles, false);
    }

    public LocalAnnotationModel(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles, boolean textContext) {
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(3);
        }
        if (module == null) {
            LocalAnnotationModel.$$$reportNull$$$0(4);
        }
        if (activeProfiles == null) {
            LocalAnnotationModel.$$$reportNull$$$0(5);
        }
        this.myClass = aClass;
        this.myModule = module;
        this.myActiveProfiles = Set.copyOf(activeProfiles);
        this.myDeclaredInLibrary = LocalAnnotationModel.isDeclaredInLibraries(this.myClass);
        this.myTestContext = textContext;
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.myClass.getProject());
        this.myLocalContextBeansCachedValue = cachedValuesManager.createCachedValue(() -> {
            List beans = JamService.getJamService((Project)this.myClass.getProject()).getAnnotatedMembersList(this.myClass, ContextJavaBean.BEAN_JAM_KEY, 10);
            if (this.myDeclaredInLibrary) {
                return CachedValueProvider.Result.createSingleDependency((Object)beans, (Object)JavaLibraryModificationTracker.getInstance((Project)this.myClass.getProject()));
            }
            HashSet dependencies = ContainerUtil.newHashSet((Object[])new PsiFile[]{this.myClass.getContainingFile()});
            for (ContextJavaBean bean : beans) {
                if (!bean.isValid()) continue;
                ContainerUtil.addIfNotNull((Collection)dependencies, (Object)bean.getContainingFile());
            }
            return CachedValueProvider.Result.create((Object)beans, (Collection)dependencies);
        });
        this.myDependentLocalModelsCachedValue = cachedValuesManager.createCachedValue(() -> {
            Set<Pair<LocalModel<?>, LocalModelDependency>> models = this.findDependentLocalModels();
            if (this.myDeclaredInLibrary) {
                return CachedValueProvider.Result.createSingleDependency(models, (Object)JavaLibraryModificationTracker.getInstance((Project)this.myClass.getProject()));
            }
            LinkedHashSet dependencies = new LinkedHashSet();
            ContainerUtil.addAll(dependencies, (Object[])LocalAnnotationModel.getOutsideModelDependencies(this));
            for (Pair<LocalModel<?>, LocalModelDependency> pair : models) {
                LocalModel dependencyModel = (LocalModel)pair.first;
                if (dependencyModel instanceof LocalAnnotationModel && ((LocalAnnotationModel)dependencyModel).isDeclaredInLibrary()) continue;
                dependencies.add(dependencyModel.getConfig());
            }
            return CachedValueProvider.Result.create(models, dependencies);
        });
    }

    @Override
    @NotNull
    public Direction traverseByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor2) {
        if (params == null) {
            LocalAnnotationModel.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            LocalAnnotationModel.$$$reportNull$$$0(7);
        }
        if (!params.canSearch()) {
            Direction direction = Direction.PROCEED;
            if (direction == null) {
                LocalAnnotationModel.$$$reportNull$$$0(8);
            }
            return direction;
        }
        if (this.myDeclaredInLibrary && !params.isSearchInLibraries()) {
            Direction direction = Direction.PROCEED;
            if (direction == null) {
                LocalAnnotationModel.$$$reportNull$$$0(9);
            }
            return direction;
        }
        if (!this.processLocalBeansByClass(params, processor2)) {
            Direction direction = Direction.STOP;
            if (direction == null) {
                LocalAnnotationModel.$$$reportNull$$$0(10);
            }
            return direction;
        }
        Direction direction = Direction.TRAVERSE;
        if (direction == null) {
            LocalAnnotationModel.$$$reportNull$$$0(11);
        }
        return direction;
    }

    @Override
    @NotNull
    public Direction traverseConfigDependencies(@NotNull Processor<? super PsiFile> processor2) {
        if (processor2 == null) {
            LocalAnnotationModel.$$$reportNull$$$0(12);
        }
        if (this.myDeclaredInLibrary) {
            Direction direction = Direction.PROCEED;
            if (direction == null) {
                LocalAnnotationModel.$$$reportNull$$$0(13);
            }
            return direction;
        }
        Direction direction = Direction.TRAVERSE;
        if (direction == null) {
            LocalAnnotationModel.$$$reportNull$$$0(14);
        }
        return direction;
    }

    private static boolean isDeclaredInLibraries(@NotNull PsiClass myClass) {
        VirtualFile virtualFile;
        if (myClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(15);
        }
        if (myClass instanceof PsiCompiledElement) {
            return true;
        }
        boolean isInLibrary = false;
        PsiFile containingFile = myClass.getContainingFile();
        if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null) {
            isInLibrary = ProjectScope.getLibrariesScope((Project)myClass.getProject()).contains(virtualFile);
        }
        return isInLibrary;
    }

    @Override
    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(16);
        }
        return psiClass;
    }

    @Override
    public Collection<SpringBeanPointer<?>> getLocalBeans() {
        SmartList allBeans = new SmartList();
        ContainerUtil.addIfNotNull((Collection)allBeans, (Object)this.getBeanForClass(this.myClass));
        ContainerUtil.addAllNotNull((Collection)allBeans, SpringProfileUtils.filterBeansInActiveProfiles((Collection)this.myLocalContextBeansCachedValue.getValue(), this.getActiveProfiles()));
        return BeanService.getInstance().mapSpringBeans((Collection<? extends CommonSpringBean>)allBeans);
    }

    @Nullable
    private CommonSpringBean getBeanForClass(@NotNull PsiClass aClass) {
        CommonSpringBean jamBean;
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(17);
        }
        if ((jamBean = (CommonSpringBean)JamService.getJamService((Project)aClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)aClass)) != null) {
            return jamBean;
        }
        if (this.myDeclaredInLibrary) {
            return (CommonSpringBean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)LocalAnnotationModel.buildCustomSpringBean(aClass), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)aClass.getProject())}));
        }
        return (CommonSpringBean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)LocalAnnotationModel.buildCustomSpringBean(aClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static CommonSpringBean buildCustomSpringBean(@NotNull PsiClass aClass) {
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(18);
        }
        if (!aClass.isInterface() && !aClass.hasModifierProperty("abstract") && SpringCommonUtils.isSpringBeanCandidateClass(aClass)) {
            return new CustomSpringComponent(aClass);
        }
        return null;
    }

    @Override
    public Set<CommonSpringModel> getRelatedModels() {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        ContainerUtil.addAllNotNull(models, this.getRelatedLocalModels());
        ContainerUtil.addAllNotNull(models, this.getCachedPackageScanModel());
        ContainerUtil.addAllNotNull(models, this.getCachedInnerStaticClassConfigurations());
        ContainerUtil.addAllNotNull(models, (Object[])new CommonSpringModel[]{this.getCustomDiscoveredBeansModel()});
        return models;
    }

    @NotNull
    private Set<CommonSpringModel> getCachedPackageScanModel() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.getPackageScanModels(this), (Object[])LocalAnnotationModel.getOutsideModelDependencies(this)));
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    protected Set<CommonSpringModel> getPackageScanModels(@NotNull LocalAnnotationModel localModel) {
        if (localModel == null) {
            LocalAnnotationModel.$$$reportNull$$$0(20);
        }
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        Module module = localModel.getModule();
        for (SpringBeansPackagesScan scan : localModel.getPackagesScans()) {
            models.add(new SpringComponentScanModel<SpringBeansPackagesScan>(module, scan, localModel.getActiveProfiles(), this.myTestContext));
        }
        if (models.size() <= 1) {
            Set<CommonSpringModel> set = Set.copyOf(models);
            if (set == null) {
                LocalAnnotationModel.$$$reportNull$$$0(21);
            }
            return set;
        }
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            LocalAnnotationModel.$$$reportNull$$$0(22);
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<CommonSpringModel> getCachedInnerStaticClassConfigurations() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.getInnerStaticClassConfigurations(this.getConfig()), (Object[])LocalAnnotationModel.getOutsideModelDependencies(this)));
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(23);
        }
        return set;
    }

    private Set<CommonSpringModel> getInnerStaticClassConfigurations(@NotNull PsiClass config) {
        if (config == null) {
            LocalAnnotationModel.$$$reportNull$$$0(24);
        }
        return LocalAnnotationModel.getInnerStaticClassModels(config, aClass -> this.getLocalAnnotationModel((PsiClass)aClass));
    }

    public static Set<CommonSpringModel> getInnerStaticClassModels(@NotNull PsiClass config, Function<? super PsiClass, ? extends CommonSpringModel> mapper) {
        if (config == null) {
            LocalAnnotationModel.$$$reportNull$$$0(25);
        }
        return Arrays.stream(config.getAllInnerClasses()).filter(psiClass -> psiClass.hasModifierProperty("static") && JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) != null).map(mapper).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            LocalAnnotationModel.$$$reportNull$$$0(26);
        }
        return module;
    }

    @Override
    @NotNull
    public Set<String> getProfiles() {
        LinkedHashSet<String> allProfiles = new LinkedHashSet<String>();
        SpringConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            allProfiles.addAll(configuration.getProfile().getNames());
            for (SpringJavaBean springJavaBean : configuration.getBeans()) {
                allProfiles.addAll(springJavaBean.getProfile().getNames());
            }
        }
        LinkedHashSet<String> linkedHashSet = allProfiles;
        if (linkedHashSet == null) {
            LocalAnnotationModel.$$$reportNull$$$0(27);
        }
        return linkedHashSet;
    }

    @Nullable
    private SpringConfiguration getConfiguration() {
        return (SpringConfiguration)JamService.getJamService((Project)this.myClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)this.myClass);
    }

    @Override
    @NotNull
    public List<SpringBeansPackagesScan> getPackagesScans() {
        SmartList packageScans = new SmartList();
        packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(this.myClass));
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)this.myClass)) {
            if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
            packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(superClass));
        }
        SmartList smartList = packageScans;
        if (smartList == null) {
            LocalAnnotationModel.$$$reportNull$$$0(28);
        }
        return smartList;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(29);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Pair<LocalModel<?>, LocalModelDependency>> getDependentLocalModels() {
        Set set = (Set)this.myDependentLocalModelsCachedValue.getValue();
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(30);
        }
        return set;
    }

    private Set<Pair<LocalModel<?>, LocalModelDependency>> findDependentLocalModels() {
        Module module = this.getModule();
        HashSet models = new HashSet();
        if (!module.isDisposed()) {
            this.collectImportDependentLocalModels(models);
            this.collectScanDependentLocalModels(models);
            SpringJamUtils springJamUtils = SpringJamUtils.getInstance();
            springJamUtils.processCustomAnnotations(this.myClass, (Processor<Pair<PsiClass, LocalModelDependency>>)((Processor)enableAnnotation -> {
                LocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel((PsiClass)enableAnnotation.getFirst()), (LocalModelDependency)enableAnnotation.getSecond());
                return true;
            }));
            springJamUtils.processCustomDependentLocalModels(this, (model, dependency) -> {
                LocalAnnotationModel.addNotNullModel(models, model, dependency);
                return true;
            });
        }
        return models;
    }

    private void collectImportDependentLocalModels(Set<Pair<LocalModel<?>, LocalModelDependency>> models) {
        Module module = this.getModule();
        this.collectImportDependentLocalModels(models, module, this.myClass);
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)this.myClass)) {
            if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
            this.collectImportDependentLocalModels(models, module, superClass);
        }
    }

    private void collectImportDependentLocalModels(Set<Pair<LocalModel<?>, LocalModelDependency>> models, Module module, PsiClass psiClass) {
        SpringJamUtils.getInstance().processImportedResources(psiClass, (Processor<Pair<List<XmlFile>, ? extends PsiElement>>)((Processor)pair -> {
            for (XmlFile xmlFile : (List)pair.first) {
                LocalAnnotationModel.addNotNullModel(models, SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(xmlFile, module, this.getActiveProfiles()), LocalModelDependency.create(LocalModelDependencyType.IMPORT, (PsiElement)pair.second));
            }
            return true;
        }), this.myModule);
        SpringJamUtils.getInstance().processImportedClasses(psiClass, (Processor<Pair<PsiClass, ? extends PsiElement>>)((Processor)pair -> {
            LocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel((PsiClass)pair.first), LocalModelDependency.create(LocalModelDependencyType.IMPORT, (PsiElement)pair.second));
            return true;
        }));
    }

    private void collectScanDependentLocalModels(Set<Pair<LocalModel<?>, LocalModelDependency>> models) {
        Module module = this.getModule();
        List<SpringBeansPackagesScan> scans = this.getPackagesScans();
        for (SpringBeansPackagesScan packagesScan : scans) {
            if (module.isDisposed()) break;
            Set<CommonSpringBean> beans = packagesScan.getScannedElements(module, this.myTestContext);
            for (CommonSpringBean bean : beans) {
                String className;
                SpringStereotypeElement stereotypeElement;
                PsiClass psiClass;
                if (!(bean instanceof SpringStereotypeElement) || !SpringCommonUtils.isSpringBeanCandidateClass(psiClass = (stereotypeElement = (SpringStereotypeElement)bean).getPsiElement()) || JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass) == null || !SpringProfileUtils.isInActiveProfiles(stereotypeElement, this.getActiveProfiles())) continue;
                PsiElement identifyingElementForDependency = packagesScan.getIdentifyingPsiElement();
                if (identifyingElementForDependency == null && (className = psiClass.getQualifiedName()) != null) {
                    Set<PsiPackage> packages = packagesScan.getPsiPackages();
                    for (PsiPackage psiPackage : packages) {
                        if (!psiPackage.containsClassNamed(className)) continue;
                        identifyingElementForDependency = psiPackage;
                        break;
                    }
                }
                if (identifyingElementForDependency == null) {
                    identifyingElementForDependency = psiClass;
                }
                LocalModelDependency dependency = LocalModelDependency.create(LocalModelDependencyType.COMPONENT_SCAN, identifyingElementForDependency);
                LocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel(stereotypeElement.getPsiElement()), dependency);
            }
        }
    }

    @Nullable
    protected LocalAnnotationModel getLocalAnnotationModel(@NotNull PsiClass aClass) {
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(31);
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(aClass, this.getModule(), this.getActiveProfiles());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalAnnotationModel)) {
            return false;
        }
        LocalAnnotationModel model = (LocalAnnotationModel)o;
        if (!this.myClass.equals(model.myClass)) {
            return false;
        }
        if (!this.myModule.equals(model.myModule)) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString(model.myActiveProfiles));
    }

    public int hashCode() {
        int result2 = this.myClass.hashCode();
        result2 = 31 * result2 + this.myModule.hashCode();
        int profilesHashCode = 0;
        for (String profile : this.myActiveProfiles) {
            if (profile.equals("_DEFAULT_PROFILE_NAME_")) continue;
            profilesHashCode += profile.hashCode();
        }
        result2 = 31 * result2 + profilesHashCode;
        return result2;
    }

    @Override
    protected Collection<Object> getCachingProcessorsDependencies() {
        if (this.myDeclaredInLibrary) {
            return Collections.singleton(JavaLibraryModificationTracker.getInstance((Project)this.myClass.getProject()));
        }
        HashSet<Object> dependencies = new HashSet<Object>();
        Collections.addAll(dependencies, SpringModificationTrackersManager.getInstance(this.myClass.getProject()).getOuterModelsDependencies());
        Collections.addAll(dependencies, Arrays.stream(this.myClass.getSupers()).map(aClass -> aClass.getContainingFile()).filter(psiFile -> psiFile != null && !(psiFile instanceof ClsFileImpl)).toArray());
        return dependencies;
    }

    @Override
    @NotNull
    public final List<SpringBeanPointer<?>> findQualified(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            LocalAnnotationModel.$$$reportNull$$$0(32);
        }
        List<SpringBeanPointer<?>> list = LocalAnnotationModel.findLocalBeansByQualifier(this, qualifier);
        if (list == null) {
            LocalAnnotationModel.$$$reportNull$$$0(33);
        }
        return list;
    }

    public boolean isDeclaredInLibrary() {
        return this.myDeclaredInLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 13, 14, 16, 19, 21, 22, 23, 26, 27, 28, 29, 30, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/LocalAnnotationModel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/LocalAnnotationModel";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseByClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseConfigDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPackageScanModel";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageScanModels";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInnerStaticClassConfigurations";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesScans";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "traverseByClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "traverseConfigDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredInLibraries";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBeanForClass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildCustomSpringBean";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPackageScanModels";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStaticClassConfigurations";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStaticClassModels";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModel";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findQualified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 13, 14, 16, 19, 21, 22, 23, 26, 27, 28, 29, 30, 33 -> new IllegalStateException(string);
        };
    }
}

