/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.jam.JamService;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.gutter.BeanInjectionTargetPresentationRenderer;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.SpringDumbAutowiredLineMarkerInfo;
import com.intellij.spring.gutter.SpringDumbModeLineMarkers;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringBeanFactoryUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringAutowiredAnnotator
extends SpringAnnotatorBase
implements DumbAware {
    public String getId() {
        return "SpringAutowiredAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.autowired.annotator.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.ShowAutowiredDependencies;
        if (icon == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        PsiElement first;
        if (elements == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(2);
        }
        if ((first = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        if (DumbService.isDumb((Project)first.getProject())) {
            SpringAutowiredAnnotator.annotateInDumbMode(elements, result2);
        } else {
            super.collectSlowLineMarkers(elements, result2);
        }
    }

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        UMethod uMethod;
        UElement element;
        if (psiElement == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(4);
        }
        if ((element = UastUtils.getUParentForIdentifier((PsiElement)psiElement)) == null) {
            UMethod kotlinPrimaryConstructor = SpringAutowiredAnnotator.getKotlinPrimaryConstructor(psiElement);
            if (kotlinPrimaryConstructor != null) {
                if (!(psiElement instanceof PsiNameIdentifierOwner)) {
                    return;
                }
                PsiNameIdentifierOwner nameIdentifierOwner = (PsiNameIdentifierOwner)psiElement;
                PsiElement nameIdentifier = nameIdentifierOwner.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                this.annotateMethod(kotlinPrimaryConstructor, nameIdentifier, result2);
            }
            return;
        }
        if (element instanceof UMethod && !SpringAutowiredAnnotator.isKotlinPrimaryConstructor(uMethod = (UMethod)element)) {
            this.annotateMethod(uMethod, psiElement, result2);
            return;
        }
        if (element instanceof UField) {
            UField field = (UField)element;
            SpringAutowiredAnnotator.annotateField(result2, field);
            return;
        }
        if (element instanceof UParameter) {
            UElement parent = element.getUastParent();
            if (parent instanceof UMethod) {
                UMethod method = (UMethod)parent;
                SpringAutowiredAnnotator.processAnnotatedMethod(method, psiElement, result2);
            }
            return;
        }
        if (element instanceof UReferenceExpression) {
            element = element.getUastParent();
        }
        if (element instanceof UAnnotation) {
            UAnnotation annotation = (UAnnotation)element;
            SpringAutowiredAnnotator.annotateAnnotation(psiElement, result2, annotation);
        }
    }

    @Nullable
    private static UMethod getKotlinPrimaryConstructor(@Nullable PsiElement element) {
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)element, UClass.class);
        if (uClass == null) {
            return null;
        }
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class);
        if (uMethod == null || !uMethod.isConstructor()) {
            return null;
        }
        return uMethod;
    }

    private static boolean isKotlinPrimaryConstructor(@NotNull UMethod uMethod) {
        UClass uClass;
        PsiElement psiClass;
        UMethod constructor;
        if (uMethod == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(5);
        }
        return (constructor = SpringAutowiredAnnotator.getKotlinPrimaryConstructor(psiClass = UElementKt.getSourcePsiElement((UElement)(uClass = UastUtils.getContainingUClass((UElement)uMethod))))) != null && constructor.getJavaPsi() == uMethod.getJavaPsi();
    }

    private static void annotateInDumbMode(List<? extends PsiElement> elements, Collection<? super LineMarkerInfo<?>> result2) {
        Module module = DumbAwareLineMarkerUtilsKt.findModuleForElementWhenDumb((PsiElement)((PsiElement)ContainerUtil.getFirstItem(elements)));
        if (module == null || !SpringCommonUtils.isSpringConfigured(module)) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            UMethod uMethod;
            UClass uClass;
            UElement parent;
            PsiElement psiElement = elements.get(i);
            UElement uElement = DumbAwareLineMarkerUtilsKt.getUParentForIdentifierDumbAware((PsiElement)psiElement, (boolean)true);
            if (uElement instanceof UField) {
                UField uField = (UField)uElement;
                UClass uClass2 = UastUtils.getContainingUClass((UElement)uField);
                if (uClass2 == null || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)uClass2, SpringDumbModeLineMarkers.COMPONENT_ANNOTATION_SHORTNAMES) || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)uField, SpringDumbModeLineMarkers.AUTOWIRING_ANNOTATION_SHORTNAMES) && (!uField.isFinal() || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)uClass2, SpringDumbModeLineMarkers.LOMBOK_REQUIRED_ARGS_ANNOTATION_SHORTNAMES))) continue;
                result2.add((LineMarkerInfo<?>)new SpringDumbAutowiredLineMarkerInfo(psiElement));
                continue;
            }
            if (!(uElement instanceof UParameter) || !((parent = uElement.getUastParent()) instanceof UMethod) || (uClass = UastUtils.getContainingUClass((UElement)(uMethod = (UMethod)parent))) == null || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)uClass, SpringDumbModeLineMarkers.COMPONENT_ANNOTATION_SHORTNAMES)) continue;
            if (uMethod.isConstructor()) {
                long constructorCount;
                if (uMethod.getJavaPsi().hasModifier(JvmModifier.PRIVATE) || (constructorCount = Arrays.stream(uClass.getMethods()).filter(UMethod::isConstructor).count()) != 1L) continue;
                result2.add((LineMarkerInfo<?>)new SpringDumbAutowiredLineMarkerInfo(psiElement));
                continue;
            }
            if (!DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)uMethod, SpringDumbModeLineMarkers.BEAN_ANNOTATION_SHORTNAMES)) continue;
            result2.add((LineMarkerInfo<?>)new SpringDumbAutowiredLineMarkerInfo(psiElement));
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        PsiMethod method;
        PsiClass psiClass;
        if (uMethod == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(6);
        }
        if ((psiClass = (method = uMethod.getJavaPsi()).getContainingClass()) == null) {
            return;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass)) {
            return;
        }
        if (SpringCommonUtils.isStereotypeComponentOrMeta(psiClass)) {
            return;
        }
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
            SpringJavaClassInfo.MappedBeanInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve();
            if (info.isAutowired()) {
                SpringAutowiredAnnotator.checkAutowiredMethod(method, result2, info, identifier);
            }
        } else if (uMethod.isConstructor()) {
            PsiIdentifier nameIdentifier;
            SpringJavaClassInfo.MappedBeanInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve();
            if (info.isMappedConstructor(method)) {
                SpringAutowiredAnnotator.addConstructorArgsGutterIcon(result2, identifier, NotNullLazyValue.lazy(() -> SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve().getMappedConstructorDefinitions(method)));
            } else if (uMethod.getJavaPsi().getModifierList().hasModifierProperty("public") && info.isStereotypeJavaBean() && (nameIdentifier = uMethod.getJavaPsi().getNameIdentifier()) != null) {
                SpringAutowiredAnnotator.addStereotypeBeanFactoryCallsGutterIcon(result2, uMethod.getJavaPsi(), (PsiElement)nameIdentifier);
            }
        }
    }

    private static void annotateAnnotation(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, UAnnotation uAnnotation) {
        UElement annotatedElement;
        if (psiElement == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(8);
        }
        if ((annotatedElement = uAnnotation.getUastParent()) instanceof UMethod) {
            UAnnotation annotationFromBean;
            UMethod uMethod = (UMethod)annotatedElement;
            PsiMethod method = uMethod.getJavaPsi();
            if (method.isConstructor() || PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
                return;
            }
            ContextJavaBean bean = SpringAutowiredAnnotator.getStereotypeBean(method);
            if (bean != null && Objects.equals(annotationFromBean = (UAnnotation)UastContextKt.toUElement((PsiElement)bean.getPsiAnnotation(), UAnnotation.class), uAnnotation)) {
                result2.add(SpringAutowiredAnnotator.getNavigateToAutowiredCandidatesBuilder((PsiMember)method, Objects.requireNonNull(method.getReturnType())).createSpringGroupLineMarkerInfo(psiElement));
            }
        }
    }

    private static ContextJavaBean getStereotypeBean(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(9);
        }
        return (ContextJavaBean)JamService.getJamService((Project)method.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)method);
    }

    private static void checkAutowiredMethod(@NotNull PsiMethod method, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, SpringJavaClassInfo.MappedBeanInfo info, @NotNull PsiElement identifier) {
        if (method == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(11);
        }
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(12);
        }
        for (Autowire autowire : info.getAutowires()) {
            if (autowire == Autowire.BY_TYPE) {
                PsiType type = PropertyUtilBase.getPropertyType((PsiMember)method);
                if (type == null) continue;
                SpringAutowiredAnnotator.processVariable(method.getContainingClass(), (PsiModifierListOwner)method, result2, identifier, type);
                continue;
            }
            if (autowire != Autowire.BY_NAME) continue;
            SpringAutowiredAnnotator.annotateByNameAutowiredMethod((PsiJvmMember)method, result2, identifier);
        }
    }

    private static void annotateByNameAutowiredMethod(@NotNull PsiJvmMember owner, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull PsiElement identifier) {
        if (owner == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(14);
        }
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(15);
        }
        NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(() -> {
            CommonSpringModel model = SpringAutowireUtil.getProcessingSpringModel(owner.getContainingClass());
            if (model == null) {
                return Collections.emptyList();
            }
            return SpringAutowiredAnnotator.getByNameAutowiredBean((PsiModifierListOwner)owner, model);
        }, result2, identifier, SpringBundle.message("navigate.to.by.name.autowired.dependencies", new Object[0]));
    }

    private static Collection<SpringBeanPointer<?>> getByNameAutowiredBean(@NotNull PsiModifierListOwner owner, @NotNull CommonSpringModel model) {
        SpringBeanPointer<?> bean;
        if (owner == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(16);
        }
        if (model == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(17);
        }
        String name = null;
        if (owner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            name = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method);
        } else if (owner instanceof PsiField) {
            PsiField field = (PsiField)owner;
            name = field.getName();
        }
        if (name != null && (bean = SpringModelSearchers.findBean(model, name)) != null) {
            return Collections.singleton(bean.getBasePointer());
        }
        return Collections.emptySet();
    }

    private static void annotateField(Collection<? super RelatedItemLineMarkerInfo<?>> result2, UField uField) {
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)uField.getUastAnchor());
        if (identifier == null) {
            return;
        }
        PsiField field = (PsiField)UElementKt.getAsJavaPsiElement((UElement)uField, PsiField.class);
        if (field == null) {
            return;
        }
        if (SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)field) || SpringAutowireUtil.isAutowiredInNonPhysicalConstructor(field)) {
            SpringAutowiredAnnotator.processVariable(field.getContainingClass(), (PsiModifierListOwner)field, result2, identifier, field.getType());
        }
    }

    private static void processAnnotatedMethod(@NotNull UMethod uMethod, @NotNull PsiElement identifier, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        block4: {
            PsiMethod method;
            block5: {
                if (uMethod == null) {
                    SpringAutowiredAnnotator.$$$reportNull$$$0(18);
                }
                if (identifier == null) {
                    SpringAutowiredAnnotator.$$$reportNull$$$0(19);
                }
                if (result2 == null) {
                    SpringAutowiredAnnotator.$$$reportNull$$$0(20);
                }
                if (!SpringAutowireUtil.isInjectionPoint(method = uMethod.getJavaPsi())) break block4;
                if (SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)method) == null || !PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) break block5;
                UParameter uParameter = (UParameter)uMethod.getUastParameters().get(0);
                if (identifier != UElementKt.getSourcePsiElement((UElement)uParameter.getUastAnchor())) break block4;
                SpringAutowiredAnnotator.processVariable(method.getContainingClass(), (PsiModifierListOwner)method, result2, identifier, uParameter.getType());
                break block4;
            }
            for (UParameter parameter : uMethod.getUastParameters()) {
                if (identifier != UElementKt.getSourcePsiElement((UElement)parameter.getUastAnchor())) continue;
                PsiParameter psiParameter = (PsiParameter)UElementKt.getAsJavaPsiElement((UElement)parameter, PsiParameter.class);
                if (psiParameter == null) break;
                SpringAutowiredAnnotator.processVariable(method.getContainingClass(), (PsiModifierListOwner)psiParameter, result2, identifier, parameter.getType());
                break;
            }
        }
    }

    private static void processVariable(@Nullable PsiClass containingClass, @NotNull PsiModifierListOwner variable, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull PsiElement identifier, @NotNull PsiType type) {
        if (variable == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(22);
        }
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(23);
        }
        if (type == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(24);
        }
        NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(() -> {
            CommonSpringModel model = SpringAutowireUtil.getProcessingSpringModel(containingClass);
            if (model == null) {
                return Collections.emptyList();
            }
            return SpringAutowireUtil.getAutowiredBeansFor(variable, SpringAutowireUtil.getAutowiredType(type), model);
        }, result2, identifier);
    }

    public static SpringGutterIconBuilder<PsiElement> getNavigateToAutowiredCandidatesBuilder(@NotNull PsiMember psiMember, @NotNull PsiType type) {
        if (psiMember == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(25);
        }
        if (type == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(26);
        }
        SpringGutterIconBuilder<PsiElement> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.ShowAutowiredCandidates);
        builder.setPopupTitle(SpringBundle.message("gutter.choose.autowired.candidates.title", new Object[0])).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.autowired.candidates", new Object[0])).setTooltipText(SpringBundle.message("gutter.navigate.to.autowired.candidates.title", new Object[0])).setTargetRenderer(BeanInjectionTargetPresentationRenderer::new).setTargets(NotNullLazyValue.lazy(() -> {
            if (!psiMember.isValid()) {
                return Collections.emptySet();
            }
            Module moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
            if (moduleForPsiElement != null) {
                return SpringAutowireUtil.getAutowiredMembers(type, moduleForPsiElement, psiMember);
            }
            LinkedHashSet<PsiModifierListOwner> members = new LinkedHashSet<PsiModifierListOwner>();
            for (Module module : SpringCommonUtils.getRelatedModules(psiMember.getContainingFile())) {
                members.addAll(SpringAutowireUtil.getAutowiredMembers(type, module, psiMember));
            }
            return members;
        }));
        return builder;
    }

    private static void addStereotypeBeanFactoryCallsGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull PsiMethod method, @NotNull PsiElement identifier) {
        if (method == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(27);
        }
        if (identifier == null) {
            SpringAutowiredAnnotator.$$$reportNull$$$0(28);
        }
        if (!method.isConstructor()) {
            return;
        }
        Module moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)method);
        if (moduleForPsiElement == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createType(containingClass);
        Set<PsiElement> callsForBean = SpringBeanFactoryUtils.findBeanFactoryCallsForBean(moduleForPsiElement, (PsiType)psiClassType, method.getName(), SpringBeanFactoryUtils.getParamTypes(method));
        if (callsForBean.isEmpty()) {
            return;
        }
        SpringGutterIconBuilder<PsiElement> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.ShowAutowiredCandidates);
        builder.setPopupTitle(SpringBundle.message("gutter.choose.bean.factory.calls.title", new Object[0])).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.bean.factory.calls", new Object[0])).setTooltipText(SpringBundle.message("gutter.navigate.to.bean.factory.calls.title", new Object[0])).setTargets(callsForBean);
        result2.add(builder.createSpringRelatedMergeableLineMarkerInfo(identifier));
    }

    private static void addConstructorArgsGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result2, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer<?>>> targets) {
        SpringGutterIconBuilder<SpringBeanPointer<?>> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.SpringBeanMethod, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.AUTOWIRED_BEAN_POINTER_GOTO_PROVIDER);
        builder.setTargets(targets).setTargetRenderer(SpringBeansPsiElementCellRenderer::new).setPopupTitle(SpringBundle.message("spring.bean.constructor.navigate.choose.class.title", new Object[0])).setTooltipText(SpringBundle.message("spring.bean.constructor.tooltip.navigate.declaration", new Object[0]));
        result2.add(builder.createSpringRelatedMergeableLineMarkerInfo(psiIdentifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringAutowiredAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 9: 
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 15: 
            case 19: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringAutowiredAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isKotlinPrimaryConstructor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "annotateAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeBean";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkAutowiredMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "annotateByNameAutowiredMethod";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getByNameAutowiredBean";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processAnnotatedMethod";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNavigateToAutowiredCandidatesBuilder";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addStereotypeBeanFactoryCallsGutterIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28 -> new IllegalArgumentException(string);
        };
    }
}

