/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.facet.FacetFinder;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.PomTarget;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PomTargetPsiElementImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SimpleSpringBeanPointer;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringImplicitBeanWithDefinition;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointerImpl;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomSpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointerImpl;
import com.intellij.spring.model.xml.SpringBeanDomPointerImpl;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class BeanServiceImpl
extends BeanService {
    @Override
    public Collection<PsiType> getEffectiveBeanTypes(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            BeanServiceImpl.$$$reportNull$$$0(0);
        }
        Project project = bean.getPsiManager().getProject();
        return this.getEffectiveTypesMap(project).getOrDefault(bean, Collections.emptyList());
    }

    @NotNull
    private Map<CommonSpringBean, Collection<PsiType>> getEffectiveTypesMap(Project project) {
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(this::computeEffectiveBeanTypes);
            return CachedValueProvider.Result.create((Object)map, BeanServiceImpl.getBeanTypesDependencies(project));
        });
        if (map == null) {
            BeanServiceImpl.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    public Collection<PsiType> computeEffectiveBeanTypes(@NotNull CommonSpringBean bean) {
        SpringBeanEffectiveTypeProvider provider;
        if (bean == null) {
            BeanServiceImpl.$$$reportNull$$$0(2);
        }
        LinkedHashSet effectiveTypes = new LinkedHashSet(1);
        ContainerUtil.addIfNotNull(effectiveTypes, (Object)bean.getBeanType());
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        Iterator iterator = SpringBeanEffectiveTypeProvider.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (provider = (SpringBeanEffectiveTypeProvider)iterator.next()).processEffectiveTypes(bean, (Processor<PsiType>)collectProcessor)) {
        }
        ContainerUtil.addAllNotNull(effectiveTypes, (Iterable)collectProcessor.getResults());
        List<PsiType> list = List.copyOf(effectiveTypes);
        if (list == null) {
            BeanServiceImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static List<ModificationTracker> getBeanTypesDependencies(@NotNull Project project) {
        if (project == null) {
            BeanServiceImpl.$$$reportNull$$$0(4);
        }
        SpringModificationTrackersManager trackersManager = SpringModificationTrackersManager.getInstance(project);
        return List.of(UastModificationTracker.getInstance((Project)project), JavaLibraryModificationTracker.getInstance((Project)project), trackersManager.getProfilesModificationTracker(), trackersManager.getMultipleContextsModificationTracker(), FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
    }

    @Override
    @NotNull
    public SpringBeanPointer<?> createSpringBeanPointer(@NotNull CommonSpringBean springBean) {
        if (springBean == null) {
            BeanServiceImpl.$$$reportNull$$$0(5);
        }
        if (springBean instanceof DomSpringBean) {
            if (springBean instanceof SpringBean) {
                return new SpringBeanDomPointerImpl((SpringBean)springBean);
            }
            return new DomSpringBeanPointerImpl((DomSpringBean)springBean);
        }
        if (springBean instanceof JamPsiMemberSpringBean) {
            return new JamSpringBeanPointerImpl((JamPsiMemberSpringBean)springBean);
        }
        if (springBean instanceof CustomBean) {
            CustomSpringBeanPointer customSpringBeanPointer = CustomSpringBeanPointer.createCustomSpringBeanPointer((CustomBean)springBean);
            if (customSpringBeanPointer == null) {
                BeanServiceImpl.$$$reportNull$$$0(6);
            }
            return customSpringBeanPointer;
        }
        if (springBean instanceof SpringImplicitBeanWithDefinition) {
            return new SimpleSpringBeanPointer<SpringImplicitBeanWithDefinition>((SpringImplicitBeanWithDefinition)springBean);
        }
        throw new AssertionError((Object)("Unknown bean type: " + String.valueOf(springBean)));
    }

    @Override
    @NotNull
    public PsiElement convertToPsi(@NotNull DomSpringBean springBean) {
        if (springBean == null) {
            BeanServiceImpl.$$$reportNull$$$0(7);
        }
        DomSpringBeanPsiTarget target = new DomSpringBeanPsiTarget(springBean);
        return new DomSpringBeanTargetPsiElement(target.getNavigationElement().getProject(), target);
    }

    @Override
    @NotNull
    public Set<SpringBeanPointer<?>> mapSpringBeans(@NotNull Collection<? extends CommonSpringBean> beans) {
        if (beans == null) {
            BeanServiceImpl.$$$reportNull$$$0(8);
        }
        if (beans.isEmpty()) {
            Set<SpringBeanPointer<?>> set = Collections.emptySet();
            if (set == null) {
                BeanServiceImpl.$$$reportNull$$$0(9);
            }
            return set;
        }
        if (beans.size() == 1) {
            CommonSpringBean bean = beans.iterator().next();
            if (!bean.isValid()) {
                Set<SpringBeanPointer<?>> set = Collections.emptySet();
                if (set == null) {
                    BeanServiceImpl.$$$reportNull$$$0(10);
                }
                return set;
            }
            Set<SpringBeanPointer<?>> set = Collections.singleton(this.createSpringBeanPointer(bean));
            if (set == null) {
                BeanServiceImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        LinkedHashSet set = new LinkedHashSet(beans.size());
        for (CommonSpringBean commonSpringBean : beans) {
            if (!commonSpringBean.isValid()) continue;
            set.add(this.createSpringBeanPointer(commonSpringBean));
        }
        LinkedHashSet linkedHashSet = set;
        if (linkedHashSet == null) {
            BeanServiceImpl.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/BeanServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/BeanServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveTypesMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeEffectiveBeanTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpringBeanPointer";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapSpringBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveBeanTypes";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeEffectiveBeanTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBeanTypesDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSpringBeanPointer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsi";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapSpringBeans";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static final class DomSpringBeanPsiTarget
    extends DelegatePsiTarget
    implements SpringBeanPsiTarget {
        private final DomSpringBean mySpringBean;

        DomSpringBeanPsiTarget(DomSpringBean bean) {
            super((PsiElement)Objects.requireNonNull(bean.getXmlElement()));
            this.mySpringBean = bean;
        }

        public String toString() {
            return "DomSpringBeanPsiTarget(" + String.valueOf(this.mySpringBean) + ")";
        }

        public boolean isWritable() {
            return true;
        }

        public SpringBeanPsiTarget setName(@NotNull String newName) {
            if (newName == null) {
                DomSpringBeanPsiTarget.$$$reportNull$$$0(0);
            }
            this.mySpringBean.setName(newName);
            return this;
        }

        @Override
        public CommonSpringBean getSpringBean() {
            return this.mySpringBean;
        }

        public String getName() {
            return this.mySpringBean.getBeanName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/spring/model/BeanServiceImpl$DomSpringBeanPsiTarget", "setName"));
        }
    }

    private static final class DomSpringBeanTargetPsiElement
    extends PomTargetPsiElementImpl {
        DomSpringBeanTargetPsiElement(@NotNull Project project, @NotNull DomSpringBeanPsiTarget target) {
            if (project == null) {
                DomSpringBeanTargetPsiElement.$$$reportNull$$$0(0);
            }
            if (target == null) {
                DomSpringBeanTargetPsiElement.$$$reportNull$$$0(1);
            }
            super(project, (PomTarget)target);
        }

        public String getPresentableText() {
            return SpringPresentationProvider.getSpringBeanName(((DomSpringBeanPsiTarget)this.getTarget()).getSpringBean());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/model/BeanServiceImpl$DomSpringBeanTargetPsiElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

