/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.serialization.ClassUtil;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.ClassValueConverter;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.util.XmlUtil;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomNamespaceSpringBeanResolveQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    private static final Condition<QuickFixInfo> DEFINED_NAMESPACE_CONDITION = info -> info.namespaceResult == QuickFixInfo.NamespaceResult.DEFINED;

    CustomNamespaceSpringBeanResolveQuickFixProvider() {
    }

    private static QuickFixInfo getQuickFixInfo(XmlFile contextFile, DomCollectionChildDescription description, DomFileDescription<DomElement> domFileDescription) {
        String namespaceKey = description.getXmlName().getNamespaceKey();
        List namespaces = namespaceKey == null ? Collections.emptyList() : domFileDescription.getAllowedNamespaces(namespaceKey, contextFile);
        @NlsSafe String elementName = description.getXmlElementName();
        if (namespaces.isEmpty()) {
            return new QuickFixInfo(description, "<" + elementName + ">", QuickFixInfo.NamespaceResult.NOT_FOUND, null);
        }
        for (String namespace : namespaces) {
            String prefixByURI = XmlUtil.findNamespacePrefixByURI((XmlFile)contextFile, (String)namespace);
            if (prefixByURI == null) continue;
            Object namespacePrefixDisplay = !prefixByURI.isEmpty() ? prefixByURI + ":" : "";
            return new QuickFixInfo(description, "<" + (String)namespacePrefixDisplay + elementName + ">", QuickFixInfo.NamespaceResult.DEFINED, null);
        }
        String namespaceURI = (String)ContainerUtil.getFirstItem((List)namespaces);
        return new QuickFixInfo(description, "<" + elementName + "> (" + namespaceURI + ")", QuickFixInfo.NamespaceResult.UNDEFINED, namespaceURI);
    }

    private static void createCustomNamespaceBean(QuickFixInfo info, @Nullable Beans beans, String beanId) {
        if (beans == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)beans.getXmlElement())) {
            return;
        }
        if (info.namespaceResult == QuickFixInfo.NamespaceResult.UNDEFINED) {
            PsiFile file = beans.getXmlTag().getContainingFile();
            XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)file);
            extension.insertNamespaceDeclaration((XmlFile)file, null, Collections.singleton(info.namespaceURI), null, null);
        }
        DomSpringBean domSpringBean = (DomSpringBean)info.description.addValue((DomElement)beans);
        domSpringBean.getId().ensureXmlElementExists();
        domSpringBean.setName(beanId);
    }

    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        String stringValue;
        if (beans == null) {
            CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (requiredClasses.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        GenericDomValue value = (GenericDomValue)context.getInvocationElement();
        String string = stringValue = beanId != null ? beanId : value.getStringValue();
        if (stringValue == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        String id = stringValue.trim();
        if (StringUtil.isEmptyOrSpaces((String)id)) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        Module module = context.getModule();
        if (module == null || module.isDisposed()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        DomFileDescription domFileDescription = DomUtil.getFileElement((DomElement)beans).getFileDescription();
        XmlFile contextFile = context.getFile();
        Map<DomCollectionChildDescription, PsiClass> mappings = CustomNamespaceSpringBeanResolveQuickFixProvider.getAvailableDomToPsiClassMappings(beans, contextFile);
        List resolvedRequiredClasses = ContainerUtil.mapNotNull(requiredClasses, type -> {
            PsiClass resolve = type.resolve();
            if (resolve == null || "java.lang.Object".equals(resolve.getQualifiedName())) {
                return null;
            }
            return resolve;
        });
        SmartList quickFixInfos = new SmartList();
        block0: for (Map.Entry<DomCollectionChildDescription, PsiClass> mapping : mappings.entrySet()) {
            for (PsiClass required : resolvedRequiredClasses) {
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)mapping.getValue(), (PsiClass)required, (boolean)true)) continue;
                QuickFixInfo quickFixInfo = CustomNamespaceSpringBeanResolveQuickFixProvider.getQuickFixInfo(contextFile, mapping.getKey(), (DomFileDescription<DomElement>)domFileDescription);
                quickFixInfos.add(quickFixInfo);
                continue block0;
            }
        }
        List defined = ContainerUtil.filter((Collection)quickFixInfos, DEFINED_NAMESPACE_CONDITION);
        SmartList quickFixes = new SmartList();
        for (QuickFixInfo info : defined) {
            quickFixes.add(new CreateDefinedQuickFix(info, id));
        }
        quickFixInfos.removeAll(defined);
        if (!quickFixInfos.isEmpty()) {
            quickFixes.add(new CreateFromUndefinedNamespaceQuickFix((List<QuickFixInfo>)quickFixInfos, beans, id));
        }
        SmartList smartList = quickFixes;
        if (smartList == null) {
            CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static Map<DomCollectionChildDescription, PsiClass> getAvailableDomToPsiClassMappings(@NotNull Beans beans, @NotNull XmlFile contextFile) {
        if (beans == null) {
            CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(6);
        }
        if (contextFile == null) {
            CustomNamespaceSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(7);
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)contextFile, () -> {
            GlobalSearchScope searchScope = ClassValueConverter.getScope((Project)contextFile.getProject(), (Module)ModuleUtilCore.findModuleForFile((PsiFile)contextFile), (PsiFile)contextFile);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)contextFile.getProject());
            LinkedHashMap<DomCollectionChildDescription, PsiClass> result2 = new LinkedHashMap<DomCollectionChildDescription, PsiClass>();
            List descriptions = beans.getGenericInfo().getCollectionChildrenDescriptions();
            for (DomCollectionChildDescription description : descriptions) {
                Class clazz;
                BeanType beanType;
                Type childDescriptionType = description.getType();
                Class type = ClassUtil.getRawType((Type)childDescriptionType);
                if (!DomSpringBean.class.isAssignableFrom(type) || (beanType = (BeanType)DomReflectionUtil.findAnnotationDFS((Class)(clazz = (Class)childDescriptionType), BeanType.class)) == null) continue;
                PsiClass beanClass = null;
                if (!beanType.value().isEmpty()) {
                    String staticBeanClass = beanType.value();
                    beanClass = javaPsiFacade.findClass(staticBeanClass, searchScope);
                } else {
                    String candidateFqn;
                    Class<? extends BeanTypeProvider> provider = beanType.provider();
                    BeanTypeProvider provider1 = SpringCommonUtils.getBeanTypeProvider(provider);
                    String[] stringArray = provider1.getBeanTypeCandidates();
                    int n = stringArray.length;
                    for (int i = 0; i < n && (beanClass = javaPsiFacade.findClass(candidateFqn = stringArray[i], searchScope)) == null; ++i) {
                    }
                }
                if (beanClass == null) continue;
                result2.put(description, beanClass);
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{contextFile});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDomToPsiClassMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class QuickFixInfo {
        private final DomCollectionChildDescription description;
        private final @NlsContexts.ListItem String displayName;
        private final NamespaceResult namespaceResult;
        private final String namespaceURI;

        private QuickFixInfo(DomCollectionChildDescription domCollectionChildDescription, @NlsContexts.ListItem String name, NamespaceResult result2, String uri) {
            this.description = domCollectionChildDescription;
            this.displayName = name;
            this.namespaceResult = result2;
            this.namespaceURI = uri;
        }

        static enum NamespaceResult {
            NOT_FOUND,
            UNDEFINED,
            DEFINED;

        }
    }

    private static final class CreateDefinedQuickFix
    extends BeansAwareQuickFix
    implements HighPriorityAction {
        private final QuickFixInfo myQuickFixInfo;
        private final String myId;

        private CreateDefinedQuickFix(QuickFixInfo quickFixInfo, String id) {
            this.myQuickFixInfo = quickFixInfo;
            this.myId = id;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("custom.namespace.quick.fixes.create.name", this.myQuickFixInfo.displayName);
            if (string == null) {
                CreateDefinedQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("custom.namespace.quick.fixes.family.name", new Object[0]);
            if (string == null) {
                CreateDefinedQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateDefinedQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateDefinedQuickFix.$$$reportNull$$$0(3);
            }
            CustomNamespaceSpringBeanResolveQuickFixProvider.createCustomNamespaceBean(this.myQuickFixInfo, this.getBeansDomElement(descriptor), this.myId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateDefinedQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateDefinedQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class CreateFromUndefinedNamespaceQuickFix
    implements LocalQuickFix {
        private final List<QuickFixInfo> myQuickFixInfos;
        private final Beans myBeans;
        private final String myId;

        private CreateFromUndefinedNamespaceQuickFix(List<QuickFixInfo> infos, Beans beans, String id) {
            this.myQuickFixInfos = infos;
            this.myBeans = beans;
            this.myId = id;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("custom.namespace.quick.fixes.create.custom.namespace.bean", this.myQuickFixInfos.size());
            if (string == null) {
                CreateFromUndefinedNamespaceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("custom.namespace.quick.fixes.family.name", new Object[0]);
            if (string == null) {
                CreateFromUndefinedNamespaceQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                CreateFromUndefinedNamespaceQuickFix.$$$reportNull$$$0(2);
            }
            if (previewDescriptor == null) {
                CreateFromUndefinedNamespaceQuickFix.$$$reportNull$$$0(3);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateFromUndefinedNamespaceQuickFix.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateFromUndefinedNamespaceQuickFix.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                CreateFromUndefinedNamespaceQuickFix.$$$reportNull$$$0(6);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.doApplyFix((QuickFixInfo)ContainerUtil.getFirstItem(this.myQuickFixInfos), project);
                return;
            }
            BaseListPopupStep<QuickFixInfo> step = new BaseListPopupStep<QuickFixInfo>(SpringBundle.message("custom.namespace.quick.fixes.popup.title", new Object[0]), this.myQuickFixInfos, SpringApiIcons.SpringBean){

                @NotNull
                public String getTextFor(QuickFixInfo value) {
                    String string = value.displayName;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                public PopupStep<?> onChosen(QuickFixInfo selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        this.doApplyFix(selectedValue, project);
                    }
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix$1", "getTextFor"));
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
            popup.setAdText(SpringBundle.message("spring.bean.filter.tooltip", new Object[0]), 2);
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> popup.showInBestPositionFor(dataContext));
        }

        private void doApplyFix(QuickFixInfo selectedValue, Project project) {
            WriteCommandAction.writeCommandAction((Project)project).withName(SpringBundle.message("custom.namespace.quick.fixes.create.custom.namespace.bean.with.id", this.myId)).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> CustomNamespaceSpringBeanResolveQuickFixProvider.createCustomNamespaceBean(selectedValue, this.myBeans, this.myId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    protected static abstract class BeansAwareQuickFix
    implements LocalQuickFix {
        protected BeansAwareQuickFix() {
        }

        @Nullable
        protected Beans getBeansDomElement(@NotNull ProblemDescriptor descriptor) {
            DomElement domElement;
            if (descriptor == null) {
                BeansAwareQuickFix.$$$reportNull$$$0(0);
            }
            return (domElement = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement())) != null ? (Beans)DomUtil.getParentOfType((DomElement)domElement, Beans.class, (boolean)false) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$BeansAwareQuickFix", "getBeansDomElement"));
        }
    }
}

