/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringInspectionsRegistry;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringValidator
extends InspectionValidator {
    public SpringValidator() {
        super("Spring Model Validator", SpringApiBundle.message("model.inspection.validator.description.text", new Object[0]), SpringBundle.message("model.inspection.validator.progress.text", new Object[0]));
    }

    private static boolean isAvailableOnModule(Module module) {
        return SpringCommonUtils.isSpringConfigured(module);
    }

    public Class<? extends LocalInspectionTool> @NotNull [] getInspectionToolClasses(CompileContext context) {
        Class<? extends LocalInspectionTool>[] classArray = SpringInspectionsRegistry.getInstance().getSpringInspectionClasses();
        if (classArray == null) {
            SpringValidator.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            SpringValidator.$$$reportNull$$$0(1);
        }
        for (Module module : scope.getAffectedModules()) {
            if (!SpringValidator.isAvailableOnModule(module)) continue;
            return true;
        }
        return false;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
        for (Module module : context.getCompileScope().getAffectedModules()) {
            Set<SpringModel> models = SpringManager.getInstance(project).getAllModels(module);
            for (SpringModel model : models) {
                for (PsiFile configFile : SpringModelVisitorUtils.getConfigFiles(model)) {
                    VirtualFile file = configFile.getVirtualFile();
                    ContainerUtil.addIfNotNull(files, (Object)file);
                }
            }
        }
        for (SpringInspectionsRegistry.AdditionalFilesContributor additionalFilesContributor : SpringValidator.getAdditionalFilesContributors()) {
            files.addAll(additionalFilesContributor.getAdditionalFilesToProcess(project, context));
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(files, (CompileContext)context);
        return files;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile topFile) {
        LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel> additionalHighlighting = new LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel>();
        for (SpringInspectionsRegistry.AdditionalFilesContributor contributor : SpringValidator.getAdditionalFilesContributors()) {
            additionalHighlighting.putAll(contributor.checkAdditionally(topFile));
        }
        LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel> linkedHashMap = additionalHighlighting;
        if (linkedHashMap == null) {
            SpringValidator.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    private static SpringInspectionsRegistry.AdditionalFilesContributor @NotNull [] getAdditionalFilesContributors() {
        SpringInspectionsRegistry.AdditionalFilesContributor[] additionalFilesContributorArray = (SpringInspectionsRegistry.AdditionalFilesContributor[])SpringInspectionsRegistry.AdditionalFilesContributor.EP_NAME.getExtensions();
        if (additionalFilesContributorArray == null) {
            SpringValidator.$$$reportNull$$$0(3);
        }
        return additionalFilesContributorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/SpringValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/SpringValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAdditionally";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalFilesContributors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

