/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringDomProfile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Scope;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.xml.util.PsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicatedBeanNamesInspection
extends SpringBeanInspectionBase {
    @Override
    public void checkFileElement(@NotNull DomFileElement<Beans> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        XmlFile xmlFile;
        SpringModel model;
        if (domFileElement == null) {
            DuplicatedBeanNamesInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            DuplicatedBeanNamesInspection.$$$reportNull$$$0(1);
        }
        if ((model = SpringManager.getInstance((xmlFile = domFileElement.getFile()).getProject()).getSpringModelByFile((PsiFile)xmlFile)) == null) {
            return;
        }
        Beans beans = (Beans)domFileElement.getRootElement();
        DuplicatedBeanNamesInspection.checkRootBeans(holder, model, beans);
    }

    private static void checkRootBeans(DomElementAnnotationHolder holder, SpringModel model, Beans beans) {
        DuplicatedBeanNamesInspection.checkBeans(holder, model, beans);
        for (Beans beanProfiles : beans.getBeansProfiles()) {
            DuplicatedBeanNamesInspection.checkRootBeans(holder, model, beanProfiles);
        }
    }

    private static void checkBeans(DomElementAnnotationHolder holder, SpringModel model, Beans beans) {
        ArrayList allBeans = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(allBeans);
        SpringBeanUtils.getInstance().processChildBeans(beans, false, (Processor<CommonSpringBean>)processor2);
        SpringDomProfile profile = beans.getProfile();
        for (CommonSpringBean bean : allBeans) {
            if (!(bean instanceof DomSpringBean)) continue;
            DuplicatedBeanNamesInspection.checkBean((DomSpringBean)bean, holder, model, profile);
        }
        for (Alias alias : beans.getAliases()) {
            DuplicatedBeanNamesInspection.checkAlias(alias, holder, model, profile);
        }
    }

    private static void checkBean(DomSpringBean bean, DomElementAnnotationHolder holder, SpringModel springModel, @NotNull SpringProfile profile) {
        SpringBean springBean;
        GenericAttributeValue<List<String>> name;
        String value;
        LocalQuickFix[] fixes;
        GenericAttributeValue<String> beanId;
        String id;
        if (profile == null) {
            DuplicatedBeanNamesInspection.$$$reportNull$$$0(2);
        }
        if ((id = (beanId = bean.getId()).getStringValue()) != null && beanId.getAnnotation(Scope.class) == null && (fixes = DuplicatedBeanNamesInspection.getFixes(id, BeanService.getInstance().createSpringBeanPointer(bean), springModel, profile)).length > 0) {
            holder.createProblem(beanId, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.duplicate.bean.name", new Object[0]), fixes);
        }
        if (bean instanceof SpringBean && (value = (name = (springBean = (SpringBean)bean).getName()).getStringValue()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",; ");
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                LocalQuickFix[] fixes2 = DuplicatedBeanNamesInspection.getFixes(s, BeanService.getInstance().createSpringBeanPointer(bean), springModel, profile);
                if (fixes2.length <= 0) continue;
                holder.createProblem(name, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.duplicate.bean.name", new Object[0]), TextRange.from((int)(tokenizer.getCurrentPosition() - s.length() + 1), (int)s.length()), fixes2);
            }
        }
    }

    private static void checkAlias(Alias alias, DomElementAnnotationHolder holder, SpringModel model, SpringProfile profile) {
        LocalQuickFix[] fixes;
        GenericAttributeValue<String> value = alias.getAlias();
        String aliasName = value.getStringValue();
        if (aliasName != null && (fixes = DuplicatedBeanNamesInspection.getFixes(aliasName, (PsiElementPointer)alias.getAliasedBean().getValue(), model, profile)).length > 0) {
            holder.createProblem(value, HighlightSeverity.ERROR, SpringBundle.message("spring.bean.duplicate.bean.name", new Object[0]), fixes);
        }
    }

    private static LocalQuickFix[] getFixes(final String name, final PsiElementPointer bean, SpringModel model, SpringProfile profile) {
        if (bean == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        final Collection pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, name).stream().filter(pointer -> !pointer.equals(bean) && DuplicatedBeanNamesInspection.isPointerInTheSameProfiles(profile, pointer.getPsiElement())).collect(Collectors.toSet());
        if (pointers.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix fix2 = new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("duplicated.bean.name.inspection.name.view.duplicates", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                List duplications;
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((duplications = ContainerUtil.mapNotNull((Collection)pointers, (Function)new MyFunction(bean, name))).size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    NavigationUtil.getPsiElementPopup((PsiElement[])PsiUtilCore.toPsiElementArray((Collection)duplications), (String)SpringBundle.message("duplicated.bean.quick.fix.popup.title", new Object[0])).showInBestPositionFor(DataManager.getInstance().getDataContext());
                } else if (!duplications.isEmpty()) {
                    ((FakePsiElement)duplications.get(0)).navigate(true);
                }
            }

            @NotNull
            public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (previewDescriptor == null) {
                    1.$$$reportNull$$$0(4);
                }
                return new IntentionPreviewInfo.Html(SpringBundle.message("duplicated.bean.quick.fix.description", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/xml/DuplicatedBeanNamesInspection$1";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previewDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/DuplicatedBeanNamesInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "generatePreview";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3, 4 -> new IllegalArgumentException(string);
                };
            }
        };
        return new LocalQuickFix[]{fix2};
    }

    private static boolean isPointerInTheSameProfiles(@NotNull SpringProfile profile, @Nullable PsiElement pointerPsiElement) {
        if (profile == null) {
            DuplicatedBeanNamesInspection.$$$reportNull$$$0(3);
        }
        if (pointerPsiElement == null) {
            return false;
        }
        Set<String> profiles = profile.getExpressions();
        if (pointerPsiElement instanceof PsiMember && profiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(profiles.iterator().next())) {
            return true;
        }
        if (pointerPsiElement instanceof PomTargetPsiElement && (pointerPsiElement = pointerPsiElement.getNavigationElement()) == null) {
            return false;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)pointerPsiElement, XmlTag.class, (boolean)false);
        if (xmlTag == null) {
            return false;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)xmlTag);
        if (domElement == null) {
            return false;
        }
        Beans parentBeans = (Beans)DomUtil.getParentOfType((DomElement)domElement, Beans.class, (boolean)true);
        if (parentBeans == null) {
            return false;
        }
        for (String name : parentBeans.getProfile().getExpressions()) {
            if (!profiles.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/DuplicatedBeanNamesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFileElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBean";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPointerInTheSameProfiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFunction
    implements NullableFunction<PsiElementPointer, FakePsiElement> {
        private final PsiElementPointer myBean;
        private final String myName;

        MyFunction(PsiElementPointer bean, String name) {
            this.myBean = bean;
            this.myName = name;
        }

        public FakePsiElement fun(final PsiElementPointer pointer) {
            final PsiElement psiElement = pointer.getPsiElement();
            if (psiElement == null) {
                return null;
            }
            final PsiFile containingFile = psiElement.getContainingFile();
            return psiElement.equals(this.myBean.getPsiElement()) ? null : new FakePsiElement(){

                @NotNull
                public PsiElement getNavigationElement() {
                    PsiElement psiElement2 = psiElement;
                    if (psiElement2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiElement2;
                }

                public String getName() {
                    return myName;
                }

                public Icon getIcon(boolean open) {
                    return pointer instanceof SpringBeanPointer ? SpringPresentationProvider.getSpringIcon(pointer) : null;
                }

                public PsiElement getParent() {
                    return containingFile;
                }

                public String getLocationString() {
                    return "(" + containingFile.getName() + ")";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/xml/DuplicatedBeanNamesInspection$MyFunction$1", "getNavigationElement"));
                }
            };
        }
    }
}

