/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.transaction;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.transaction.SpringTransactionalComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public final class SpringTransactionalComponentInspection
extends SpringUastInspectionBase {
    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uMethod == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(1);
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        return SpringTransactionalComponentInspection.checkTransactional((SpringTransactionalComponent)SpringTransactionalComponent.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod), new ProblemsHolder(manager, psiMethod.getContainingFile(), isOnTheFly));
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uClass == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(3);
        }
        PsiClass aClass = uClass.getJavaPsi();
        return SpringTransactionalComponentInspection.checkTransactional((SpringTransactionalComponent)SpringTransactionalComponent.CLASS_META.getJamElement((PsiModifierListOwner)aClass), new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly));
    }

    private static ProblemDescriptor @Nullable [] checkTransactional(@Nullable SpringTransactionalComponent transactionConfiguration, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(4);
        }
        if (transactionConfiguration == null) {
            return null;
        }
        SpringTransactionalComponentInspection.checkSpringBeanPointerResolve(holder, transactionConfiguration.getValueAttributeElement());
        SpringTransactionalComponentInspection.checkSpringBeanPointerResolve(holder, transactionConfiguration.getTransactionManagerAttributeElement());
        return holder.getResultsArray();
    }

    private static void checkSpringBeanPointerResolve(@NotNull ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer<?>> attributeElement) {
        String beanPointerOrClassName;
        if (holder == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)(beanPointerOrClassName = attributeElement.getStringValue()))) {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(beanPointerOrClassName, GlobalSearchScope.allScope((Project)holder.getProject()));
            if (psiClass == null) {
                SpringBeanPointerResolveInspection.checkBeanPointerResolve(holder, attributeElement);
            } else {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
                if (module != null) {
                    if (SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_5_2)) {
                        SpringTransactionalComponentInspection.checkTransactionManagerClass(holder, attributeElement, psiClass, "org.springframework.transaction.TransactionManager");
                    } else {
                        SpringTransactionalComponentInspection.checkTransactionManagerClass(holder, attributeElement, psiClass, "org.springframework.transaction.PlatformTransactionManager");
                    }
                }
            }
        }
    }

    private static void checkTransactionManagerClass(@NotNull ProblemsHolder holder, @NotNull JamStringAttributeElement<SpringBeanPointer<?>> attributeElement, @NotNull PsiClass psiClass, @NotNull String transactionManager) {
        PsiElement problemPsiElement;
        if (holder == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(6);
        }
        if (attributeElement == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(8);
        }
        if (transactionManager == null) {
            SpringTransactionalComponentInspection.$$$reportNull$$$0(9);
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)transactionManager) && (problemPsiElement = SpringBeanPointerResolveInspection.getProblemPsiElement((PsiElement)attributeElement.getPsiElement())) != null) {
            holder.registerProblem(problemPsiElement, SpringApiBundle.message("bean.must.be.of.type", transactionManager), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transactionManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/jam/transaction/SpringTransactionalComponentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTransactional";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSpringBeanPointerResolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTransactionManagerClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

