/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure.logical.dependencies;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.extensions.mapStruct.SpringMapStructMapper;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.logical.OneOrManySpringBeansLogicalModel;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.logical.SpringBeansParentLogicalModel;
import com.intellij.spring.model.logical.SpringDebuggerLogicalInfoProvider;
import com.intellij.spring.model.structure.logical.dependencies.SpringAutowiredCollectionLogicalModel;
import com.intellij.spring.model.structure.logical.dependencies.SpringBeanAutowiresPresentationProvider;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelUtilsImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringBeanAutowiresPresentationProvider.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\"\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0002H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/model/structure/logical/dependencies/SpringBeanAutowiresProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/model/logical/OneOrManySpringBeansLogicalModel;", "<init>", "()V", "getElements", "", "parent", "getModelForType", "injectionPointOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "psiType", "Lcom/intellij/psi/PsiType;", "commonSpringModel", "Lcom/intellij/spring/CommonSpringModel;", "isApplicable", "", "getAutowiredBeans", "Lcom/intellij/spring/model/CommonSpringBean;", "autowiredType", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanAutowiresProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanAutowiresProvider.kt\ncom/intellij/spring/model/structure/logical/dependencies/SpringBeanAutowiresProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n865#3,2:109\n1563#3:111\n1634#3,3:112\n*S KotlinDebug\n*F\n+ 1 SpringBeanAutowiresProvider.kt\ncom/intellij/spring/model/structure/logical/dependencies/SpringBeanAutowiresProvider\n*L\n81#1:109,2\n95#1:111\n95#1:112,3\n*E\n"})
public final class SpringBeanAutowiresProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, OneOrManySpringBeansLogicalModel> {
    @NotNull
    public List<OneOrManySpringBeansLogicalModel> getElements(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Set<PsiVariable> injectionPoints = SpringAutowireUtil.getInjectionPoints(parent.getSpringBean());
        if (injectionPoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        CommonSpringModel commonSpringModel = SpringModelUtilsImpl.getInstance().getSpringModelByBean(parent.getSpringBean());
        Intrinsics.checkNotNullExpressionValue((Object)commonSpringModel, (String)"getSpringModelByBean(...)");
        CommonSpringModel commonSpringModel2 = commonSpringModel;
        List result2 = new ArrayList();
        for (PsiVariable collectInjectionPoint : injectionPoints) {
            OneOrManySpringBeansLogicalModel model;
            Intrinsics.checkNotNull((Object)collectInjectionPoint);
            PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)collectInjectionPoint;
            PsiType psiType = collectInjectionPoint.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            if (this.getModelForType(psiModifierListOwner, psiType, commonSpringModel2) == null) continue;
            result2.add(model);
        }
        return result2;
    }

    private final OneOrManySpringBeansLogicalModel getModelForType(PsiModifierListOwner injectionPointOwner, PsiType psiType, CommonSpringModel commonSpringModel) {
        PsiNamedElement psiNamedElement;
        ContextJavaBean contextJavaBean;
        Object object;
        Object innerClass;
        PsiType psiType2 = SpringAutowireUtil.getAutowiredType(psiType);
        Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getAutowiredType(...)");
        PsiType autowiredType = psiType2;
        List<CommonSpringBean> autowiredBeans = this.getAutowiredBeans(injectionPointOwner, autowiredType, commonSpringModel);
        if (autowiredBeans.isEmpty()) {
            return null;
        }
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        PsiClass autowiredClass = psiClassType != null ? psiClassType.resolve() : null;
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)injectionPointOwner.getProject()).findClass("java.util.Collection", GlobalSearchScope.allScope((Project)injectionPointOwner.getProject()));
        if (collectionClass != null) {
            PsiClass psiClass = autowiredClass;
            boolean bl = psiClass != null ? psiClass.isInheritor(collectionClass, true) : false;
            if (bl) {
                Set<SpringBeanPointer<?>> innerBeans;
                PsiWildcardType psiWildcardType;
                PsiType[] psiTypeArray = ((PsiClassType)psiType).getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
                PsiType psiType3 = (PsiType)ArraysKt.firstOrNull((Object[])psiTypeArray);
                if (psiType3 != null) {
                    PsiType it = psiType3;
                    boolean bl2 = false;
                    psiWildcardType = it instanceof PsiWildcardType ? (PsiWildcardType)it : null;
                    if (psiWildcardType == null || (psiWildcardType = psiWildcardType.getBound()) == null) {
                        psiWildcardType = it;
                    }
                } else {
                    psiWildcardType = null;
                }
                PsiWildcardType innerType = psiWildcardType;
                PsiClassType psiClassType2 = innerType instanceof PsiClassType ? (PsiClassType)innerType : null;
                innerClass = psiClassType2 != null ? psiClassType2.resolve() : null;
                PsiWildcardType psiWildcardType2 = innerType;
                if (psiWildcardType2 != null) {
                    PsiWildcardType it = psiWildcardType2;
                    boolean bl3 = false;
                    v9 = SpringAutowireUtil.getAutowiredBeansFor(injectionPointOwner, (PsiType)it, commonSpringModel);
                } else {
                    v9 = innerBeans = null;
                }
                if (innerClass != null && !((object = (Collection)innerBeans) == null || object.isEmpty())) {
                    return new SpringAutowiredCollectionLogicalModel(autowiredClass, (PsiMember)innerClass, autowiredBeans);
                }
            }
        }
        if (autowiredBeans.size() > 1) {
            return new SpringBeansParentLogicalModel(injectionPointOwner, autowiredBeans);
        }
        innerClass = CollectionsKt.firstOrNull(autowiredBeans);
        ContextJavaBean contextJavaBean2 = contextJavaBean = innerClass instanceof ContextJavaBean ? (ContextJavaBean)innerClass : null;
        if (autowiredType instanceof PsiPrimitiveType && contextJavaBean != null) {
            psiNamedElement = contextJavaBean.getIdentifyingPsiElement();
        } else {
            ContextJavaBean contextJavaBean3 = contextJavaBean;
            object = contextJavaBean3 != null ? contextJavaBean3.getIdentifyingPsiElement() : null;
            PsiMethod psiMethod = object instanceof PsiMethod ? (PsiMethod)object : null;
            if (psiMethod == null) {
                psiMethod = autowiredBeans.size() == 1 ? PsiTypesUtil.getPsiClass((PsiType)((CommonSpringBean)CollectionsKt.first(autowiredBeans)).getBeanType()) : autowiredClass;
            }
            psiNamedElement = (PsiNamedElement)psiMethod;
        }
        PsiNamedElement psiMember = psiNamedElement;
        return new SpringBeanLogicalModel((PsiElement)psiMember, (CommonSpringBean)CollectionsKt.first(autowiredBeans));
    }

    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Set<PsiVariable> set = SpringAutowireUtil.getInjectionPoints(parent.getSpringBean());
        Intrinsics.checkNotNullExpressionValue(set, (String)"getInjectionPoints(...)");
        return !((Collection)set).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommonSpringBean> getAutowiredBeans(PsiModifierListOwner injectionPointOwner, PsiType autowiredType, CommonSpringModel commonSpringModel) {
        void $this$mapTo$iv$iv;
        Object debuggerInfoProvider;
        Ref.ObjectRef autowiredBeanPointers = new Ref.ObjectRef();
        Set<SpringBeanPointer<?>> set = SpringAutowireUtil.getAutowiredBeansFor(injectionPointOwner, autowiredType, commonSpringModel);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAutowiredBeansFor(...)");
        autowiredBeanPointers.element = set;
        if (((Set)autowiredBeanPointers.element).size() > 1) {
            SpringDebuggerLogicalInfoProvider springDebuggerLogicalInfoProvider = SpringDebuggerLogicalInfoProvider.Companion.getInstance();
            if (springDebuggerLogicalInfoProvider != null) {
                void destination$iv;
                void $this$filterTo$iv;
                debuggerInfoProvider = springDebuggerLogicalInfoProvider;
                boolean bl = false;
                Iterable iterable = (Iterable)autowiredBeanPointers.element;
                Collection collection = new LinkedHashSet();
                Ref.ObjectRef objectRef = autowiredBeanPointers;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    SpringBeanPointer it = (SpringBeanPointer)element$iv;
                    boolean bl2 = false;
                    Object t = it.getSpringBean();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"getSpringBean(...)");
                    if (!(!Intrinsics.areEqual((Object)debuggerInfoProvider.isBeanLoaded((CommonSpringBean)t), (Object)false))) continue;
                    destination$iv.add(element$iv);
                }
                objectRef.element = destination$iv;
            }
        } else if (((Set)autowiredBeanPointers.element).size() == 1) {
            Object t = ((SpringBeanPointer)CollectionsKt.first((Iterable)((Iterable)autowiredBeanPointers.element))).getSpringBean();
            Intrinsics.checkNotNullExpressionValue(t, (String)"getSpringBean(...)");
            Object springBean = t;
            if (springBean instanceof SpringMapStructMapper) {
                List<CommonSpringBean> implementations;
                SpringDebuggerLogicalInfoProvider springDebuggerLogicalInfoProvider = SpringDebuggerLogicalInfoProvider.Companion.getInstance();
                List<CommonSpringBean> list = implementations = springDebuggerLogicalInfoProvider != null ? springDebuggerLogicalInfoProvider.findGeneratedImplementation((CommonSpringBean)springBean) : null;
                if (implementations != null && !((Collection)implementations).isEmpty()) {
                    return implementations;
                }
            }
        }
        Iterable $this$map$iv = (Iterable)autowiredBeanPointers.element;
        boolean $i$f$map = false;
        debuggerInfoProvider = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpringBeanPointer $i$f$filterTo = (SpringBeanPointer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.getSpringBean();
            Intrinsics.checkNotNullExpressionValue(t, (String)"getSpringBean(...)");
            collection.add(t);
        }
        return (List)destination$iv$iv;
    }
}

