/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.custom.CustomModuleComponentsDiscoverer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanPsiElement;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanContainer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanUtilsImpl
extends SpringBeanUtils {
    @Override
    @Nullable
    public CommonSpringBean findBean(@Nullable PomTarget target) {
        if (target instanceof SpringBeanPsiTarget) {
            return ((SpringBeanPsiTarget)target).getSpringBean();
        }
        if (target instanceof PsiTarget) {
            return this.findBean(PomService.convertToPsi((PsiTarget)((PsiTarget)target)));
        }
        return null;
    }

    @Override
    @Nullable
    public CommonSpringBean findBean(@Nullable PsiElement identifyingPsiElement) {
        PomTarget target;
        if (identifyingPsiElement == null) {
            return null;
        }
        if (identifyingPsiElement instanceof CustomBeanPsiElement) {
            return ((CustomBeanPsiElement)identifyingPsiElement).getBean();
        }
        if (identifyingPsiElement instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)identifyingPsiElement).getTarget()) instanceof SpringBeanPsiTarget) {
            return ((SpringBeanPsiTarget)target).getSpringBean();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)identifyingPsiElement);
        if (module == null || module.isDisposed() || !SpringLibraryUtil.hasSpringLibrary(module)) {
            return null;
        }
        JamPsiMemberSpringBean bean = (JamPsiMemberSpringBean)JamService.getJamService((Project)identifyingPsiElement.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, identifyingPsiElement);
        if (bean != null) {
            return bean;
        }
        for (SpringBeanPointer<?> pointer : CustomModuleComponentsDiscoverer.getCustomBeansModel(module).getAllCommonBeans()) {
            if (!pointer.isValid() || !identifyingPsiElement.equals(pointer.getSpringBean().getIdentifyingPsiElement())) continue;
            return pointer.getSpringBean();
        }
        return null;
    }

    @Override
    @Nullable
    public SpringBeanPointer<?> findBean(@NotNull CommonSpringModel model, @NonNls @NotNull String beanName) {
        if (model == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(0);
        }
        if (beanName == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(1);
        }
        String beanReferenceName = beanName.startsWith("&") ? beanName.substring(1) : beanName;
        return SpringModelSearchers.findBean(model, beanReferenceName);
    }

    @Override
    @NotNull
    public Set<String> findBeanNames(@NotNull CommonSpringBean bean) {
        String beanName;
        if (bean == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(2);
        }
        if ((beanName = bean.getBeanName()) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringBeanUtilsImpl.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (bean instanceof SpringBean) {
            CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModelByBean(bean);
            Set<String> set = SpringModelVisitorUtils.getAllBeanNames(springModel, BeanService.getInstance().createSpringBeanPointer(bean));
            if (set == null) {
                SpringBeanUtilsImpl.$$$reportNull$$$0(4);
            }
            return set;
        }
        HashSet<String> names2 = new HashSet<String>();
        names2.add(beanName);
        for (String s : bean.getAliases()) {
            if (!StringUtil.isNotEmpty((String)s)) continue;
            names2.add(s);
        }
        HashSet<String> hashSet = names2;
        if (hashSet == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Override
    public boolean processChildBeans(@NotNull DomElement parent, boolean includeParsedCustomBeanWrappers, @NotNull Processor<CommonSpringBean> processor2) {
        if (parent == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(7);
        }
        for (DomSpringBean bean : DomUtil.getChildrenOf((DomElement)parent, DomSpringBean.class)) {
            if (bean instanceof CustomBeanWrapper) {
                if (!(!includeParsedCustomBeanWrappers && ((CustomBeanWrapper)bean).isParsed() || processor2.process((Object)bean))) {
                    return false;
                }
                List<CustomBean> customBeans = ((CustomBeanWrapper)bean).getCustomBeans();
                for (CustomBean customBean : customBeans) {
                    if (processor2.process((Object)customBean)) continue;
                    return false;
                }
                continue;
            }
            if (processor2.process((Object)bean)) continue;
            return false;
        }
        for (DomSpringBeanContainer container : DomUtil.getChildrenOf((DomElement)parent, DomSpringBeanContainer.class)) {
            if (SpringBeanUtilsImpl.addContainerBeans(container, processor2)) continue;
            return false;
        }
        return true;
    }

    private static boolean addContainerBeans(DomSpringBeanContainer container, Processor<CommonSpringBean> processor2) {
        Collection<DomSpringBean> children = container.getChildren();
        for (DomSpringBean child : children) {
            if (processor2.process((Object)child)) continue;
            return false;
        }
        for (DomSpringBean child : children) {
            if (!(child instanceof DomSpringBeanContainer) || SpringBeanUtilsImpl.addContainerBeans((DomSpringBeanContainer)((Object)child), processor2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processXmlFactoryBeans(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<SpringBeanPointer<?>> processor2) {
        if (project == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            SpringBeanUtilsImpl.$$$reportNull$$$0(10);
        }
        SpringBeanSearchParameters params = new SpringBeanSearchParameters(project){};
        params.setSearchScope(scope);
        if (!SpringXmlBeansIndex.processFactoryBeans(params, processor2)) {
            return false;
        }
        return SpringXmlBeansIndex.processFactoryMethods(params, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringBeanUtilsImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringBeanUtilsImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findBeanNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findBean";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findBeanNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processChildBeans";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processXmlFactoryBeans";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

