/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.jam.JamService;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"getPointer", "Lcom/intellij/spring/model/SpringBeanPointer;", "element", "Lcom/intellij/psi/PsiElement;", "findSpringBeanInCode", "scheduleJavaClassInfoResolve", "", "project", "Lcom/intellij/openapi/project/Project;", "info", "Lcom/intellij/spring/java/SpringJavaClassInfo;", "findSpringBeanInXml", "file", "Lcom/intellij/psi/xml/XmlFile;", "intellij.spring.core"})
public final class SpringToolWindowServiceKt {
    @Nullable
    public static final SpringBeanPointer<?> getPointer(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        if (file instanceof XmlFile) {
            return SpringToolWindowServiceKt.findSpringBeanInXml(element, (XmlFile)file);
        }
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (UastLanguagePlugin.Companion.byLanguage(language) != null) {
            return SpringToolWindowServiceKt.findSpringBeanInCode(element);
        }
        return null;
    }

    private static final SpringBeanPointer<?> findSpringBeanInCode(PsiElement element) {
        JamPsiMemberSpringBean memberSpringBean;
        PsiMethod psiMethod;
        UMethod uMethod;
        PsiClass psiClass;
        UClass uClass;
        UClass uClass2 = uClass = (UClass)UastUtils.findContaining((PsiElement)element, UClass.class);
        Object object = psiClass = uClass2 != null ? uClass2.getJavaPsi() : null;
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass)) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        Intrinsics.checkNotNull((Object)psiClass2);
        SpringJavaClassInfo springJavaClassInfo = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass2);
        Intrinsics.checkNotNullExpressionValue((Object)springJavaClassInfo, (String)"getSpringJavaClassInfo(...)");
        SpringJavaClassInfo info = springJavaClassInfo;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !info.isResolved()) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            SpringToolWindowServiceKt.scheduleJavaClassInfoResolve(project, info);
            return null;
        }
        SpringJavaClassInfo.MappedBeanInfo mappedBeanInfo = info.resolve();
        if (!mappedBeanInfo.isMapped()) {
            return null;
        }
        if (mappedBeanInfo.isMappedDomBean()) {
            return mappedBeanInfo.getMappedDomBeans().get(0);
        }
        UMethod uMethod2 = uMethod = (UMethod)UastUtils.findContaining((PsiElement)element, UMethod.class);
        Object object2 = psiMethod = uMethod2 != null ? uMethod2.getJavaPsi() : null;
        if (psiMethod != null && (memberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)element.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiMethod)) != null) {
            return BeanService.getInstance().createSpringBeanPointer(memberSpringBean);
        }
        List<JamSpringBeanPointer> list = mappedBeanInfo.getStereotypeMappedBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStereotypeMappedBeans(...)");
        List<JamSpringBeanPointer> stereoTypeMappedBeans = list;
        if (stereoTypeMappedBeans.isEmpty()) {
            throw new IllegalStateException("could not find bean for " + element);
        }
        return stereoTypeMappedBeans.get(0);
    }

    private static final void scheduleJavaClassInfoResolve(Project project, SpringJavaClassInfo info) {
        NonUrgentExecutor.getInstance().execute(() -> SpringToolWindowServiceKt.scheduleJavaClassInfoResolve$lambda$1(project, info));
    }

    private static final SpringBeanPointer<?> findSpringBeanInXml(PsiElement element, XmlFile file) {
        DomSpringBean domSpringBean;
        XmlTag xmlTag;
        if (!SpringDomUtils.isSpringXml(file)) {
            return null;
        }
        if (element instanceof XmlTag) {
            xmlTag = (XmlTag)element;
        } else {
            xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (xmlTag == null) {
                return null;
            }
        }
        XmlTag tag = xmlTag;
        DomElement domElement = DomUtil.getDomElement((PsiElement)((PsiElement)tag));
        if (domElement == null) {
            return null;
        }
        DomElement domElement2 = domElement;
        if (domElement2 instanceof DomSpringBean) {
            domSpringBean = (DomSpringBean)domElement2;
        } else {
            domSpringBean = (DomSpringBean)domElement2.getParentOfType(DomSpringBean.class, false);
            if (domSpringBean == null) {
                return null;
            }
        }
        DomSpringBean domSpringBean2 = domSpringBean;
        return BeanService.getInstance().createSpringBeanPointer(domSpringBean2);
    }

    private static final void scheduleJavaClassInfoResolve$lambda$1$lambda$0(Project $project, SpringJavaClassInfo $info) {
        if ($project.isDisposed() || DumbService.Companion.isDumb($project)) {
            return;
        }
        $info.resolve();
    }

    private static final void scheduleJavaClassInfoResolve$lambda$1(Project $project, SpringJavaClassInfo $info) {
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> SpringToolWindowServiceKt.scheduleJavaClassInfoResolve$lambda$1$lambda$0($project, $info));
    }
}

