/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.floats.FloatIterable;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import it.unimi.dsi.fastutil.floats.FloatSpliterator;
import it.unimi.dsi.fastutil.floats.FloatSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface FloatCollection
extends FloatIterable,
Collection<Float> {
    @Override
    public FloatIterator iterator();

    @Override
    default public FloatSpliterator spliterator() {
        return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(float var1);

    public boolean contains(float var1);

    public boolean rem(float var1);

    @Override
    @Deprecated
    default public boolean add(Float key) {
        return this.add(key.floatValue());
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains(((Float)key).floatValue());
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem(((Float)key).floatValue());
    }

    public float[] toFloatArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Float> filter2) {
        return this.removeIf(filter2 instanceof FloatPredicate ? (FloatPredicate)filter2 : key -> filter2.test(Float.valueOf(SafeMath.safeDoubleToFloat(key))));
    }

    default public boolean removeIf(FloatPredicate filter2) {
        Objects.requireNonNull(filter2);
        boolean removed = false;
        FloatIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter2.test(each.nextFloat())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Float> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Float> parallelStream() {
        return Collection.super.parallelStream();
    }
}

