/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.extension;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.jpa.jpb.model.orm.ep.OrmEntityWriter;
import com.intellij.jpa.jpb.model.orm.ep.OrmMappingProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.jpa.model.CustomJpaOrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.psibuilder.common.PsiMemberInsertionPlace;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.re.JpaReverseEngineeringHelper;
import com.intellij.re.ReVirtualEntitiesModelHolder;
import com.intellij.re.ReverseEngineeringGenerator;
import com.intellij.re.ReverseEngineeringHelper;
import com.intellij.re.msg.ReBundle;
import com.intellij.re.ui.ReRelatedAttributeManager;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.structure.core.Relation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/re/extension/OrmEntityAttributesCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "psiClassAndPosition", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiClass;", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getColumnVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "psiClass", "isInConstructor", "elementToReplace", "VariantsCalculator", "AddAttributeToEntityLookupElement", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nOrmEntityAttributesCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmEntityAttributesCompletionContributor.kt\ncom/intellij/re/extension/OrmEntityAttributesCompletionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
final class OrmEntityAttributesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        List<LookupElement> variants;
        PsiElement elementToReplace;
        Pair<PsiClass, Boolean> psiClassAndPosition;
        block7: {
            Object object;
            block6: {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (!ApplicationManager.getApplication().isUnitTestMode() && !Registry.Companion.is("reverse.engineering.completions.enabled", false)) {
                    return;
                }
                PsiElement psiElement2 = parameters.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPosition(...)");
                Pair<PsiClass, Boolean> pair = this.psiClassAndPosition(psiElement2);
                if (pair == null) {
                    return;
                }
                psiClassAndPosition = pair;
                object = parameters.getOriginalPosition();
                if (object == null) break block6;
                PsiElement it = psiElement = object;
                boolean bl = false;
                object = it instanceof PsiWhiteSpace ? psiElement : null;
                if (object != null) break block7;
            }
            PsiElement psiElement = parameters.getOriginalPosition();
            object = elementToReplace = psiElement != null ? psiElement.getParent() : null;
        }
        if (!((Collection)(variants = this.getColumnVariants((PsiClass)psiClassAndPosition.getFirst(), (Boolean)psiClassAndPosition.getSecond(), elementToReplace))).isEmpty()) {
            result.addAllElements((Iterable)variants);
        }
    }

    private final Pair<PsiClass, Boolean> psiClassAndPosition(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement.getParent();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement parent = psiElement2;
        UElement uElement = UastContextKt.toUElement((PsiElement)parent);
        if (uElement instanceof UAnnotation) {
            return null;
        }
        if (uElement instanceof UDeclaration) {
            if (uElement instanceof UClass) {
                return TuplesKt.to((Object)((UClass)uElement).getJavaPsi(), (Object)false);
            }
            if (uElement instanceof UParameter) {
                UElement uParent = ((UParameter)uElement).getUastParent();
                UMethod uMethod = uParent instanceof UMethod ? (UMethod)uParent : null;
                boolean bl = uMethod != null ? uMethod.isConstructor() : false;
                if (bl) {
                    return null;
                }
                return null;
            }
            return null;
        }
        return this.psiClassAndPosition(parent);
    }

    private final List<LookupElement> getColumnVariants(PsiClass psiClass, boolean isInConstructor, PsiElement elementToReplace) {
        OrmEntity ormEntity = OrmUtil.INSTANCE.getOrmEntityForPsiClass(psiClass);
        if (ormEntity == null) {
            return CollectionsKt.emptyList();
        }
        OrmEntity ormEntity2 = ormEntity;
        OrmFramework ormFramework = ormEntity2.getOrmFramework();
        if (isInConstructor && !ormFramework.getMappingFeatures().getAttributesInConstructorPossible()) {
            return CollectionsKt.emptyList();
        }
        if (OrmEntityWriter.Companion.getForFramework(ormEntity2.getOrmFramework()) == null) {
            return CollectionsKt.emptyList();
        }
        AbstractRdbmsStore abstractRdbmsStore = OrmUtil.INSTANCE.getAssociatedDataStore(ormEntity2);
        if (abstractRdbmsStore == null) {
            return CollectionsKt.emptyList();
        }
        AbstractRdbmsStore rdbmsStore = abstractRdbmsStore;
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new VariantsCalculator(project, rdbmsStore, ormEntity2, elementToReplace).getVariants();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/re/extension/OrmEntityAttributesCompletionProvider$AddAttributeToEntityLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "attributeModel", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "ormEntity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "entityModel", "Lcom/intellij/jpa/jpb/model/model/Entity;", "elementToReplace", "Lcom/intellij/psi/PsiElement;", "isEmptyText", "", "<init>", "(Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;Lcom/intellij/jpa/jpb/model/model/Entity;Lcom/intellij/psi/PsiElement;Z)V", "getAttributeModel", "()Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "getOrmEntity", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "getEntityModel", "()Lcom/intellij/jpa/jpb/model/model/Entity;", "getElementToReplace", "()Lcom/intellij/psi/PsiElement;", "()Z", "getLookupString", "", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "handleInsert", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "getAutoCompletionPolicy", "Lcom/intellij/codeInsight/lookup/AutoCompletionPolicy;", "getFromText", "intellij.javaee.reverseEngineering"})
    @SourceDebugExtension(value={"SMAP\nOrmEntityAttributesCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmEntityAttributesCompletionContributor.kt\ncom/intellij/re/extension/OrmEntityAttributesCompletionProvider$AddAttributeToEntityLookupElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
    private static final class AddAttributeToEntityLookupElement
    extends LookupElement {
        @NotNull
        private final EntityAttributeModel attributeModel;
        @NotNull
        private final OrmEntity ormEntity;
        @NotNull
        private final Entity entityModel;
        @Nullable
        private final PsiElement elementToReplace;
        private final boolean isEmptyText;

        public AddAttributeToEntityLookupElement(@NotNull EntityAttributeModel attributeModel, @NotNull OrmEntity ormEntity, @NotNull Entity entityModel, @Nullable PsiElement elementToReplace, boolean isEmptyText) {
            Intrinsics.checkNotNullParameter((Object)attributeModel, (String)"attributeModel");
            Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
            Intrinsics.checkNotNullParameter((Object)entityModel, (String)"entityModel");
            this.attributeModel = attributeModel;
            this.ormEntity = ormEntity;
            this.entityModel = entityModel;
            this.elementToReplace = elementToReplace;
            this.isEmptyText = isEmptyText;
        }

        @NotNull
        public final EntityAttributeModel getAttributeModel() {
            return this.attributeModel;
        }

        @NotNull
        public final OrmEntity getOrmEntity() {
            return this.ormEntity;
        }

        @NotNull
        public final Entity getEntityModel() {
            return this.entityModel;
        }

        @Nullable
        public final PsiElement getElementToReplace() {
            return this.elementToReplace;
        }

        public final boolean isEmptyText() {
            return this.isEmptyText;
        }

        @NotNull
        public String getLookupString() {
            String string = this.attributeModel.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            super.renderElement(presentation);
            presentation.setItemText(this.attributeModel.getName());
            presentation.setTailText(" " + this.attributeModel.getType().getClassName());
            presentation.setIcon(OrmUtil.INSTANCE.getOrmAttributeIcon((OrmEntityAttribute)new CustomJpaOrmEntityAttribute((EntityAttribute)this.attributeModel)));
            presentation.setTypeText(this.getFromText());
        }

        public void handleInsert(@NotNull InsertionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = this.elementToReplace;
            if (object == null || (object = PsiUtilsKt.getContainingStaticClass((PsiElement)object)) == null) {
                SmartPsiElementPointer smartPsiElementPointer = this.ormEntity.getClassPsiPointer();
                object = smartPsiElementPointer != null ? (PsiClass)smartPsiElementPointer.getElement() : null;
                if (object == null) {
                    return;
                }
            }
            PsiElement entityClass = object;
            OrmEntityWriter ormEntityWriter = OrmEntityWriter.Companion.getForFramework(this.ormEntity.getOrmFramework());
            Intrinsics.checkNotNull((Object)ormEntityWriter);
            OrmEntityWriter ormWriter = ormEntityWriter;
            WriteCommandAction.writeCommandAction((Project)entityClass.getProject()).withName(ReBundle.message("command.name.create.entity.attributes", new Object[0])).run(() -> AddAttributeToEntityLookupElement.handleInsert$lambda$3(this, context, (PsiClass)entityClass, ormWriter));
        }

        @NotNull
        public AutoCompletionPolicy getAutoCompletionPolicy() {
            return AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        }

        private final String getFromText() {
            if (this.attributeModel.getColumn() != null) {
                return "from " + this.entityModel.getTable() + "." + this.attributeModel.getColumn();
            }
            if (this.attributeModel.getMappedBy() != null) {
                Datatype datatype = this.attributeModel.getType();
                Intrinsics.checkNotNull((Object)datatype, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.model.Entity");
                return "mappedBy " + ((Entity)datatype).getClassName() + "." + this.attributeModel.getMappedBy();
            }
            if (!Intrinsics.areEqual((Object)this.attributeModel.getJoinTable(), (Object)JoinTable.NULL_ANNOTATION)) {
                return "from " + this.attributeModel.getJoinTable().getName();
            }
            return "";
        }

        private static final void handleInsert$lambda$3(AddAttributeToEntityLookupElement this$0, InsertionContext $context, PsiClass $entityClass, OrmEntityWriter $ormWriter) {
            PsiElement psiElement;
            PsiClass it;
            PsiClass psiClass;
            block16: {
                block13: {
                    PsiElement res;
                    block15: {
                        PsiElement psiElement2;
                        Object object;
                        Object prevSibling;
                        block14: {
                            if (!(this$0.elementToReplace instanceof PsiWhiteSpace)) break block13;
                            PsiFile psiFile = $context.getFile();
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                            Editor editor = $context.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                            PsiElement psiElement3 = HPsiUtil.getElementAtOffset((PsiFile)psiFile, (Editor)editor);
                            prevSibling = psiElement3 != null ? psiElement3.getPrevSibling() : null;
                            object = prevSibling;
                            if (object == null) break block14;
                            it = psiClass = object;
                            boolean bl = false;
                            object = Intrinsics.areEqual((Object)it.getText(), (Object)this$0.attributeModel.getName()) ? psiClass : null;
                            if (object != null) break block15;
                        }
                        if ((psiElement2 = prevSibling) != null && (psiElement2 = psiElement2.getPrevSibling()) != null) {
                            PsiClass it2 = it = psiElement2;
                            boolean bl = false;
                            object = Intrinsics.areEqual((Object)it2.getText(), (Object)this$0.attributeModel.getName()) ? it : null;
                        } else {
                            object = res = null;
                        }
                    }
                    if (Intrinsics.areEqual((Object)$entityClass.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
                        psiElement = res;
                        if (psiElement == null || (psiElement = psiElement.getFirstChild()) == null) {
                            psiElement = res;
                        }
                    } else {
                        psiElement = res;
                    }
                    break block16;
                }
                psiElement = this$0.elementToReplace;
            }
            PsiElement elementToDelete = psiElement;
            PsiMemberInsertionPlace insertionPlace = new PsiMemberInsertionPlace(Integer.valueOf($context.getStartOffset()), elementToDelete, false, 4, null);
            it = psiClass = $entityClass;
            boolean bl = false;
            Object object = it.isPhysical() ? psiClass : null;
            if (object == null) {
                PsiClass psiClass2;
                Fqn fqn = Fqn.Companion.ofClass($entityClass);
                if (fqn != null) {
                    Project project = $entityClass.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    psiClass2 = fqn.toPsiClass(project);
                } else {
                    psiClass2 = object = null;
                }
                if (psiClass2 == null) {
                    object = $entityClass;
                }
            }
            PsiClass targetClass = object;
            $ormWriter.addAttributes(this$0.entityModel, targetClass, CollectionsKt.listOf((Object)this$0.attributeModel), insertionPlace);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\"\u00102\u001a\u0004\u0018\u0001012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0013\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00066"}, d2={"Lcom/intellij/re/extension/OrmEntityAttributesCompletionProvider$VariantsCalculator;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "ormEntity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "elementToReplace", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;Lcom/intellij/psi/PsiElement;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getOrmEntity", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "getElementToReplace", "()Lcom/intellij/psi/PsiElement;", "allEntitiesModel", "Lcom/intellij/re/ReVirtualEntitiesModelHolder$ReVirtualEntitiesModel;", "getAllEntitiesModel", "()Lcom/intellij/re/ReVirtualEntitiesModelHolder$ReVirtualEntitiesModel;", "text", "", "getText", "()Ljava/lang/String;", "ormMappingProvider", "Lcom/intellij/jpa/jpb/model/orm/ep/OrmMappingProvider;", "getOrmMappingProvider", "()Lcom/intellij/jpa/jpb/model/orm/ep/OrmMappingProvider;", "tableName", "getTableName", "newEntityModel", "Lcom/intellij/jpa/jpb/model/model/EntityModel;", "getNewEntityModel", "()Lcom/intellij/jpa/jpb/model/model/EntityModel;", "relation", "Lliquibase/structure/core/Relation;", "getRelation", "()Lliquibase/structure/core/Relation;", "getVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getOwnAttributeVariants", "getIncomingAttributeVariants", "getPrimitiveReferenceColumns", "attributeModel", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "realEntity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "findRealEntity", "entityModel", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "intellij.javaee.reverseEngineering"})
    @SourceDebugExtension(value={"SMAP\nOrmEntityAttributesCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmEntityAttributesCompletionContributor.kt\ncom/intellij/re/extension/OrmEntityAttributesCompletionProvider$VariantsCalculator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,256:1\n1#2:257\n1#2:277\n188#3,3:258\n126#3:287\n153#3,3:288\n774#4:261\n865#4:262\n2746#4,3:263\n866#4:266\n1617#4,9:267\n1869#4:276\n1870#4:278\n1626#4:279\n1252#4,2:282\n295#4,2:284\n1255#4:286\n463#5:280\n413#5:281\n*S KotlinDebug\n*F\n+ 1 OrmEntityAttributesCompletionContributor.kt\ncom/intellij/re/extension/OrmEntityAttributesCompletionProvider$VariantsCalculator\n*L\n152#1:277\n127#1:258,3\n180#1:287\n180#1:288,3\n147#1:261\n147#1:262\n147#1:263,3\n147#1:266\n152#1:267,9\n152#1:276\n152#1:278\n152#1:279\n170#1:282,2\n171#1:284,2\n170#1:286\n170#1:280\n170#1:281\n*E\n"})
    private static final class VariantsCalculator {
        @NotNull
        private final Project project;
        @NotNull
        private final OrmEntity ormEntity;
        @Nullable
        private final PsiElement elementToReplace;
        @NotNull
        private final ReVirtualEntitiesModelHolder.ReVirtualEntitiesModel allEntitiesModel;
        @NotNull
        private final String text;
        @NotNull
        private final OrmMappingProvider ormMappingProvider;
        @Nullable
        private final String tableName;
        @Nullable
        private final EntityModel newEntityModel;
        @Nullable
        private final Relation relation;

        public VariantsCalculator(@NotNull Project project, @NotNull AbstractRdbmsStore dataStore, @NotNull OrmEntity ormEntity, @Nullable PsiElement elementToReplace) {
            Relation relation;
            EntityModel entityModel;
            String it;
            VariantsCalculator variantsCalculator;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
            Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
            this.project = project;
            this.ormEntity = ormEntity;
            this.elementToReplace = elementToReplace;
            this.allEntitiesModel = ReVirtualEntitiesModelHolder.INSTANCE.getEntityModels(this.project, dataStore, this.ormEntity.getOrmFramework());
            Object object = this.elementToReplace;
            if (object == null || (object = object.getText()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                object = "";
            }
            this.text = object;
            this.ormMappingProvider = OrmMappingProvider.Companion.getForFramework(this.ormEntity.getOrmFramework());
            this.tableName = this.ormMappingProvider.getTableName(this.ormEntity);
            VariantsCalculator variantsCalculator2 = this;
            String string = this.tableName;
            if (string != null) {
                String string2 = string;
                variantsCalculator = variantsCalculator2;
                boolean bl = false;
                entityModel = this.allEntitiesModel.getEntityForTableName(it);
                variantsCalculator2 = variantsCalculator;
            } else {
                entityModel = null;
            }
            variantsCalculator2.newEntityModel = entityModel;
            VariantsCalculator variantsCalculator3 = this;
            String string3 = this.tableName;
            if (string3 != null) {
                it = string3;
                variantsCalculator = variantsCalculator3;
                boolean bl = false;
                relation = this.allEntitiesModel.getRelationForTableName(it);
                variantsCalculator3 = variantsCalculator;
            } else {
                relation = null;
            }
            variantsCalculator3.relation = relation;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final OrmEntity getOrmEntity() {
            return this.ormEntity;
        }

        @Nullable
        public final PsiElement getElementToReplace() {
            return this.elementToReplace;
        }

        @NotNull
        public final ReVirtualEntitiesModelHolder.ReVirtualEntitiesModel getAllEntitiesModel() {
            return this.allEntitiesModel;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final OrmMappingProvider getOrmMappingProvider() {
            return this.ormMappingProvider;
        }

        @Nullable
        public final String getTableName() {
            return this.tableName;
        }

        @Nullable
        public final EntityModel getNewEntityModel() {
            return this.newEntityModel;
        }

        @Nullable
        public final Relation getRelation() {
            return this.relation;
        }

        @NotNull
        public final List<LookupElement> getVariants() {
            if (this.newEntityModel == null || this.relation == null) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.plus((Collection)this.getOwnAttributeVariants(), (Iterable)this.getIncomingAttributeVariants());
        }

        private final List<LookupElement> getOwnAttributeVariants() {
            Entity entity = this.ormMappingProvider.getEntityModel(this.ormEntity);
            if (entity == null) {
                EntityModel entityModel = this.newEntityModel;
                Intrinsics.checkNotNull((Object)entityModel);
                entity = (Entity)entityModel;
            }
            Entity realEntity = entity;
            List result = new ArrayList();
            EntityModel entityModel = this.newEntityModel;
            Intrinsics.checkNotNull((Object)entityModel);
            for (EntityAttribute attribute : entityModel.getAttributes()) {
                Object it;
                if (!(attribute instanceof EntityAttributeModel)) continue;
                String string = ((EntityAttributeModel)attribute).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)this.text, (boolean)false, (int)2, null)) continue;
                if (((EntityAttributeModel)attribute).getColumn() != null) {
                    String string2 = ((EntityAttributeModel)attribute).getColumn();
                    Intrinsics.checkNotNull((Object)string2);
                    if (this.ormMappingProvider.findOrmAttributeForColumn(this.ormEntity, string2) != null) {
                        continue;
                    }
                } else {
                    Map map = ((EntityAttributeModel)attribute).getJoinColumns();
                    if (!(map == null || map.isEmpty())) {
                        boolean bl;
                        block12: {
                            LinkedHashMap linkedHashMap = ((EntityAttributeModel)attribute).getJoinColumns();
                            Intrinsics.checkNotNull((Object)linkedHashMap);
                            Map $this$any$iv = linkedHashMap;
                            boolean $i$f$any = false;
                            if ($this$any$iv.isEmpty()) {
                                bl = false;
                            } else {
                                for (Map.Entry entry : $this$any$iv.entrySet()) {
                                    it = entry;
                                    boolean bl2 = false;
                                    Object k = it.getKey();
                                    Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                                    if (!(this.ormMappingProvider.findOrmAttributeForColumn(this.ormEntity, (String)k) != null)) continue;
                                    bl = true;
                                    break block12;
                                }
                                bl = false;
                            }
                        }
                        if (bl) continue;
                    }
                }
                EntityAttribute newAttribute = null;
                newAttribute = attribute;
                Datatype datatype = ((EntityAttributeModel)attribute).getType();
                EntityModel entityModel2 = datatype instanceof EntityModel ? (EntityModel)datatype : null;
                if (entityModel2 != null) {
                    it = entityModel2;
                    boolean bl = false;
                    Entity entity2 = this.findRealEntity(this.project, (EntityModel)it, this.ormEntity.getOrmFramework());
                    entityModel2 = entity2;
                    if (entity2 != null) {
                        it = entityModel2;
                        boolean bl3 = false;
                        newAttribute = new EntityAttributeModel(attribute);
                        newAttribute.setType((Datatype)it);
                    }
                }
                if (((EntityAttributeModel)newAttribute).getCardinality() == EntityAttribute.Cardinality.ONE_TO_ONE) {
                    ((EntityAttributeModel)newAttribute).setOwner(true);
                }
                result.add(new AddAttributeToEntityLookupElement((EntityAttributeModel)newAttribute, this.ormEntity, realEntity, this.elementToReplace, ((CharSequence)this.text).length() == 0));
                result.addAll((Collection)this.getPrimitiveReferenceColumns((EntityAttributeModel)newAttribute, realEntity));
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LookupElement> getIncomingAttributeVariants() {
            void $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv;
            ReverseEngineeringGenerator reGenerator = new ReverseEngineeringGenerator(this.project, this.allEntitiesModel.getDbType(), this.ormEntity.getOrmFramework(), false, 8, null);
            Relation relation = this.relation;
            Intrinsics.checkNotNull((Object)relation);
            EntityModel entityModel = this.newEntityModel;
            Intrinsics.checkNotNull((Object)entityModel);
            Iterable $this$filter$iv = reGenerator.createIncomingRefAttributes(relation, (Entity)entityModel, (Collection<? extends Relation>)this.allEntitiesModel.getDbSnapshotModel().getRelations());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block12: {
                    EntityAttributeModel it = (EntityAttributeModel)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = this.ormEntity.getAttributes();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            OrmEntityAttribute ormAttribute = (OrmEntityAttribute)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)ormAttribute.getTypeFqn().getInner().getExternalFullName(), (Object)it.getType().getFqn())) continue;
                            bl = false;
                            break block12;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List incomingAttributes = (List)destination$iv$iv;
            if (incomingAttributes.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Entity entity = this.ormMappingProvider.getEntityModel(this.ormEntity);
            if (entity == null) {
                entity = (Entity)this.newEntityModel;
            }
            Entity entityModel2 = entity;
            ReRelatedAttributeManager relatedAttributeManager = new ReRelatedAttributeManager(this.project, entityModel2);
            Object object = this.elementToReplace;
            if (object == null || (object = object.getText()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                object = "";
            }
            Object text = object;
            Iterable $this$mapNotNull$iv = incomingAttributes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AddAttributeToEntityLookupElement addAttributeToEntityLookupElement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                EntityAttributeModel attribute = (EntityAttributeModel)element$iv$iv;
                boolean bl4 = false;
                String string = attribute.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)text, (boolean)false, (int)2, null)) {
                    addAttributeToEntityLookupElement = null;
                } else {
                    EntityAttributeModel newAttr = new EntityAttributeModel((EntityAttribute)attribute);
                    Datatype datatype = attribute.getType();
                    EntityModel entityModel3 = datatype instanceof EntityModel ? (EntityModel)datatype : null;
                    if (entityModel3 != null) {
                        EntityModel it = entityModel3;
                        boolean bl5 = false;
                        Entity entity2 = this.findRealEntity(this.project, it, this.ormEntity.getOrmFramework());
                        entityModel3 = entity2;
                        if (entity2 != null) {
                            it = entityModel3;
                            boolean bl6 = false;
                            attribute.setType((Datatype)it);
                        }
                    }
                    ReRelatedAttributeManager.processRelatedAttr$default(relatedAttributeManager, newAttr, null, 2, null);
                    addAttributeToEntityLookupElement = newAttr.getCardinality() == EntityAttribute.Cardinality.ONE_TO_ONE && newAttr.getMappedBy() == null ? null : new AddAttributeToEntityLookupElement(newAttr, this.ormEntity, entityModel2, this.elementToReplace, ((CharSequence)text).length() == 0);
                }
                if (addAttributeToEntityLookupElement == null) continue;
                AddAttributeToEntityLookupElement it$iv$iv = addAttributeToEntityLookupElement;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            return (List)destination$iv$iv2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LookupElement> getPrimitiveReferenceColumns(EntityAttributeModel attributeModel, Entity realEntity) {
            void $this$mapTo$iv$iv;
            Map map;
            Object object;
            Map destination$iv$iv;
            if (attributeModel.getMappingType() != EntityAttribute.MappingType.ASSOCIATION) {
                return CollectionsKt.emptyList();
            }
            Datatype datatype = attributeModel.getType();
            Entity entity = datatype instanceof Entity ? (Entity)datatype : null;
            if (entity == null) {
                return CollectionsKt.emptyList();
            }
            Entity targetEntity = entity;
            List targetIdAttributes = targetEntity.getIdAttributes();
            if (targetIdAttributes.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            LinkedHashMap linkedHashMap = attributeModel.getJoinColumns();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMap, (String)"getJoinColumns(...)");
            if (!((Map)linkedHashMap).isEmpty()) {
                void $this$mapValuesTo$iv$iv;
                LinkedHashMap linkedHashMap2 = attributeModel.getJoinColumns();
                Intrinsics.checkNotNullExpressionValue((Object)linkedHashMap2, (String)"getJoinColumns(...)");
                $this$mapValues$iv = linkedHashMap2;
                boolean $i$f$mapValues = false;
                Object object2 = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    EntityAttribute entityAttribute;
                    Object v3;
                    Object k;
                    block11: {
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map2 = destination$iv$iv;
                        boolean bl = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        k = it$iv$iv.getKey();
                        object = map2;
                        boolean bl2 = false;
                        String idColumn = (String)entry2.getValue();
                        Intrinsics.checkNotNull((Object)targetIdAttributes);
                        Iterable $this$firstOrNull$iv = targetIdAttributes;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            EntityAttribute it = (EntityAttribute)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)idColumn, (Object)it.getColumn())) continue;
                            v3 = element$iv;
                            break block11;
                        }
                        v3 = null;
                    }
                    if ((EntityAttribute)v3 == null) {
                        return CollectionsKt.emptyList();
                    }
                    object.put(k, entityAttribute);
                }
                map = destination$iv$iv;
            } else {
                $this$mapValues$iv = attributeModel.getColumn();
                if (!($this$mapValues$iv == null || $this$mapValues$iv.length() == 0) && targetIdAttributes.size() == 1) {
                    String string = attributeModel.getColumn();
                    Intrinsics.checkNotNull((Object)targetIdAttributes);
                    map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)CollectionsKt.first((List)targetIdAttributes)));
                } else {
                    return CollectionsKt.emptyList();
                }
            }
            Map columnsToIds = map;
            JpaReverseEngineeringHelper reverseEngineeringHelper = JpaReverseEngineeringHelper.Companion.getInstance(this.project);
            Map $this$map$iv = columnsToIds;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                object = destination$iv$iv2;
                boolean bl = false;
                String column = (String)entry.getKey();
                EntityAttribute targetIdAttribute = (EntityAttribute)entry.getValue();
                EntityAttributeModel newAttr = new EntityAttributeModel(targetIdAttribute);
                newAttr.setId(false);
                newAttr.setReadOnly(false);
                newAttr.setName(reverseEngineeringHelper.generateJavaIdentifier(column, ReverseEngineeringHelper.IdentifierType.FIELD, this.ormEntity.getOrmFramework()));
                newAttr.setColumn(column);
                newAttr.setColumnPhysical(column);
                newAttr.setMappingType(EntityAttribute.MappingType.DATATYPE);
                newAttr.setMandatory(attributeModel.isMandatory());
                object.add(new AddAttributeToEntityLookupElement(newAttr, this.ormEntity, realEntity, this.elementToReplace, ((CharSequence)this.text).length() == 0));
            }
            return (List)destination$iv$iv2;
        }

        private final Entity findRealEntity(Project project, EntityModel entityModel, OrmFramework ormFramework) {
            Entity entity;
            OrmSearcher ormSearcher = OrmSearcher.Companion.getForFramework(ormFramework);
            String string = entityModel.getTable();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTable(...)");
            OrmEntity ormEntity = ormSearcher.findEntityByTableName(project, string);
            if (ormEntity != null) {
                OrmEntity it = ormEntity;
                boolean bl = false;
                entity = OrmMappingProvider.Companion.getForFramework(it.getOrmFramework()).getEntityModel(it);
            } else {
                entity = null;
            }
            return entity;
        }
    }
}

