/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui.settings;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.util.TypeVisibilityChecker;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.ui.component.TextFieldWithAutoCompletionWithPopupButton;
import com.intellij.jpa.jpb.model.ui.dialog.HDialogWrapper;
import com.intellij.liquibase.common.config.ReDatabaseInfo;
import com.intellij.liquibase.common.config.ReMappingType;
import com.intellij.liquibase.common.mapping.ReMappingSettings;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.re.msg.ReBundle;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.ui.FormBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/re/ui/settings/ReMappingTypeEditor;", "Lcom/intellij/jpa/jpb/model/ui/dialog/HDialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "databaseInfo", "Lcom/intellij/liquibase/common/config/ReDatabaseInfo;", "mappingType", "Lcom/intellij/liquibase/common/config/ReMappingType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/liquibase/common/config/ReDatabaseInfo;Lcom/intellij/liquibase/common/config/ReMappingType;)V", "getMappingType", "()Lcom/intellij/liquibase/common/config/ReMappingType;", "typeCodeFragment", "Lcom/intellij/psi/PsiTypeCodeFragment;", "javaTypeField", "Lcom/intellij/ui/EditorComboBox;", "sqlTypeField", "Lcom/intellij/jpa/jpb/model/ui/component/TextFieldWithAutoCompletionWithPopupButton;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "createCenterPanel", "updateSqlAutoCompletionItems", "", "commit", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nReDatabaseInfoPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReDatabaseInfoPanel.kt\ncom/intellij/re/ui/settings/ReMappingTypeEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,194:1\n774#2:195\n865#2,2:196\n1563#2:198\n1634#2,3:199\n37#3:202\n36#3,3:203\n*S KotlinDebug\n*F\n+ 1 ReDatabaseInfoPanel.kt\ncom/intellij/re/ui/settings/ReMappingTypeEditor\n*L\n132#1:195\n132#1:196,2\n133#1:198\n133#1:199,3\n137#1:202\n137#1:203,3\n*E\n"})
public final class ReMappingTypeEditor
extends HDialogWrapper {
    @NotNull
    private final ReDatabaseInfo databaseInfo;
    @NotNull
    private final ReMappingType mappingType;
    @NotNull
    private PsiTypeCodeFragment typeCodeFragment;
    @NotNull
    private EditorComboBox javaTypeField;
    @NotNull
    private TextFieldWithAutoCompletionWithPopupButton sqlTypeField;

    /*
     * WARNING - void declaration
     */
    public ReMappingTypeEditor(@NotNull Project project, @NotNull ReDatabaseInfo databaseInfo, @NotNull ReMappingType mappingType) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Datatypes.BasicDatatype it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)databaseInfo, (String)"databaseInfo");
        Intrinsics.checkNotNullParameter((Object)mappingType, (String)"mappingType");
        super(project);
        this.databaseInfo = databaseInfo;
        this.mappingType = mappingType;
        PsiTypeCodeFragment psiTypeCodeFragment = JavaCodeFragmentFactory.getInstance((Project)project).createTypeCodeFragment("", null, true, 1);
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeCodeFragment, (String)"createTypeCodeFragment(...)");
        this.typeCodeFragment = psiTypeCodeFragment;
        this.sqlTypeField = new TextFieldWithAutoCompletionWithPopupButton(project, null, 2, null);
        this.typeCodeFragment.setVisibilityChecker((JavaCodeFragment.VisibilityChecker)new TypeVisibilityChecker(null, 1, null));
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = (Document)ReadAction.compute(() -> ReMappingTypeEditor._init_$lambda$0(documentManager, this));
        this.javaTypeField = new EditorComboBox(document, project, (FileType)JavaFileType.INSTANCE);
        Collection collection = Datatypes.BasicDatatype.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Datatypes.BasicDatatype)element$iv$iv;
            boolean bl = false;
            if (!(!it.isPrimitive())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Datatypes.BasicDatatype)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getFqn());
        }
        List historyList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        String javaClassValue = this.mappingType.getJavaClass();
        historyList.remove(javaClassValue);
        historyList.add(0, javaClassValue);
        Collection $this$toTypedArray$iv = historyList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.javaTypeField.setHistory(thisCollection$iv.toArray(new String[0]));
        String string = this.mappingType.getSqlType();
        if (string == null) {
            string = "";
        }
        this.sqlTypeField.setText(string);
        this.updateSqlAutoCompletionItems();
        this.setTitle(ReBundle.message("mapping.type.editor", new Object[0]));
        this.init();
    }

    @NotNull
    public final ReMappingType getMappingType() {
        return this.mappingType;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.sqlTypeField;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent(ReBundle.message("sql.type", new Object[0]) + ":", (JComponent)this.sqlTypeField).addLabeledComponent(ReBundle.message("java.type", new Object[0]) + ":", (JComponent)this.javaTypeField).getPanel();
    }

    private final void updateSqlAutoCompletionItems() {
        String dbmsId = this.databaseInfo.getDbmsId();
        CharSequence charSequence = dbmsId;
        if (charSequence == null || charSequence.length() == 0) {
            this.sqlTypeField.setAutoCompletionItems((Collection)CollectionsKt.emptyList());
            return;
        }
        DbType dbType = DbType.Companion.parse(dbmsId, null);
        if (dbType == null) {
            return;
        }
        DbType dbType2 = dbType;
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ReMappingSettings mappingSettings = ReMappingSettings.Companion.getInstance(project, dbType2);
        LinkedHashSet allTypes = new LinkedHashSet(mappingSettings.getMappingTypes().keySet());
        Map sqlSynonymTypes = mappingSettings.getSqlSynonymTypes();
        allTypes.addAll(SetsKt.plus(sqlSynonymTypes.keySet(), (Iterable)CollectionsKt.flatten((Iterable)sqlSynonymTypes.values())));
        this.sqlTypeField.setAutoCompletionItems((Collection)allTypes);
    }

    protected void commit() {
        PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.javaTypeField.getDocument());
        this.mappingType.setJavaClass(this.typeCodeFragment.getType().getCanonicalText());
        this.mappingType.setSqlType(this.sqlTypeField.getText());
    }

    private static final Document _init_$lambda$0(PsiDocumentManager $documentManager, ReMappingTypeEditor this$0) {
        Document document = $documentManager.getDocument((PsiFile)this$0.typeCodeFragment);
        Intrinsics.checkNotNull((Object)document);
        return document;
    }
}

