/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesRefreshable;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesResourceInformationPanel;
import com.intellij.kubernetes.view.ui.KubernetesRowBasedTableCellRenderer;
import com.intellij.kubernetes.view.ui.KubernetesTable;
import com.intellij.kubernetes.view.ui.KubernetesTableBasedPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001\u0011\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0017B/\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015R\u001e\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel;", "T", "Lcom/intellij/kubernetes/view/ui/KubernetesTableBasedPanel;", "Lcom/intellij/kubernetes/view/KubernetesRefreshable;", "resource", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "columnDescriptors", "", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "<init>", "(Ljava/lang/Object;Lcom/intellij/openapi/Disposable;Ljava/util/List;)V", "placeName", "", "getPlaceName", "()Ljava/lang/String;", "tableModel", "com/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel$tableModel$1", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel$tableModel$1;", "fillTable", "", "(Ljava/lang/Object;)V", "refresh", "CopyValueAction", "intellij.clouds.kubernetes"})
public final class KubernetesResourceInformationPanel<T>
extends KubernetesTableBasedPanel
implements KubernetesRefreshable<T> {
    @NotNull
    private final List<KubernetesResourceMapper.ColumnDescriptor<T, ?>> columnDescriptors;
    @NotNull
    private final String placeName;
    @NotNull
    private final tableModel.1 tableModel;

    public KubernetesResourceInformationPanel(T resource, @NotNull Disposable parentDisposable, @NotNull List<? extends KubernetesResourceMapper.ColumnDescriptor<T, ?>> columnDescriptors2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(columnDescriptors2, (String)"columnDescriptors");
        super(parentDisposable);
        this.columnDescriptors = columnDescriptors2;
        Object object = resource instanceof KubernetesObject ? (KubernetesObject)resource : null;
        if (object == null || (object = object.getKind()) == null) {
            object = "";
        }
        this.placeName = object;
        this.tableModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableModel.addColumn(KubernetesBundle.message("KubernetesResourceInformationPanel.nameColumn.name", new Object[0]));
        this.tableModel.addColumn(KubernetesBundle.message("KubernetesResourceInformationPanel.valueColumn.name", new Object[0]));
        this.fillTable(resource);
        KubernetesTable table = new KubernetesTable(this.tableModel);
        table.getColumnModel().getColumn(1).setCellRenderer(new KubernetesRowBasedTableCellRenderer(this.columnDescriptors));
        AnAction[] anActionArray = new AnAction[]{new CopyValueAction(table)};
        this.addTable(table, (ActionGroup)new DefaultActionGroup(anActionArray));
    }

    @Override
    @NotNull
    protected String getPlaceName() {
        return this.placeName;
    }

    private final void fillTable(T resource) {
        for (KubernetesResourceMapper.ColumnDescriptor<T, ?> columnDescriptor : this.columnDescriptors) {
            Object[] objectArray = new Object[]{columnDescriptor.getName(), columnDescriptor.valueOf(resource)};
            Object[] rowData = objectArray;
            this.tableModel.addRow(rowData);
        }
    }

    @Override
    public void refresh(T resource) {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
        this.fillTable(resource);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel$CopyValueAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "table", "Lcom/intellij/kubernetes/view/ui/KubernetesTable;", "<init>", "(Lcom/intellij/kubernetes/view/ui/KubernetesTable;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesResourceInformationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceInformationPanel.kt\ncom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel$CopyValueAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
    private static final class CopyValueAction
    extends DumbAwareAction {
        @NotNull
        private final KubernetesTable table;

        public CopyValueAction(@NotNull KubernetesTable table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            super(KubernetesBundle.message("KubernetesResourceInformationPanel.CopyValueAction.text", new Object[0]), KubernetesBundle.message("KubernetesResourceInformationPanel.CopyValueAction.description", new Object[0]), AllIcons.Actions.Copy);
            this.table = table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(this.table.getSelectedRow() >= 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Integer n = this.table.getSelectedRow();
                int it = ((Number)n).intValue();
                boolean bl = false;
                Object object = it >= 0 ? n : null;
                if (object == null) break block1;
                int it2 = ((Number)object).intValue();
                boolean bl2 = false;
                Object object2 = this.table.getValueAt(it2, 1);
                object = object2;
                if (object2 != null && (object = object.toString()) != null) {
                    Object it3 = object;
                    boolean bl3 = false;
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection((String)it3));
                }
            }
        }
    }
}

