/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.google.common.net.InetAddresses;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.execution.KubernetesObjectInfo;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingService;
import com.intellij.kubernetes.view.execution.PortForwarding;
import com.intellij.kubernetes.view.execution.PortForwardingProcess;
import com.intellij.kubernetes.view.execution.PortForwardingUtils;
import com.intellij.kubernetes.view.ui.ComponentsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesPortForwardingDialog;
import com.intellij.kubernetes.view.ui.actions.KubernetesPortForwardingNotificationService;
import com.intellij.kubernetes.view.ui.actions.PortSuggestingComboBoxModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.util.ListenerWithValueUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UiScopeKt;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 /2\u00020\u0001:\u0002/0B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007H\u0002J\u001c\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00132\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190&H\u0002J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00072\u0006\u0010)\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020$H\u0016J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lio/kubernetes/client/common/KubernetesObject;", "availableServices", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lio/kubernetes/client/common/KubernetesObject;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTarget", "()Lio/kubernetes/client/common/KubernetesObject;", "getAvailableServices", "()Ljava/util/List;", "targetComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "addresses", "Lcom/intellij/ui/TextFieldWithStoredHistory;", "portsModel", "Lcom/intellij/kubernetes/view/ui/actions/PortSuggestingComboBoxModel;", "getPortsModel", "()Lcom/intellij/kubernetes/view/ui/actions/PortSuggestingComboBoxModel;", "ports", "", "getPorts", "()Lcom/intellij/openapi/ui/ComboBox;", "schedulePortSuggestions", "", "getAddresses", "Ljava/net/InetAddress;", "setupFieldWithHistory", "field", "defaultValue", "createCenterPanel", "Ljavax/swing/JComponent;", "portsFieldChangesFlow", "Lkotlinx/coroutines/flow/Flow;", "getNonAvailablePorts", "", "text", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPreferredFocusedComponent", "getPortForwardingSettings", "Lcom/intellij/kubernetes/view/execution/PortForwarding;", "saveHistory", "Companion", "ExpandableTextBoxEditor", "intellij.clouds.kubernetes"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKubernetesPodForwardPortsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n19#2:407\n19#2:425\n30#3,2:408\n1617#4,9:410\n1869#4:419\n1870#4:422\n1626#4:423\n14#5:420\n1#6:421\n1#6:424\n*S KotlinDebug\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog\n*L\n264#1:407\n396#1:425\n268#1:408,2\n279#1:410,9\n279#1:419\n279#1:422\n279#1:423\n284#1:420\n279#1:421\n*E\n"})
public final class KubernetesPortForwardingDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final KubernetesObject target;
    @Nullable
    private final List<KubernetesObject> availableServices;
    @Nullable
    private final ComboBox<KubernetesObject> targetComboBox;
    @NotNull
    private final TextFieldWithStoredHistory addresses;
    @VisibleForTesting
    @NotNull
    private final PortSuggestingComboBoxModel portsModel;
    @VisibleForTesting
    @NotNull
    private final ComboBox<String> ports;
    @NotNull
    private static final String PORT = "\\d{1,5}";
    @NotNull
    private static final String PORT_MAPPING = "\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5}";
    @NotNull
    private static final Regex PORTS_PATTERN = new Regex("(?:\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5})(?:\\h+(?:\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5}))*");
    @NotNull
    private static final Regex PORT_MAPPING_PATTERN = new Regex("\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5}");

    /*
     * WARNING - void declaration
     */
    private KubernetesPortForwardingDialog(Project project, KubernetesObject target, List<? extends KubernetesObject> availableServices) {
        super(project);
        void $this$ports_u24lambda_u245;
        Object $this$addresses_u24lambda_u244;
        Object object;
        ComboBox comboBox;
        KubernetesPortForwardingDialog kubernetesPortForwardingDialog;
        this.project = project;
        this.target = target;
        this.availableServices = availableServices;
        KubernetesPortForwardingDialog kubernetesPortForwardingDialog2 = this;
        List<KubernetesObject> list2 = this.availableServices;
        if (list2 != null) {
            void it;
            ComboBox comboBox2;
            List<KubernetesObject> list3 = list2;
            kubernetesPortForwardingDialog = kubernetesPortForwardingDialog2;
            boolean bl = false;
            ComboBox $this$targetComboBox_u24lambda_u242_u24lambda_u241 = comboBox2 = ComponentsKt.kubernetesObjectCombox$default((List)it, null, 2, null);
            boolean bl2 = false;
            $this$targetComboBox_u24lambda_u242_u24lambda_u241.addItemListener(arg_0 -> KubernetesPortForwardingDialog.targetComboBox$lambda$2$lambda$1$lambda$0(this, arg_0));
            comboBox = comboBox2;
            kubernetesPortForwardingDialog2 = kubernetesPortForwardingDialog;
        } else {
            comboBox = null;
        }
        kubernetesPortForwardingDialog2.targetComboBox = comboBox;
        TextFieldWithStoredHistory textFieldWithStoredHistory = object = new TextFieldWithStoredHistory(KubernetesPortForwardingDialog.class.getCanonicalName() + ".addresses");
        kubernetesPortForwardingDialog = this;
        boolean bl = false;
        $this$addresses_u24lambda_u244.addItemListener(arg_0 -> KubernetesPortForwardingDialog.addresses$lambda$4$lambda$3(this, arg_0));
        kubernetesPortForwardingDialog.addresses = object;
        this.portsModel = new PortSuggestingComboBoxModel();
        object = this.portsModel;
        $this$addresses_u24lambda_u244 = object = new ComboBox<String>((PortSuggestingComboBoxModel)object){};
        kubernetesPortForwardingDialog = this;
        boolean bl3 = false;
        $this$ports_u24lambda_u245.setEditable(true);
        $this$ports_u24lambda_u245.setEditor((ComboBoxEditor)new ExpandableTextBoxEditor());
        kubernetesPortForwardingDialog.ports = (ComboBox)object;
        this.setupFieldWithHistory(this.addresses, "localhost");
        this.schedulePortSuggestions();
        this.setTitle(KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.title", new Object[0]));
        this.setOKButtonText(KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.okButton.text", new Object[0]));
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final KubernetesObject getTarget() {
        return this.target;
    }

    @Nullable
    public final List<KubernetesObject> getAvailableServices() {
        return this.availableServices;
    }

    @NotNull
    public final PortSuggestingComboBoxModel getPortsModel() {
        return this.portsModel;
    }

    @NotNull
    public final ComboBox<String> getPorts() {
        return this.ports;
    }

    @RequiresEdt
    @VisibleForTesting
    public final void schedulePortSuggestions() {
        KubernetesObject kubernetesObject = this.target;
        if (kubernetesObject == null) {
            KubernetesObject kubernetesObject2;
            Object object = this.targetComboBox;
            if (object != null && (object = object.getSelectedItem()) != null) {
                Object $this$asSafely$iv = object;
                boolean $i$f$asSafely = false;
                Object object2 = $this$asSafely$iv;
                if (!(object2 instanceof KubernetesObject)) {
                    object2 = null;
                }
                kubernetesObject2 = (KubernetesObject)object2;
            } else {
                kubernetesObject2 = kubernetesObject = null;
            }
            if (kubernetesObject2 == null) {
                return;
            }
        }
        KubernetesObject target = kubernetesObject;
        List<InetAddress> addresses2 = this.getAddresses();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<KubernetesPortForwardingNotificationService> serviceClass$iv = KubernetesPortForwardingNotificationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Deferred suggestions2 = BuildersKt.async$default((CoroutineScope)((KubernetesPortForwardingNotificationService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(target, addresses2, null){
            int label;
            final /* synthetic */ KubernetesObject $target;
            final /* synthetic */ List<InetAddress> $addresses;
            {
                this.$target = $target;
                this.$addresses = $addresses;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = PortForwardingUtils.INSTANCE.suggestPortMappings(this.$target, this.$addresses, (Continuation<? super List<String>>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        UiScopeKt.launchOnceOnShow$default((Component)((Component)this.ports), (String)"install ports suggestions", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Deferred<? extends List<String>>)suggestions2, this, null){
            int label;
            final /* synthetic */ Deferred<List<String>> $suggestions;
            final /* synthetic */ KubernetesPortForwardingDialog this$0;
            {
                this.$suggestions = $suggestions;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$suggestions.await((Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        suggestions = (List)v0;
                        this.this$0.getPortsModel().suggest(suggestions);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<InetAddress> getAddresses() {
        Object object;
        void $this$mapNotNullTo$iv$iv;
        Object object2 = this.addresses.getSelectedItem();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        Object object3 = new String[]{","};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)((String)object2), (String[])object3, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            InetAddress it$iv$iv;
            InetAddress inetAddress;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                inetAddress = InetAddress.getByName(it);
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(KubernetesPortForwardingDialog.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to parse address: " + it, (Throwable)e);
                inetAddress = null;
            }
            if (inetAddress == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        object3 = (List)destination$iv$iv;
        if (object3.isEmpty()) {
            boolean bl = false;
            object = CollectionsKt.listOf((Object)InetAddress.getByName("127.0.0.1"));
        } else {
            object = object3;
        }
        return (List)object;
    }

    private final void setupFieldWithHistory(TextFieldWithStoredHistory field, String defaultValue) {
        block1: {
            field.setEditor((ComboBoxEditor)new ExpandableTextBoxEditor());
            field.setHistorySize(-1);
            field.reset();
            List list2 = field.getHistory();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getHistory(...)");
            String string = (String)CollectionsKt.firstOrNull((List)list2);
            if (string == null) {
                string = defaultValue;
            }
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            field.setSelectedItem((Object)it);
        }
    }

    static /* synthetic */ void setupFieldWithHistory$default(KubernetesPortForwardingDialog kubernetesPortForwardingDialog, TextFieldWithStoredHistory textFieldWithStoredHistory, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        kubernetesPortForwardingDialog.setupFieldWithHistory(textFieldWithStoredHistory, string);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20(this, arg_0));
    }

    private final Flow<String> portsFieldChangesFlow() {
        return FlowKt.buffer((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super String>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KubernetesPortForwardingDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                ProducerScope producerScope = (ProducerScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$callbackFlow;
                        ResultKt.throwOnFailure((Object)$result);
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                        Disposable lisneterDisposable = disposable;
                        Component component2 = this.this$0.getPorts().getEditor().getEditorComponent();
                        Object object2 = component2 instanceof JTextField ? (JTextField)component2 : null;
                        if (object2 != null && (object2 = ((JTextComponent)object2).getDocument()) != null) {
                            ListenerWithValueUiUtil.whenTextChanged((Document)object2, (Disposable)lisneterDisposable, arg_0 -> portsFieldChangesFlow.1.invokeSuspend$lambda$0((ProducerScope)$this$callbackFlow, arg_0));
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$callbackFlow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)lisneterDisposable);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, () -> portsFieldChangesFlow.1.invokeSuspend$lambda$1(lisneterDisposable), (Continuation)((Continuation)this));
                        if (object3 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Disposable lisneterDisposable = (Disposable)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ProducerScope $$this$callbackFlow, String it) {
                ChannelsKt.trySendBlocking((SendChannel)((SendChannel)$$this$callbackFlow), (Object)it);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(Disposable $lisneterDisposable) {
                Disposer.dispose((Disposable)$lisneterDisposable);
                return Unit.INSTANCE;
            }
        })), (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getNonAvailablePorts(String text, Continuation<? super List<Integer>> $completion) {
        if (!($completion instanceof getNonAvailablePorts.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ KubernetesPortForwardingDialog this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KubernetesPortForwardingDialog.access$getNonAvailablePorts(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = text;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends InetAddress>>, Object>(this, null){
                    int label;
                    final /* synthetic */ KubernetesPortForwardingDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return KubernetesPortForwardingDialog.access$getAddresses(this.this$0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends InetAddress>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                text = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                addresses = (List)v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)text);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)addresses);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Integer>>, Object>(text, (List<? extends InetAddress>)addresses, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    int I$0;
                    int I$1;
                    int I$2;
                    int I$3;
                    int label;
                    final /* synthetic */ String $text;
                    final /* synthetic */ List<InetAddress> $addresses;
                    {
                        this.$text = $text;
                        this.$addresses = $addresses;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                ports = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)KubernetesPortForwardingDialog.access$getPORT_MAPPING_PATTERN$cp(), (CharSequence)StringsKt.trim((CharSequence)this.$text).toString(), (int)0, (int)2, null), (Function1)((Function1)getNonAvailablePorts.ports.1.INSTANCE)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Integer;)()));
                                var3_4 = ports;
                                var4_5 = this.$addresses;
                                $i$f$filterNot = 0;
                                var6_7 = $this$filterNot$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterNotTo = 0;
                                var9_10 = $this$filterNotTo$iv$iv.iterator();
lbl13:
                                // 3 sources

                                while (var9_10.hasNext()) {
                                    element$iv$iv = var9_10.next();
                                    port = ((Number)element$iv$iv).intValue();
                                    $i$a$-filterNot-KubernetesPortForwardingDialog$getNonAvailablePorts$2$1 = 0;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ports);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$filterNot$iv);
                                    this.L$2 = var4_5;
                                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$filterNotTo$iv$iv);
                                    this.L$4 = destination$iv$iv;
                                    this.L$5 = var9_10;
                                    this.L$6 = element$iv$iv;
                                    this.I$0 = $i$f$filterNot;
                                    this.I$1 = $i$f$filterNotTo;
                                    this.I$2 = port;
                                    this.I$3 = $i$a$-filterNot-KubernetesPortForwardingDialog$getNonAvailablePorts$2$1;
                                    this.label = 1;
                                    v0 = PortForwardingUtils.INSTANCE.isPortAvailable(var4_5, port, (Continuation<? super Boolean>)this);
                                    if (v0 == var13_2) {
                                        return var13_2;
                                    }
                                    ** GOTO lbl48
                                }
                                break;
                            }
                            case 1: {
                                $i$a$-filterNot-KubernetesPortForwardingDialog$getNonAvailablePorts$2$1 = this.I$3;
                                port = this.I$2;
                                $i$f$filterNotTo = this.I$1;
                                $i$f$filterNot = this.I$0;
                                element$iv$iv = this.L$6;
                                var9_10 = (Iterator<T>)this.L$5;
                                destination$iv$iv = (Collection)this.L$4;
                                $this$filterNotTo$iv$iv = (Iterable)this.L$3;
                                var4_5 = (List)this.L$2;
                                $this$filterNot$iv = (Iterable)this.L$1;
                                ports = (List)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl48:
                                // 2 sources

                                if (((Boolean)v0).booleanValue()) ** GOTO lbl13
                                destination$iv$iv.add(element$iv$iv);
                                ** GOTO lbl13
                            }
                        }
                        return (List)destination$iv$iv;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<Integer>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final int invokeSuspend$lambda$0(String str) {
                        String[] stringArray = new String[]{":"};
                        return Integer.parseInt((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
                    }
                }), (Continuation)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl35
            }
            case 2: {
                addresses = (List)$continuation.L$1;
                text = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.ports;
    }

    @NotNull
    public final PortForwarding getPortForwardingSettings() {
        KubernetesObject kubernetesObject;
        block5: {
            block4: {
                kubernetesObject = this.targetComboBox;
                if (kubernetesObject == null || (kubernetesObject = kubernetesObject.getSelectedItem()) == null) break block4;
                Object $this$asSafely$iv = kubernetesObject;
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof KubernetesObject)) {
                    object = null;
                }
                if ((kubernetesObject = (KubernetesObject)object) != null) break block5;
            }
            KubernetesObject kubernetesObject2 = this.target;
            kubernetesObject = kubernetesObject2;
            Intrinsics.checkNotNull((Object)kubernetesObject2);
        }
        KubernetesObjectInfo kubernetesObjectInfo = new KubernetesObjectInfo(kubernetesObject);
        String string = this.addresses.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String[] stringArray = new String[]{","};
        List list2 = CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        Object object = this.ports.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return new PortForwarding(kubernetesObjectInfo, list2, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)PORT_MAPPING_PATTERN, (CharSequence)((Object)StringsKt.trim((CharSequence)((String)object))).toString(), (int)0, (int)2, null), (Function1)((Function1)getPortForwardingSettings.1.INSTANCE))));
    }

    public final void saveHistory() {
        this.addresses.addCurrentTextToHistory();
        this.portsModel.addCurrentTextToHistory();
    }

    private static final void targetComboBox$lambda$2$lambda$1$lambda$0(KubernetesPortForwardingDialog this$0, ItemEvent event) {
        this$0.schedulePortSuggestions();
    }

    private static final void addresses$lambda$4$lambda$3(KubernetesPortForwardingDialog this$0, ItemEvent it) {
        this$0.schedulePortSuggestions();
    }

    private static final Unit createCenterPanel$lambda$20$lambda$9(KubernetesPortForwardingDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.targetComboBox);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$20$lambda$14$lambda$11(ValidationInfoBuilder $this$validationOnApply, TextFieldWithStoredHistory it) {
        ValidationInfo validationInfo;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getTextEditor().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{","};
            for (String address : (Iterable)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                ValidationInfo validationInfo2;
                ValidationInfo validationInfo3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)address, (Object)"localhost") && !InetAddresses.isInetAddress((String)address)) {
                    Object[] objectArray = new Object[]{address};
                    String string2 = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.addresses.incorrect.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    validationInfo3 = $this$validationOnApply.error(string2);
                } else {
                    validationInfo3 = null;
                }
                if ((validationInfo2 = validationInfo3) == null) continue;
                validationInfo = validationInfo2;
                break block3;
            }
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final void createCenterPanel$lambda$20$lambda$14$lambda$13$lambda$12(Function0 $validate, ItemEvent it) {
        $validate.invoke();
    }

    private static final Unit createCenterPanel$lambda$20$lambda$14$lambda$13(KubernetesPortForwardingDialog this$0, Function0 validate) {
        Intrinsics.checkNotNullParameter((Object)validate, (String)"validate");
        this$0.addresses.addItemListener(arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$14$lambda$13$lambda$12(validate, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$20$lambda$14(KubernetesPortForwardingDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.addresses), (String)KubernetesBundle.message("action.KubernetesPod.ForwardPorts.Dialog.addresses.comment", new Object[0]), (int)0, null, (int)6, null).validationOnApply(KubernetesPortForwardingDialog::createCenterPanel$lambda$20$lambda$14$lambda$11).validationRequestor(arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$14$lambda$13(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$20$lambda$19$lambda$15(ValidationInfoBuilder $this$validationOnApply, ComboBox it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        if (!PORTS_PATTERN.matches((CharSequence)((Object)StringsKt.trim((CharSequence)((String)object))).toString())) {
            String string = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.ports.incorrect.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validationOnApply.error(string);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final ValidationInfo createCenterPanel$lambda$20$lambda$19$lambda$16(Ref.ObjectRef $usedPortError, ValidationInfoBuilder $this$validationOnInput, ComboBox it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($usedPortError.element != null) {
            Object[] objectArray = new Object[]{$usedPortError.element};
            String string = KubernetesBundle.message("dialog.message.port.not.available", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validationOnInput.warning(string);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final void createCenterPanel$lambda$20$lambda$19$lambda$18$lambda$17(Function0 $validate, ItemEvent it) {
        $validate.invoke();
    }

    private static final Unit createCenterPanel$lambda$20$lambda$19$lambda$18(KubernetesPortForwardingDialog this$0, Ref.ObjectRef $usedPortError, Function0 validate) {
        Intrinsics.checkNotNullParameter((Object)validate, (String)"validate");
        this$0.ports.addItemListener(arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$19$lambda$18$lambda$17(validate, arg_0));
        UiScopeKt.launchOnShow$default((Component)((Component)this$0.ports), (String)"checking ports", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, (Ref.ObjectRef<String>)$usedPortError, (Function0<Unit>)validate, null){
            int label;
            final /* synthetic */ KubernetesPortForwardingDialog this$0;
            final /* synthetic */ Ref.ObjectRef<String> $usedPortError;
            final /* synthetic */ Function0<Unit> $validate;
            {
                this.this$0 = $receiver;
                this.$usedPortError = $usedPortError;
                this.$validate = $validate;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)KubernetesPortForwardingDialog.access$portsFieldChangesFlow(this.this$0), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this.$usedPortError, this.this$0, this.$validate, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ Ref.ObjectRef<String> $usedPortError;
                            final /* synthetic */ KubernetesPortForwardingDialog this$0;
                            final /* synthetic */ Function0<Unit> $validate;
                            {
                                this.$usedPortError = $usedPortError;
                                this.this$0 = $receiver;
                                this.$validate = $validate;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (String)this.L$0;
                                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$usedPortError.element = null;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)text);
                                        this.label = 1;
                                        v0 = KubernetesPortForwardingDialog.access$getNonAvailablePorts(this.this$0, (String)text, (Continuation)this);
                                        if (v0 == var4_3) {
                                            return var4_3;
                                        }
                                        ** GOTO lbl16
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl16:
                                        // 2 sources

                                        if (((Collection)(nonAvailablePorts = (List)v0)).isEmpty() == false) {
                                            this.$usedPortError.element = CollectionsKt.joinToString$default((Iterable)nonAvailablePorts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                                        }
                                        this.$validate.invoke();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$20$lambda$19(KubernetesPortForwardingDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Ref.ObjectRef usedPortError = new Ref.ObjectRef();
        Object[] objectArray = new Object[]{"<code>7070:8080 9090:9090</code>"};
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.ports), (String)KubernetesBundle.message("action.KubernetesPod.ForwardPorts.Dialog.ports.comment.template", objectArray), (int)0, null, (int)6, null).validationOnApply(KubernetesPortForwardingDialog::createCenterPanel$lambda$20$lambda$19$lambda$15).validationOnInput((arg_0, arg_1) -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$19$lambda$16(usedPortError, arg_0, arg_1)).validationRequestor(arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$19$lambda$18(this$0, usedPortError, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$20(KubernetesPortForwardingDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        if (this$0.targetComboBox != null) {
            String string = KubernetesBundle.message("PortForwardingView.table.heading.resource", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$9(this$0, arg_0));
        }
        String string = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.addresses.labelText", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$14(this$0, arg_0));
        String string2 = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.ports.labelText", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> KubernetesPortForwardingDialog.createCenterPanel$lambda$20$lambda$19(this$0, arg_0));
        return Unit.INSTANCE;
    }

    public /* synthetic */ KubernetesPortForwardingDialog(Project project, KubernetesObject target, List availableServices, DefaultConstructorMarker $constructor_marker) {
        this(project, target, availableServices);
    }

    public static final /* synthetic */ Object access$getNonAvailablePorts(KubernetesPortForwardingDialog $this, String text, Continuation $completion) {
        return $this.getNonAvailablePorts(text, (Continuation<? super List<Integer>>)$completion);
    }

    public static final /* synthetic */ List access$getAddresses(KubernetesPortForwardingDialog $this) {
        return $this.getAddresses();
    }

    public static final /* synthetic */ Regex access$getPORT_MAPPING_PATTERN$cp() {
        return PORT_MAPPING_PATTERN;
    }

    public static final /* synthetic */ Flow access$portsFieldChangesFlow(KubernetesPortForwardingDialog $this) {
        return $this.portsFieldChangesFlow();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog$Companion;", "", "<init>", "()V", "PORT", "", "PORT_MAPPING", "PORTS_PATTERN", "Lkotlin/text/Regex;", "PORT_MAPPING_PATTERN", "show", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "pod", "Lio/kubernetes/client/common/KubernetesObject;", "services", "", "shouldSelectInServiceView", "", "recreateIfTerminated", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesPodForwardPortsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,406:1\n30#2,2:407\n*S KotlinDebug\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog$Companion\n*L\n224#1:407,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void show(@NotNull KubernetesApiModelInterface apiModel, @Nullable KubernetesObject pod, @Nullable List<? extends KubernetesObject> services2, boolean shouldSelectInServiceView, boolean recreateIfTerminated) {
            Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
            KubernetesPortForwardingDialog dialog = new KubernetesPortForwardingDialog(apiModel.getProject(), pod, services2, null);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            dialog.saveHistory();
            PortForwarding portForwarding = dialog.getPortForwardingSettings();
            PortForwardingProcess process = (PortForwardingProcess)ActionsKt.runWriteAction(() -> Companion.show$lambda$0(apiModel, portForwarding, recreateIfTerminated));
            ComponentManager $this$service$iv = (ComponentManager)apiModel.getProject();
            boolean $i$f$service = false;
            Class<KubernetesPortForwardingNotificationService> serviceClass$iv = KubernetesPortForwardingNotificationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((KubernetesPortForwardingNotificationService)object).subscribeOnProcessAndNotifyErrors(process, shouldSelectInServiceView);
        }

        public static /* synthetic */ void show$default(Companion companion, KubernetesApiModelInterface kubernetesApiModelInterface, KubernetesObject kubernetesObject, List list2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl2 = bl;
            }
            companion.show(kubernetesApiModelInterface, kubernetesObject, list2, bl, bl2);
        }

        private static final PortForwardingProcess show$lambda$0(KubernetesApiModelInterface $apiModel, PortForwarding $portForwarding, boolean $recreateIfTerminated) {
            return KubernetesPortForwardingService.Companion.getInstance().getOrCreatePortForwarding($apiModel, $portForwarding, $recreateIfTerminated);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog$ExpandableTextBoxEditor;", "Ljavax/swing/plaf/basic/BasicComboBoxEditor;", "<init>", "(Lcom/intellij/kubernetes/view/ui/actions/KubernetesPortForwardingDialog;)V", "createEditorComponent", "Ljavax/swing/JTextField;", "intellij.clouds.kubernetes"})
    public final class ExpandableTextBoxEditor
    extends BasicComboBoxEditor {
        @Override
        @NotNull
        protected JTextField createEditorComponent() {
            ExpandableTextField expandableTextField;
            ExpandableTextField $this$createEditorComponent_u24lambda_u240 = expandableTextField = new ExpandableTextField();
            boolean bl = false;
            $this$createEditorComponent_u24lambda_u240.setBorder(null);
            $this$createEditorComponent_u24lambda_u240.setColumns(40);
            return (JTextField)expandableTextField;
        }
    }
}

