/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.quarkus.run.QsRunConfiguration;
import com.intellij.quarkus.run.QsRunConfigurationService;
import com.intellij.quarkus.run.QsServerConfiguration;
import com.intellij.ui.SimpleTextAttributes;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/quarkus/run/QsRunDashboardCustomizer;", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "<init>", "()V", "isApplicable", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "updatePresentation", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "node", "Lcom/intellij/execution/dashboard/RunDashboardRunConfigurationNode;", "ApplicationLinkListener", "intellij.quarkus"})
public final class QsRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getConfiguration() instanceof QsRunConfiguration;
    }

    public boolean updatePresentation(@NotNull PresentationData presentation, @NotNull RunDashboardRunConfigurationNode node) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node.getConfigurationSettings().getConfiguration() instanceof QsRunConfiguration)) {
            return false;
        }
        node.putUserData(RunDashboardCustomizer.NODE_LINKS, null);
        RunContentDescriptor runContentDescriptor = node.getDescriptor();
        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
            return true;
        }
        RunContentDescriptor handler = runContentDescriptor;
        if (!handler.isProcessTerminated()) {
            QsServerConfiguration qsServerConfiguration = (QsServerConfiguration)handler.getUserData(QsRunConfigurationService.Companion.getSERVER_CONFIGURATION_KEY());
            if (qsServerConfiguration == null) {
                return true;
            }
            QsServerConfiguration serverConfiguration = qsServerConfiguration;
            if (serverConfiguration == QsRunConfigurationService.Companion.getDEFAULT_SERVER_CONFIGURATION()) {
                return true;
            }
            presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String applicationLink = ":" + serverConfiguration.getServerPort();
            presentation.addText(applicationLink, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Map links = new HashMap();
            links.put(applicationLink, new ApplicationLinkListener(serverConfiguration));
            node.putUserData(RunDashboardCustomizer.NODE_LINKS, (Object)links);
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\t\u0010\b\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/quarkus/run/QsRunDashboardCustomizer$ApplicationLinkListener;", "Ljava/lang/Runnable;", "serverConfiguration", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "<init>", "(Lcom/intellij/quarkus/run/QsServerConfiguration;)V", "run", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.quarkus"})
    private static final class ApplicationLinkListener
    implements Runnable {
        @NotNull
        private final QsServerConfiguration serverConfiguration;

        public ApplicationLinkListener(@NotNull QsServerConfiguration serverConfiguration) {
            Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
            this.serverConfiguration = serverConfiguration;
        }

        @Override
        public void run() {
            BrowserUtil.browse((String)this.serverConfiguration.getApplicationUrl());
        }

        private final QsServerConfiguration component1() {
            return this.serverConfiguration;
        }

        @NotNull
        public final ApplicationLinkListener copy(@NotNull QsServerConfiguration serverConfiguration) {
            Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
            return new ApplicationLinkListener(serverConfiguration);
        }

        public static /* synthetic */ ApplicationLinkListener copy$default(ApplicationLinkListener applicationLinkListener, QsServerConfiguration qsServerConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                qsServerConfiguration = applicationLinkListener.serverConfiguration;
            }
            return applicationLinkListener.copy(qsServerConfiguration);
        }

        @NotNull
        public String toString() {
            return "ApplicationLinkListener(serverConfiguration=" + this.serverConfiguration + ")";
        }

        public int hashCode() {
            return this.serverConfiguration.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApplicationLinkListener)) {
                return false;
            }
            ApplicationLinkListener applicationLinkListener = (ApplicationLinkListener)other;
            return Intrinsics.areEqual((Object)this.serverConfiguration, (Object)applicationLinkListener.serverConfiguration);
        }
    }
}

