/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.extensions;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.microservices.jvm.dependencies.FrameworkDependenciesModificationContext;
import com.intellij.microservices.jvm.dependencies.FrameworkDependenciesModificationContextKt;
import com.intellij.microservices.jvm.dependencies.FrameworkDependency;
import com.intellij.microservices.jvm.dependencies.FrameworkDependencyCoordinates;
import com.intellij.microservices.jvm.dependencies.Version;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.run.extensions.QsExtensionsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0014B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/quarkus/run/extensions/QsExtensionsModifier;", "", "module", "Lcom/intellij/openapi/module/Module;", "dependencies", "", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "selectedDependencies", "frameworkVersion", "", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/util/Collection;Ljava/util/Collection;Ljava/lang/String;)V", "launchModification", "", "modifyStarters", "removeDependencies", "", "context", "Lcom/intellij/microservices/jvm/dependencies/FrameworkDependenciesModificationContext;", "addDependencies", "QsExtensionsModifierService", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsExtensionsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsExtensionsModifier.kt\ncom/intellij/quarkus/run/extensions/QsExtensionsModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1617#2,9:87\n1869#2:96\n1870#2:98\n1626#2:99\n1617#2,9:100\n1869#2:109\n1870#2:111\n1626#2:112\n1#3:97\n1#3:110\n*S KotlinDebug\n*F\n+ 1 QsExtensionsModifier.kt\ncom/intellij/quarkus/run/extensions/QsExtensionsModifier\n*L\n41#1:87,9\n41#1:96\n41#1:98\n41#1:99\n57#1:100,9\n57#1:109\n57#1:111\n57#1:112\n41#1:97\n57#1:110\n*E\n"})
public class QsExtensionsModifier {
    @NotNull
    private final Module module;
    @NotNull
    private final Collection<WebStarterDependency> dependencies;
    @NotNull
    private final Collection<WebStarterDependency> selectedDependencies;
    @NotNull
    private final String frameworkVersion;

    public QsExtensionsModifier(@NotNull Module module, @NotNull Collection<? extends WebStarterDependency> dependencies, @NotNull Collection<? extends WebStarterDependency> selectedDependencies, @NotNull String frameworkVersion) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(selectedDependencies, (String)"selectedDependencies");
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        this.module = module;
        this.dependencies = dependencies;
        this.selectedDependencies = selectedDependencies;
        this.frameworkVersion = frameworkVersion;
    }

    public final void launchModification() {
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        QsExtensionsModifierService.Companion.getInstance(project).applyModifier(this);
    }

    public final void modifyStarters() {
        block1: {
            Version version = Version.parse((String)this.frameworkVersion);
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"parse(...)");
            FrameworkDependenciesModificationContext context = FrameworkDependenciesModificationContextKt.prepareModificationContext(this.dependencies, this.selectedDependencies, (Version)version);
            boolean removed = this.removeDependencies(context);
            boolean added = this.addDependencies(context);
            if (!removed && !added) break block1;
            QsExtensionsManager qsExtensionsManager = QsExtensionsManager.Companion.getInstance$intellij_quarkus(this.module);
            if (qsExtensionsManager != null) {
                qsExtensionsManager.refresh(this.module);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeDependencies(FrameworkDependenciesModificationContext context) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = context.getRemovedDependencies();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnifiedDependency unifiedDependency;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            WebStarterDependency it = (WebStarterDependency)element$iv$iv;
            boolean bl2 = false;
            FrameworkDependency frameworkDependency = it instanceof FrameworkDependency ? (FrameworkDependency)it : null;
            if (frameworkDependency == null) {
                unifiedDependency = null;
            } else {
                FrameworkDependency dependency = frameworkDependency;
                if (dependency.getCoordinates() == null) {
                    unifiedDependency = null;
                } else {
                    FrameworkDependencyCoordinates coordinates;
                    String string = coordinates.getGroupId();
                    String string2 = coordinates.getArtifactId();
                    String string3 = coordinates.getVersion();
                    if (string3 == null) {
                        string3 = "";
                    }
                    unifiedDependency = new UnifiedDependency(string, string2, string3, "");
                }
            }
            if (unifiedDependency == null) continue;
            UnifiedDependency it$iv$iv = unifiedDependency;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List removedDependencies = (List)destination$iv$iv;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DependencyModifierService modifierService = DependencyModifierService.Companion.getInstance(project);
        for (UnifiedDependency dependency : removedDependencies) {
            modifierService.removeDependency(this.module, dependency);
        }
        return !((Collection)removedDependencies).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addDependencies(FrameworkDependenciesModificationContext context) {
        List addedDependencies;
        block7: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = context.getAddedDependencies();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UnifiedDependency unifiedDependency;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                WebStarterDependency it = (WebStarterDependency)element$iv$iv;
                boolean bl2 = false;
                FrameworkDependency frameworkDependency = it instanceof FrameworkDependency ? (FrameworkDependency)it : null;
                if (frameworkDependency == null) {
                    unifiedDependency = null;
                } else {
                    FrameworkDependency dependency = frameworkDependency;
                    if (dependency.getCoordinates() == null) {
                        unifiedDependency = null;
                    } else {
                        String string;
                        FrameworkDependencyCoordinates coordinates;
                        String string2 = coordinates.getGroupId();
                        String string3 = coordinates.getArtifactId();
                        String string4 = coordinates.getVersion();
                        if (string4 == null) {
                            string4 = "";
                        }
                        if ((string = coordinates.getScope()) == null) {
                            string = "compile";
                        }
                        unifiedDependency = new UnifiedDependency(string2, string3, string4, string);
                    }
                }
                if (unifiedDependency == null) continue;
                UnifiedDependency it$iv$iv = unifiedDependency;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            addedDependencies = (List)destination$iv$iv;
            QsExtensionsManager qsExtensionsManager = QsExtensionsManager.Companion.getInstance$intellij_quarkus(this.module);
            if (qsExtensionsManager == null) break block7;
            qsExtensionsManager.addDependencies(this.module, addedDependencies);
        }
        return !((Collection)addedDependencies).isEmpty();
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/quarkus/run/extensions/QsExtensionsModifier$QsExtensionsModifierService;", "Lcom/intellij/openapi/Disposable;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "dispose", "", "applyModifier", "modifier", "Lcom/intellij/quarkus/run/extensions/QsExtensionsModifier;", "Companion", "intellij.quarkus"})
    private static final class QsExtensionsModifierService
    implements Disposable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CoroutineScope cs;

        public QsExtensionsModifierService(@NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.cs = cs;
        }

        public void dispose() {
        }

        public final void applyModifier(@NotNull QsExtensionsModifier modifier) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(modifier, null){
                int label;
                final /* synthetic */ QsExtensionsModifier $modifier;
                {
                    this.$modifier = $modifier;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$modifier.modifyStarters();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/quarkus/run/extensions/QsExtensionsModifier$QsExtensionsModifierService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/quarkus/run/extensions/QsExtensionsModifier$QsExtensionsModifierService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.quarkus"})
        @SourceDebugExtension(value={"SMAP\nQsExtensionsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsExtensionsModifier.kt\ncom/intellij/quarkus/run/extensions/QsExtensionsModifier$QsExtensionsModifierService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,86:1\n30#2,2:87\n*S KotlinDebug\n*F\n+ 1 QsExtensionsModifier.kt\ncom/intellij/quarkus/run/extensions/QsExtensionsModifier$QsExtensionsModifierService$Companion\n*L\n83#1:87,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final QsExtensionsModifierService getInstance(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<QsExtensionsModifierService> serviceClass$iv = QsExtensionsModifierService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (QsExtensionsModifierService)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

