/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices.endpoints;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableCollection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0002H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/intellij/httpClient/http/request/microservices/endpoints/RangeHighlightersModel;", "Lkotlin/collections/AbstractMutableCollection;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "rangeHighlighters", "", "value", "lastAddedElement", "getLastAddedElement", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getNextRangeHighlighter", "offset", "", "findRangeHighlighter", "hasRangeHighlighterInOffset", "", "hasRangeHighlightersInSegment", "segment", "Lcom/intellij/openapi/util/Segment;", "removeInvalid", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "size", "getSize", "()I", "iterator", "", "add", "element", "remove", "clear", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientTabUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientTabUtils.kt\ncom/intellij/httpClient/http/request/microservices/endpoints/RangeHighlightersModel\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1923#2,14:200\n1463#2,14:214\n1#3:228\n774#4:229\n865#4,2:230\n1563#4:232\n1634#4,3:233\n*S KotlinDebug\n*F\n+ 1 HttpClientTabUtils.kt\ncom/intellij/httpClient/http/request/microservices/endpoints/RangeHighlightersModel\n*L\n38#1:200,14\n43#1:214,14\n56#1:229\n56#1:230,2\n68#1:232\n68#1:233,3\n*E\n"})
public final class RangeHighlightersModel
extends AbstractMutableCollection<RangeHighlighter> {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<RangeHighlighter> rangeHighlighters;
    private RangeHighlighter lastAddedElement;

    public RangeHighlightersModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rangeHighlighters = new LinkedHashSet();
    }

    @NotNull
    public final RangeHighlighter getLastAddedElement() {
        RangeHighlighter rangeHighlighter = this.lastAddedElement;
        if (rangeHighlighter != null) {
            return rangeHighlighter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lastAddedElement");
        return null;
    }

    @Nullable
    public final RangeHighlighter getNextRangeHighlighter(int offset) {
        Object v0;
        Sequence $this$minByOrNull$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.rangeHighlighters), arg_0 -> RangeHighlightersModel.getNextRangeHighlighter$lambda$0(offset, arg_0));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                RangeHighlighter it = (RangeHighlighter)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getStartOffset();
                do {
                    Object e$iv = iterator$iv.next();
                    RangeHighlighter it2 = (RangeHighlighter)e$iv;
                    $i$a$-minByOrNull-RangeHighlightersModel$getNextRangeHighlighter$2 = false;
                    int v$iv = it2.getStartOffset();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    @Nullable
    public final RangeHighlighter findRangeHighlighter(int offset) {
        Object object;
        Object v0;
        Sequence $this$maxByOrNull$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.rangeHighlighters), arg_0 -> RangeHighlightersModel.findRangeHighlighter$lambda$2(offset, arg_0));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                RangeHighlighter it = (RangeHighlighter)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getStartOffset();
                do {
                    Object e$iv = iterator$iv.next();
                    RangeHighlighter it2 = (RangeHighlighter)e$iv;
                    $i$a$-maxByOrNull-RangeHighlightersModel$findRangeHighlighter$2 = false;
                    int v$iv = it2.getStartOffset();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        RangeHighlighter rangeHighlighter = v0;
        if (rangeHighlighter != null) {
            RangeHighlighter rangeHighlighter2;
            RangeHighlighter it = rangeHighlighter2 = rangeHighlighter;
            boolean bl = false;
            object = it.contains(offset) ? rangeHighlighter2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public final boolean hasRangeHighlighterInOffset(int offset) {
        return this.findRangeHighlighter(offset) != null;
    }

    public final boolean hasRangeHighlightersInSegment(@NotNull Segment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        return SequencesKt.any((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.rangeHighlighters), arg_0 -> RangeHighlightersModel.hasRangeHighlightersInSegment$lambda$5(segment, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public final void removeInvalid(@NotNull Editor editor2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.project);
        Iterable $this$filter$iv = this.rangeHighlighters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            boolean bl = false;
            if (!(!it.isValid() || it.getStartOffset() == it.getEndOffset())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invalidHighlighters = (List)destination$iv$iv;
        this.rangeHighlighters.removeAll(CollectionsKt.toSet((Iterable)invalidHighlighters));
        for (RangeHighlighter highlighter : invalidHighlighters) {
            highlightManager.removeSegmentHighlighter(editor2, highlighter);
        }
    }

    public int getSize() {
        return this.rangeHighlighters.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterator<RangeHighlighter> iterator() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.rangeHighlighters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RangeHighlighter rangeHighlighter = (RangeHighlighter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)).listIterator();
    }

    public boolean add(@NotNull RangeHighlighter element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean it = bl = this.rangeHighlighters.add(element);
        boolean bl2 = false;
        this.lastAddedElement = element;
        return bl;
    }

    public boolean remove(@NotNull RangeHighlighter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.rangeHighlighters.remove(element);
    }

    public void clear() {
        this.rangeHighlighters.clear();
    }

    private static final boolean getNextRangeHighlighter$lambda$0(int $offset, RangeHighlighter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStartOffset() >= $offset;
    }

    private static final boolean findRangeHighlighter$lambda$2(int $offset, RangeHighlighter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStartOffset() <= $offset;
    }

    private static final boolean hasRangeHighlightersInSegment$lambda$5(Segment $segment, RangeHighlighter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStartOffset() >= $segment.getStartOffset() && it.getStartOffset() <= $segment.getEndOffset();
    }
}

