/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibCheckers;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDeclarationsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContext;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExportingDeclaration;
import org.jetbrains.kotlin.ir.backend.js.checkers.declarations.JsKlibEsModuleExportsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.declarations.JsKlibFileClashChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.declarations.JsKlibOtherModuleExportsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.expressions.JsKlibJsCodeCallChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052 \b\u0002\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00180\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibCheckers;", "", "<init>", "()V", "moduleChecker", "", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/declarations/JsKlibFileClashChecker;", "exportedDeclarationsCheckers", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDeclarationsChecker;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration;", "callCheckers", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/expressions/JsKlibJsCodeCallChecker;", "makeChecker", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "doCheckCalls", "", "doModuleLevelChecks", "cleanFiles", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "exportedNames", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "ir.serialization.js"})
public final class JsKlibCheckers {
    @NotNull
    public static final JsKlibCheckers INSTANCE = new JsKlibCheckers();
    @NotNull
    private static final List<JsKlibFileClashChecker> moduleChecker = CollectionsKt.listOf((Object)JsKlibFileClashChecker.INSTANCE);
    @NotNull
    private static final List<JsKlibDeclarationsChecker<JsKlibExportingDeclaration>> exportedDeclarationsCheckers;
    @NotNull
    private static final List<JsKlibJsCodeCallChecker> callCheckers;

    private JsKlibCheckers() {
    }

    @NotNull
    public final IrVisitorVoid makeChecker(@NotNull IrDiagnosticReporter diagnosticReporter, @NotNull CompilerConfiguration configuration, boolean doCheckCalls, boolean doModuleLevelChecks, @NotNull List<SerializedIrFile> cleanFiles, @NotNull Map<IrFile, ? extends Map<IrDeclarationWithName, String>> exportedNames) {
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(cleanFiles, (String)"cleanFiles");
        Intrinsics.checkNotNullParameter(exportedNames, (String)"exportedNames");
        return new IrVisitorVoid(configuration, doModuleLevelChecks, cleanFiles, exportedNames, diagnosticReporter, doCheckCalls){
            private final JsKlibDiagnosticContext diagnosticContext;
            final /* synthetic */ boolean $doModuleLevelChecks;
            final /* synthetic */ List<SerializedIrFile> $cleanFiles;
            final /* synthetic */ Map<IrFile, Map<IrDeclarationWithName, String>> $exportedNames;
            final /* synthetic */ IrDiagnosticReporter $diagnosticReporter;
            final /* synthetic */ boolean $doCheckCalls;
            {
                this.$doModuleLevelChecks = $doModuleLevelChecks;
                this.$cleanFiles = $cleanFiles;
                this.$exportedNames = $exportedNames;
                this.$diagnosticReporter = $diagnosticReporter;
                this.$doCheckCalls = $doCheckCalls;
                this.diagnosticContext = new JsKlibDiagnosticContext($configuration);
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof IrDeclaration) {
                    this.diagnosticContext.withDeclarationScope((IrDeclaration)element, (Function0<Unit>)((Function0)() -> makeChecker.1.visitElement$lambda$0(element, this)));
                } else {
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }
            }

            public void visitModuleFragment(IrModuleFragment declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (this.$doModuleLevelChecks) {
                    List<JsKlibExportingDeclaration> exportedDeclarations = JsKlibExportingDeclaration.Companion.collectDeclarations(this.$cleanFiles, declaration.getFiles(), this.$exportedNames);
                    for (Object checker : JsKlibCheckers.access$getExportedDeclarationsCheckers$p()) {
                        checker.check(exportedDeclarations, this.diagnosticContext, this.$diagnosticReporter);
                    }
                    for (Object checker : JsKlibCheckers.access$getModuleChecker$p()) {
                        ((JsKlibFileClashChecker)checker).check(declaration, this.diagnosticContext, this.$diagnosticReporter);
                    }
                }
                super.visitModuleFragment(declaration);
            }

            public void visitFile(IrFile declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.diagnosticContext.withFileScope(declaration, (Function0<Unit>)((Function0)() -> makeChecker.1.visitFile$lambda$1(this, declaration)));
            }

            public void visitCall(IrCall expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (this.$doCheckCalls) {
                    for (JsKlibJsCodeCallChecker checker : JsKlibCheckers.access$getCallCheckers$p()) {
                        checker.check(expression, this.diagnosticContext, this.$diagnosticReporter);
                    }
                }
                super.visitCall(expression);
            }

            private static final Unit visitElement$lambda$0(IrElement $element, makeChecker.1 this$0) {
                IrVisitorsKt.acceptChildrenVoid($element, this$0);
                return Unit.INSTANCE;
            }

            private static final Unit visitFile$lambda$1(makeChecker.1 this$0, IrFile $declaration) {
                super.visitFile($declaration);
                return Unit.INSTANCE;
            }
        };
    }

    public static /* synthetic */ IrVisitorVoid makeChecker$default(JsKlibCheckers jsKlibCheckers, IrDiagnosticReporter irDiagnosticReporter, CompilerConfiguration compilerConfiguration, boolean bl, boolean bl2, List list, Map map, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        return jsKlibCheckers.makeChecker(irDiagnosticReporter, compilerConfiguration, bl, bl2, list, map);
    }

    public static final /* synthetic */ List access$getExportedDeclarationsCheckers$p() {
        return exportedDeclarationsCheckers;
    }

    public static final /* synthetic */ List access$getModuleChecker$p() {
        return moduleChecker;
    }

    public static final /* synthetic */ List access$getCallCheckers$p() {
        return callCheckers;
    }

    static {
        Object[] objectArray = new JsKlibDeclarationsChecker[]{JsKlibEsModuleExportsChecker.INSTANCE, JsKlibOtherModuleExportsChecker.INSTANCE};
        exportedDeclarationsCheckers = CollectionsKt.listOf((Object[])objectArray);
        callCheckers = CollectionsKt.listOf((Object)JsKlibJsCodeCallChecker.INSTANCE);
    }
}

