/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/KubernetesConfigFileSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "KubernetesConfigFileSchemaProvider", "intellij.clouds.kubernetes.backend"})
public final class KubernetesConfigFileSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)new KubernetesConfigFileSchemaProvider(project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/KubernetesConfigFileSchemaProviderFactory$KubernetesConfigFileSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAvailable", "", "file", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "intellij.clouds.kubernetes.backend"})
    private static final class KubernetesConfigFileSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project project;

        public KubernetesConfigFileSchemaProvider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public VirtualFile getSchemaFile() {
            URL uRL = this.getClass().getClassLoader().getResource("api-spec/common/kubeconfig-schema.json");
            Intrinsics.checkNotNull((Object)uRL);
            URL resourceUrl = uRL;
            String string = VfsUtilCore.convertFromUrl((URL)resourceUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertFromUrl(...)");
            String vfsUrl = string;
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(vfsUrl);
            Intrinsics.checkNotNull((Object)virtualFile);
            return virtualFile;
        }

        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return KubeConfig.isKubeConfig((VirtualFile)file, (Project)this.project);
        }

        @NotNull
        public String getName() {
            String string = KubernetesBundle.message((String)"Kubernetes.ConfigFileJsonSchemaProvider.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.schema;
        }
    }
}

