/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions.contexts;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/contexts/KubernetesAddContextActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "connectToClusterIfNeeded", "contexts", "", "Lcom/intellij/kubernetes/api/Context;", "apiProvider", "Lcom/intellij/kubernetes/api/KubernetesApiProviderInterface;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes.backend"})
@ApiStatus.Internal
public abstract class KubernetesAddContextActionBase
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setEnabledAndVisible(e.getProject() != null);
        if (!presentation2.isVisible()) {
            return;
        }
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"GoToAction")) {
            presentation2.setText(KubernetesBundle.message((String)"group.Kubernetes.AddContexts.text", (Object[])new Object[0]) + " " + presentation2.getText());
        }
    }

    public final void connectToClusterIfNeeded(@NotNull List<Context> contexts2, @NotNull KubernetesApiProviderInterface apiProvider, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(contexts2, (String)"contexts");
        Intrinsics.checkNotNullParameter((Object)apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set allContexts = apiProvider.getConfiguredContexts();
        if (contexts2.size() == 1 && allContexts.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first(contexts2), (Object)CollectionsKt.first((Iterable)allContexts))) {
            apiProvider.setContextToSettings(KubernetesProjectSettings.Companion.getInstance(project), (Context)CollectionsKt.single(contexts2));
        }
    }
}

