/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi.highlighting;

import com.intellij.aop.AopBundle;
import com.intellij.aop.AopPointcut;
import com.intellij.aop.jam.AopPointcutImpl;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.psi.AopMemberReferenceExpression;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopReferenceQualifier;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.aop.psi.PsiPointcutReferenceExpression;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public final class AopLanguageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            AopLanguageInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            AopLanguageInspection.$$$reportNull$$$0(1);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiElement parent = psiElement.getParent();
                if (psiElement instanceof AopReferenceExpression) {
                    if (AopLanguageInspection.checkReference(psiElement, holder, parent)) {
                        // empty if block
                    }
                } else if (psiElement instanceof PsiPointcutReferenceExpression) {
                    AopLanguageInspection.checkPointcutArgumentCount(psiElement, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/aop/psi/highlighting/AopLanguageInspection$1", "visitElement"));
            }
        };
    }

    public static boolean checkReference(PsiElement psiElement, ProblemsHolder holder, PsiElement parent) {
        AopReferenceExpression referenceExpression = (AopReferenceExpression)psiElement;
        if (referenceExpression.getResolvability() != AopReferenceExpression.Resolvability.PLAIN) {
            return true;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        PsiElement referenceNameElement = referenceExpression.getReferenceNameElement();
        if (results.length > 0) {
            for (ResolveResult result : results) {
                boolean error;
                PsiElement target = result.getElement();
                if (referenceExpression.isPointcutReference()) {
                    AopPointcutImpl pointcut;
                    if (!(target instanceof PsiMethod) || !((PsiMethod)target).getModifierList().hasAnnotation("org.aspectj.lang.annotation.Pointcut")) {
                        if (referenceNameElement != null) {
                            holder.registerProblem(referenceNameElement, AopBundle.message("error.cannot.resolve.pointcut", referenceExpression.getReferenceName()), new LocalQuickFix[0]);
                        }
                        return true;
                    }
                    PsiMethod pointcutMethod = AopPointcutUtil.getHolder(referenceExpression).getAopModel().getPointcutMethod();
                    if (pointcutMethod != null && (pointcut = JamAopModel.getPointcut(pointcutMethod)) != null && AopLanguageInspection.isRecursivePointcutRef(referenceExpression, pointcut, 3)) {
                        holder.registerProblem((PsiElement)referenceExpression, AopBundle.message("error.recursive.pointcut.reference", referenceExpression), new LocalQuickFix[0]);
                        return true;
                    }
                }
                if (!referenceExpression.isAnnotationReference()) continue;
                if (target instanceof PsiClass) {
                    error = !((PsiClass)target).isAnnotationType();
                } else if (target instanceof PsiParameter) {
                    PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)((PsiParameter)target).getType());
                    error = psiClass == null || !psiClass.isAnnotationType();
                } else {
                    boolean bl = error = target != null;
                }
                if (!error) continue;
                if (referenceNameElement != null) {
                    holder.registerProblem(referenceNameElement, AopBundle.message("error.anno.expected", new Object[0]), new LocalQuickFix[0]);
                }
                return true;
            }
            return true;
        }
        AopReferenceExpression qualifier = (AopReferenceExpression)referenceExpression.getQualifier();
        if (qualifier != null && qualifier.resolve() == null) {
            return true;
        }
        if (qualifier == null && !(referenceExpression.getParent() instanceof AopReferenceQualifier) && parent instanceof AopMemberReferenceExpression) {
            return true;
        }
        if (referenceNameElement != null) {
            if (referenceExpression.isPointcutReference()) {
                holder.registerProblem(referenceNameElement, AopBundle.message("error.cannot.resolve.pointcut", referenceExpression.getReferenceName()), new LocalQuickFix[0]);
            } else {
                holder.registerProblem(referenceNameElement, AopBundle.message("error.cannot.resolve.symbol", referenceExpression.getReferenceName()), new LocalQuickFix[0]);
            }
        }
        return false;
    }

    private static boolean isRecursivePointcutRef(@NotNull AopReferenceExpression aopReferenceExpression, final @NotNull AopPointcut startPointcut, final int depth) {
        AopPointcut pointcut;
        if (aopReferenceExpression == null) {
            AopLanguageInspection.$$$reportNull$$$0(2);
        }
        if (startPointcut == null) {
            AopLanguageInspection.$$$reportNull$$$0(3);
        }
        if ((pointcut = aopReferenceExpression.resolvePointcut()) == null) {
            return false;
        }
        if (pointcut.equals(startPointcut)) {
            return true;
        }
        if (depth == 0) {
            return false;
        }
        PsiPointcutExpression expression = (PsiPointcutExpression)pointcut.getExpression().getValue();
        final Ref result = Ref.create((Object)false);
        if (expression != null) {
            expression.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    PsiPointcutReferenceExpression pointcutReferenceExpression;
                    AopReferenceExpression referenceExpression;
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (((Boolean)result.get()).booleanValue()) {
                        return;
                    }
                    if (element instanceof PsiPointcutExpression) {
                        super.visitElement(element);
                    }
                    if (element instanceof PsiPointcutReferenceExpression && (referenceExpression = (pointcutReferenceExpression = (PsiPointcutReferenceExpression)element).getReferenceExpression()) != null && AopLanguageInspection.isRecursivePointcutRef(referenceExpression, startPointcut, depth - 1)) {
                        result.set((Object)true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/aop/psi/highlighting/AopLanguageInspection$2", "visitElement"));
                }
            });
        }
        return (Boolean)result.get();
    }

    private static void checkPointcutArgumentCount(PsiElement psiElement, ProblemsHolder holder) {
        PsiElement[] elements;
        int actual;
        AopParameterList parameterList;
        int expected;
        AopPointcut aopPointcut;
        PsiPointcutReferenceExpression expression = (PsiPointcutReferenceExpression)psiElement;
        AopReferenceExpression referenceExpression = expression.getReferenceExpression();
        if (referenceExpression != null && (aopPointcut = referenceExpression.resolvePointcut()) != null && (expected = aopPointcut.getParameterCount()) >= 0 && (parameterList = expression.getParameterList()) != null && (actual = (elements = parameterList.getParameters()).length) != expected) {
            holder.registerProblem((PsiElement)parameterList, AopBundle.message("error.invalid.number.of.arguments", expected, actual), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aopReferenceExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPointcut";
                break;
            }
        }
        objectArray2[1] = "com/intellij/aop/psi/highlighting/AopLanguageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRecursivePointcutRef";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

