/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.hibernate.HibernateBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MappingElementConverterBase
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            MappingElementConverterBase.$$$reportNull$$$0(0);
        }
        if (s == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)context.getReferenceXmlElement(), context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof PsiFile ? (PsiFile)element : null;
    }

    public String toString(@Nullable PsiFile psiFile, @NotNull ConvertContext context) {
        if (context == null) {
            MappingElementConverterBase.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        VirtualFile root = this.getRootForFile(file, context);
        if (root == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
    }

    @Nullable
    protected VirtualFile getRootForFile(VirtualFile file, ConvertContext context) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)context.getPsiManager().getProject()).getFileIndex();
        VirtualFile root = projectFileIndex.getSourceRootForFile(file);
        if (root == null) {
            root = projectFileIndex.getContentRootForFile(file);
        }
        return root;
    }

    @NotNull
    public Collection<? extends PsiFile> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            MappingElementConverterBase.$$$reportNull$$$0(2);
        }
        List list = Collections.emptyList();
        if (list == null) {
            MappingElementConverterBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    public PsiElement resolve(PsiFile o, @NotNull ConvertContext context) {
        if (context == null) {
            MappingElementConverterBase.$$$reportNull$$$0(4);
        }
        return this.isFileAccepted(o) ? super.resolve((Object)o, context) : null;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                MappingElementConverterBase.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        PsiReference[] psiReferenceArray = new FilePathReferenceProvider(){

            protected boolean isPsiElementAccepted(PsiElement element) {
                return super.isPsiElementAccepted(element) && (!(element instanceof PsiFile) || MappingElementConverterBase.this.isFileAccepted((PsiFile)element));
            }
        }.getReferencesByElement(element, s, offset, true);
        if (psiReferenceArray == null) {
            MappingElementConverterBase.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    protected abstract boolean isFileAccepted(PsiFile var1);

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            MappingElementConverterBase.$$$reportNull$$$0(7);
        }
        return HibernateBundle.message("cannot.resolve.file.0", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/model/converters/MappingElementConverterBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/model/converters/MappingElementConverterBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

