/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.RestAnnotations;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.ws.common.WsPsiUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import org.jetbrains.annotations.NotNull;

public final class RestWrongDefaultValueInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        PsiParameter[] parameters;
        if (psiMethod == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(2);
        }
        JavaeeType javaeeType = JavaeeType.discover((Module)module, (JavaeeClass)RestAnnotations.PATH);
        for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
            RestWrongDefaultValueInspection.check((PsiVariable)parameter, holder, javaeeType);
        }
    }

    @Override
    protected void checkFields(@NotNull PsiField field, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (field == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(4);
        }
        if (module == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(5);
        }
        RestWrongDefaultValueInspection.check((PsiVariable)field, holder, JavaeeType.discover((Module)module, (JavaeeClass)RestAnnotations.PATH));
    }

    private static void check(PsiVariable variable, ProblemsHolder problems, @NotNull JavaeeType javaeeType) {
        PsiType psiType;
        if (javaeeType == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(6);
        }
        if ((psiType = variable.getType()) instanceof PsiPrimitiveType) {
            PsiAnnotation anno;
            PsiPrimitiveType type = (PsiPrimitiveType)psiType;
            PsiModifierList modifierList = variable.getModifierList();
            if (modifierList != null && (anno = modifierList.findAnnotation(RestAnnotations.DEFAULT_VALUE.fqn(javaeeType))) != null) {
                String value = WsPsiUtil.getAnnotationValue(anno);
                PsiAnnotationMemberValue problemElement = anno.findAttributeValue("value");
                if (value != null && problemElement != null && !RestWrongDefaultValueInspection.canConvert(value, type)) {
                    problems.registerProblem((PsiElement)problemElement, RSBundle.message("cant.convert.to", value, type.getPresentableText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        }
    }

    private static boolean canConvert(String s, PsiPrimitiveType type) {
        try {
            if (PsiTypes.booleanType().equals((Object)type)) {
                return s.equals("true") || s.equals("false");
            }
            if (PsiTypes.byteType().equals((Object)type)) {
                Byte.parseByte(s);
            } else if (PsiTypes.shortType().equals((Object)type)) {
                Short.parseShort(s);
            } else if (PsiTypes.intType().equals((Object)type)) {
                Integer.parseInt(s);
            } else if (PsiTypes.longType().equals((Object)type)) {
                Long.parseLong(s);
            } else if (PsiTypes.doubleType().equals((Object)type)) {
                Double.parseDouble(s);
            } else if (PsiTypes.floatType().equals((Object)type)) {
                Float.parseFloat(s);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

