/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.AbstractProcessableModel;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.SpringCachingProcessor;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheableCommonSpringModel
extends AbstractProcessableModel
implements CommonSpringModel {
    private CachedValue<LocalBeansByNameCachingProcessor> myBeanNameCachingProcessor = null;
    private CachedValue<LocalBeansByClassCachingProcessor> myByClassCachingProcessor = null;

    public Collection<SpringBeanPointer<?>> getLocalBeans() {
        return Collections.emptyList();
    }

    @NotNull
    public Set<String> getProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public Direction traverseByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(3);
        }
        if (!params.canSearch()) {
            Direction direction = Direction.PROCEED;
            if (direction == null) {
                CacheableCommonSpringModel.$$$reportNull$$$0(4);
            }
            return direction;
        }
        if (!this.processLocalBeansByClass(params, processor)) {
            Direction direction = Direction.STOP;
            if (direction == null) {
                CacheableCommonSpringModel.$$$reportNull$$$0(5);
            }
            return direction;
        }
        Direction direction = Direction.TRAVERSE;
        if (direction == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(6);
        }
        return direction;
    }

    public boolean processLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(8);
        }
        if (!params.canSearch()) {
            return true;
        }
        CachedValue<LocalBeansByClassCachingProcessor> cachingProcessor = this.getBeanClassCachingProcessor();
        if (cachingProcessor != null) {
            return ((LocalBeansByClassCachingProcessor)cachingProcessor.getValue()).process(params, processor, this.getActiveProfiles());
        }
        return this.doProcessLocalBeansByClass(params, processor);
    }

    private boolean doProcessLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor) {
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(9);
        }
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(10);
        }
        PsiType searchType = params.getSearchType();
        if (params.isEffectiveBeanTypes()) {
            for (SpringBeanPointer<?> beanPointer : this.getLocalBeans()) {
                for (PsiType effectiveBeanType : beanPointer.getEffectiveBeanTypes()) {
                    if (CacheableCommonSpringModel.processLocalBeanClass(processor, searchType, beanPointer, effectiveBeanType)) continue;
                    return false;
                }
            }
        } else {
            for (SpringBeanPointer<?> beanPointer : this.getLocalBeans()) {
                if (CacheableCommonSpringModel.processLocalBeanClass(processor, searchType, beanPointer, beanPointer.getSpringBean().getBeanType())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processLocalBeanClass(@NotNull Processor<? super SpringBeanPointer<?>> processor, @NotNull PsiType searchType, SpringBeanPointer<?> beanPointer, @Nullable PsiType beanType) {
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(11);
        }
        if (searchType == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(12);
        }
        if (beanType != null && searchType.isAssignableFrom(beanType)) {
            return processor.process(beanPointer);
        }
        return true;
    }

    @Override
    @NotNull
    public Direction traverseByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer<?>> processor) {
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(13);
        }
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(14);
        }
        if (!params.canSearch()) {
            Direction direction = Direction.PROCEED;
            if (direction == null) {
                CacheableCommonSpringModel.$$$reportNull$$$0(15);
            }
            return direction;
        }
        if (!this.processLocalBeansByName(params, processor)) {
            Direction direction = Direction.STOP;
            if (direction == null) {
                CacheableCommonSpringModel.$$$reportNull$$$0(16);
            }
            return direction;
        }
        Direction direction = Direction.TRAVERSE;
        if (direction == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(17);
        }
        return direction;
    }

    public boolean processLocalBeansByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer<?>> processor) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(19);
        }
        if (!params.canSearch()) {
            return true;
        }
        CachedValue<LocalBeansByNameCachingProcessor> cachingProcessor = this.getBeanNameCachingProcessor();
        return cachingProcessor == null || ((LocalBeansByNameCachingProcessor)cachingProcessor.getValue()).process(params, processor, this.getActiveProfiles());
    }

    @Override
    public void processLocalBeans(@NotNull Processor<? super SpringBeanPointer<?>> processor) {
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(20);
        }
        for (SpringBeanPointer<?> beanPointer : this.getLocalBeans()) {
            if (processor.process(beanPointer)) continue;
            return;
        }
    }

    protected void doProcessLocalBeans(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer<?>> processor) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(22);
        }
        for (SpringBeanPointer<?> beanPointer : this.getLocalBeans()) {
            if (!CacheableCommonSpringModel.matchesName(params, beanPointer) || processor.process(beanPointer)) continue;
            return;
        }
    }

    @Override
    public final boolean processAllBeans(@NotNull Processor<? super SpringBeanPointer<?>> processor, boolean includeLibraries) {
        if (processor == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(23);
        }
        for (SpringBeanPointer<?> pointer : this.getLocalBeans()) {
            if (processor.process(pointer)) continue;
            return false;
        }
        return super.processAllBeans(processor, includeLibraries);
    }

    private static boolean matchesName(SpringModelSearchParameters.BeanName params, SpringBeanPointer<?> pointer) {
        String paramsBeanName = params.getBeanName();
        if (paramsBeanName.equals(pointer.getName())) {
            return true;
        }
        for (String aliasName : pointer.getAliases()) {
            if (!paramsBeanName.equals(aliasName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> getAllBeanNames(@NotNull SpringBeanPointer<?> beanPointer) {
        String beanName;
        if (beanPointer == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(24);
        }
        if (StringUtil.isEmptyOrSpaces((String)(beanName = beanPointer.getName()))) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CacheableCommonSpringModel.$$$reportNull$$$0(25);
            }
            return set;
        }
        HashSet names = ContainerUtil.newHashSet((Object[])new String[]{beanName});
        for (String aliasName : beanPointer.getAliases()) {
            if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
            names.add(aliasName);
        }
        HashSet hashSet = names;
        if (hashSet == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    @Nullable
    private CachedValue<LocalBeansByNameCachingProcessor> getBeanNameCachingProcessor() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        if (this.myBeanNameCachingProcessor == null) {
            this.myBeanNameCachingProcessor = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)new LocalBeansByNameCachingProcessor(), this.getCachingProcessorsDependencies()));
        }
        return this.myBeanNameCachingProcessor;
    }

    private CachedValue<LocalBeansByClassCachingProcessor> getBeanClassCachingProcessor() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        if (this.myByClassCachingProcessor == null) {
            this.myByClassCachingProcessor = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)new LocalBeansByClassCachingProcessor(), this.getCachingProcessorsDependencies()));
        }
        return this.myByClassCachingProcessor;
    }

    protected Collection<Object> getCachingProcessorsDependencies() {
        return Collections.singleton(ModificationTracker.EVER_CHANGED);
    }

    protected Object @NotNull [] getDependencies(@NotNull Set<PsiFile> containingFiles) {
        if (containingFiles == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(27);
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        ContainerUtil.addAllNotNull(dependencies, containingFiles);
        if (this.getModule() != null) {
            SpringModificationTrackersManager trackersManager = SpringModificationTrackersManager.getInstance(this.getModule().getProject());
            ContainerUtil.addAll(dependencies, (Object[])trackersManager.getOuterModelsDependencies());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(28);
        }
        return objectArray;
    }

    @NotNull
    public List<SpringBeanPointer<?>> findQualified(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(29);
        }
        List<SpringBeanPointer<?>> list = CacheableCommonSpringModel.findLocalBeansByQualifier(this, qualifier);
        if (list == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(30);
        }
        return list;
    }

    protected static List<SpringBeanPointer<?>> findLocalBeansByQualifier(@NotNull CacheableCommonSpringModel model, SpringQualifier springQualifier) {
        if (model == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(31);
        }
        SmartList beans2 = new SmartList();
        for (SpringBeanPointer<?> beanPointer : model.getLocalBeans()) {
            if (!beanPointer.isValid()) continue;
            Object bean = beanPointer.getSpringBean();
            for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                if (!qualifier.compareQualifiers(springQualifier, model.getModule())) continue;
                beans2.add(beanPointer);
            }
        }
        return beans2.isEmpty() ? Collections.emptyList() : beans2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 24, 27, 29, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFiles";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseByClass";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseByName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualified";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "traverseByClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doProcessLocalBeansByClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeanClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "traverseByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeans";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doProcessLocalBeans";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processAllBeans";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findQualified";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBeansByQualifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 24, 27, 29, 31 -> new IllegalArgumentException(string);
        };
    }

    private class LocalBeansByClassCachingProcessor
    extends LocalBeansCachingProcessor<SpringModelSearchParameters.BeanClass> {
        private LocalBeansByClassCachingProcessor() {
        }

        @Override
        protected void doProcessBeans(@NotNull SpringModelSearchParameters.BeanClass parameters, Processor<SpringBeanPointer<?>> collectProcessor) {
            if (parameters == null) {
                LocalBeansByClassCachingProcessor.$$$reportNull$$$0(0);
            }
            CacheableCommonSpringModel.this.doProcessLocalBeansByClass(parameters, collectProcessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/CacheableCommonSpringModel$LocalBeansByClassCachingProcessor", "doProcessBeans"));
        }
    }

    private class LocalBeansByNameCachingProcessor
    extends LocalBeansCachingProcessor<SpringModelSearchParameters.BeanName> {
        private LocalBeansByNameCachingProcessor() {
        }

        @Override
        protected void doProcessBeans(@NotNull SpringModelSearchParameters.BeanName params, Processor<SpringBeanPointer<?>> processor) {
            if (params == null) {
                LocalBeansByNameCachingProcessor.$$$reportNull$$$0(0);
            }
            CacheableCommonSpringModel.this.doProcessLocalBeans(params, processor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/CacheableCommonSpringModel$LocalBeansByNameCachingProcessor", "doProcessBeans"));
        }
    }

    private static abstract class LocalBeansCachingProcessor<InParams extends SpringModelSearchParameters>
    extends SpringCachingProcessor<InParams> {
        private LocalBeansCachingProcessor() {
        }

        @Override
        @NotNull
        protected Collection<SpringBeanPointer<?>> findPointers(@NotNull InParams parameters) {
            if (parameters == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(0);
            }
            SmartList results = new SmartList();
            Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)results);
            this.doProcessBeans(parameters, collectProcessor);
            SmartList smartList = results.isEmpty() ? Collections.emptyList() : results;
            if (smartList == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        @Override
        @Nullable
        protected SpringBeanPointer<?> findFirstPointer(@NotNull InParams parameters) {
            if (parameters == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(2);
            }
            CommonProcessors.FindFirstProcessor firstProcessor = new CommonProcessors.FindFirstProcessor();
            this.doProcessBeans(parameters, (Processor<SpringBeanPointer<?>>)firstProcessor);
            return (SpringBeanPointer)firstProcessor.getFoundValue();
        }

        protected abstract void doProcessBeans(@NotNull InParams var1, Processor<SpringBeanPointer<?>> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel$LocalBeansCachingProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel$LocalBeansCachingProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPointers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findPointers";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findFirstPointer";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

