/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0014\u0010\u001e\u001a\u00020\u00172\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001dJ\b\u0010%\u001a\u00020\u0004H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR6\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010 \u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lcom/intellij/javascript/debugger/RemoteDebuggingFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "parent", "<init>", "(Lcom/google/common/collect/BiMap;Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "getParent$intellij_javascript_debugger_backend", "()Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "value", "getMappings$intellij_javascript_debugger_backend", "()Lcom/google/common/collect/BiMap;", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findFile", "guessFile", "searchesByName", "", "createPredefinedMappings", "isDebuggable", "file", "canSetRemoteUrl", "getRemoteUrls", "", "updateRemoteUrlMapping", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "allowSourceMapHeavyProcessing", "getAllowSourceMapHeavyProcessing", "()Z", "setAllowSourceMapHeavyProcessing", "(Z)V", "toString", "intellij.javascript.debugger.backend"})
public final class RemoteDebuggingFileFinder
implements DebuggableFileFinder {
    @Nullable
    private final DebuggableFileFinder parent;
    @NotNull
    private BiMap<String, VirtualFile> mappings;
    private boolean allowSourceMapHeavyProcessing;

    public RemoteDebuggingFileFinder(@NotNull BiMap<String, VirtualFile> mappings, @Nullable DebuggableFileFinder parent) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.parent = parent;
        this.mappings = mappings;
        this.allowSourceMapHeavyProcessing = DebuggableFileFinder.super.getAllowSourceMapHeavyProcessing();
    }

    public /* synthetic */ RemoteDebuggingFileFinder(BiMap biMap, DebuggableFileFinder debuggableFileFinder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"of(...)");
            biMap = (BiMap)immutableBiMap;
        }
        if ((n & 2) != 0) {
            debuggableFileFinder = null;
        }
        this((BiMap<String, VirtualFile>)biMap, debuggableFileFinder);
    }

    @Nullable
    public final DebuggableFileFinder getParent$intellij_javascript_debugger_backend() {
        return this.parent;
    }

    @NotNull
    public final BiMap<String, VirtualFile> getMappings$intellij_javascript_debugger_backend() {
        return this.mappings;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = RemoteDebuggingFileFinderKt.access$findByMappings(url, this.mappings);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            return (Navigatable)JsFileUtil.createNavigatable(project, it);
        }
        DebuggableFileFinder debuggableFileFinder = this.parent;
        return debuggableFileFinder != null ? debuggableFileFinder.findNavigatable(url, project) : null;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RemoteDebuggingFileFinderKt.access$findByMappings(url, this.mappings);
    }

    @Override
    @Nullable
    public VirtualFile guessFile(@NotNull Url url, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DebuggableFileFinder debuggableFileFinder = this.parent;
        if (debuggableFileFinder != null && (debuggableFileFinder = debuggableFileFinder.findFile(url, project)) != null) {
            DebuggableFileFinder it = debuggableFileFinder;
            boolean bl = false;
            return it;
        }
        BiMap<String, VirtualFile> predefinedMappings = (BiMap<String, VirtualFile>)project.getUserData(RemoteDebuggingFileFinderKt.access$getPREDEFINED_MAPPINGS_KEY$p());
        if (predefinedMappings == null) {
            predefinedMappings = this.createPredefinedMappings(project);
            project.putUserData(RemoteDebuggingFileFinderKt.access$getPREDEFINED_MAPPINGS_KEY$p(), predefinedMappings);
        }
        if ((object = RemoteDebuggingFileFinderKt.access$findByMappings(url, (BiMap)predefinedMappings)) == null) {
            DebuggableFileFinder debuggableFileFinder2 = this.parent;
            object = debuggableFileFinder2 != null ? debuggableFileFinder2.guessFile(url, project) : null;
        }
        return object;
    }

    @Override
    public boolean searchesByName() {
        return true;
    }

    private final BiMap<String, VirtualFile> createPredefinedMappings(Project project) {
        BiMap biMap;
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of((Object)"webpack:///.", (Object)projectDir);
            Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"of(...)");
            biMap = (BiMap)immutableBiMap;
        } else {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"of(...)");
            biMap = (BiMap)immutableBiMap;
        }
        return biMap;
    }

    public final boolean isDebuggable(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file instanceof HttpVirtualFile) {
            return true;
        }
        if (!this.mappings.isEmpty()) {
            for (VirtualFile current = file; current != null; current = current.getParent()) {
                if (!this.mappings.containsValue((Object)current)) continue;
                return true;
            }
        }
        if (this.parent instanceof DebuggableFileFinderImpl && ((DebuggableFileFinderImpl)this.parent).isDebuggable(file, project)) {
            return true;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return RemoteDebuggingFileFinderKt.access$findByName(string, project, null) != null;
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof HttpVirtualFile) && !this.mappings.isEmpty()) {
            BiMap biMap = this.mappings.inverse();
            Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"inverse(...)");
            BiMap map = biMap;
            for (VirtualFile current = file; current != null; current = current.getParent()) {
                String url = (String)map.get((Object)current);
                if (url == null) continue;
                if (Intrinsics.areEqual((Object)current, (Object)file)) {
                    return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)url));
                }
                return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)(url + "/" + VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)current, (char)'/'))));
            }
        }
        if ((object = this.parent) == null || (object = object.getRemoteUrls(file)) == null) {
            object = CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file));
        }
        return object;
    }

    public final boolean updateRemoteUrlMapping(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        BiMap<String, VirtualFile> newMap = RemoteDebuggingFileFinderKt.createUrlToLocalMap(mappings);
        if (!Intrinsics.areEqual(newMap, this.mappings)) {
            this.mappings = newMap;
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllowSourceMapHeavyProcessing() {
        return this.allowSourceMapHeavyProcessing;
    }

    public void setAllowSourceMapHeavyProcessing(boolean bl) {
        this.allowSourceMapHeavyProcessing = bl;
    }

    @NotNull
    public String toString() {
        String string = Joiner.on((String)"\n ").withKeyValueSeparator("->").join((Map)this.mappings);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    public RemoteDebuggingFileFinder() {
        this(null, null, 3, null);
    }
}

