/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cron;

import com.cronutils.model.definition.CronDefinition;
import com.intellij.cron.CronDefinitionExpressionProvider;
import com.intellij.cron.CronExpLanguage;
import com.intellij.cron.CronUtilsKt;
import com.intellij.cron.DefaultCronExpressionProviderKt;
import com.intellij.cron.InvalidCronExpression;
import com.intellij.cron.psi.CronExpFile;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/cron/DefaultCronExpressionProvider;", "Lcom/intellij/cron/CronDefinitionExpressionProvider;", "<init>", "()V", "languages", "", "Lcom/intellij/lang/Language;", "getLanguages", "()Ljava/util/Collection;", "supportId", "", "getSupportId", "()Ljava/lang/String;", "isSuitableElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getCronDefinition", "Lcom/cronutils/model/definition/CronDefinition;", "cronExpr", "cronDefinition", "cronExpression", "getCronExpression", "getCronExplanation", "cronCompletionExamples", "", "intellij.cron"})
public final class DefaultCronExpressionProvider
implements CronDefinitionExpressionProvider {
    @NotNull
    private final Collection<Language> languages = CollectionsKt.listOf((Object)((Object)CronExpLanguage.INSTANCE));
    @NotNull
    private final String supportId;

    public DefaultCronExpressionProvider() {
        String string = CronExpLanguage.INSTANCE.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        this.supportId = string;
    }

    @Override
    @NotNull
    public Collection<Language> getLanguages() {
        return this.languages;
    }

    @Override
    @NotNull
    public String getSupportId() {
        return this.supportId;
    }

    @Override
    public boolean isSuitableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getContainingFile() instanceof CronExpFile;
    }

    @Override
    @NotNull
    public CronDefinition getCronDefinition(@NotNull String cronExpr, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        return this.cronDefinition(cronExpr);
    }

    private final CronDefinition cronDefinition(String cronExpression) {
        int cronElementsCount;
        String[] stringArray;
        Object object = cronExpression;
        int n = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) != null ? object.size() : (cronElementsCount = 6);
        if (cronElementsCount > 5) {
            CronDefinition cronDefinition = DefaultCronExpressionProviderKt.access$getSPRING_CRON_DEFINITION$p();
            Intrinsics.checkNotNullExpressionValue((Object)cronDefinition, (String)"access$getSPRING_CRON_DEFINITION$p(...)");
            return cronDefinition;
        }
        CronDefinition cronDefinition = DefaultCronExpressionProviderKt.access$getUNIX_CRON_DEFINITION$p();
        Intrinsics.checkNotNullExpressionValue((Object)cronDefinition, (String)"access$getUNIX_CRON_DEFINITION$p(...)");
        return cronDefinition;
    }

    @Override
    @Nullable
    public String getCronExpression(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CronExpFile cronExpFile = CronUtilsKt.getCronInjection(element);
        return cronExpFile != null ? cronExpFile.getText() : null;
    }

    @Override
    @Nullable
    public String getCronExplanation(@NotNull String cronExpr, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        try {
            return CronDefinitionExpressionProvider.super.getCronExplanation(cronExpr, element);
        }
        catch (InvalidCronExpression e) {
            return null;
        }
    }

    @Override
    @NotNull
    public List<String> cronCompletionExamples(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return DefaultCronExpressionProviderKt.getCRON_EXAMPLES();
    }
}

