/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSNamepath;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNamepathImpl
implements JSNamepath {
    private static final JSNamepathImpl EMPTY = new JSNamepathImpl("", null);
    @NotNull
    private final String myName;
    @Nullable
    private final JSNamepathImpl myParent;
    private final char myContextChar;

    public JSNamepathImpl(@NotNull String name, @Nullable JSNamepathImpl parent) {
        if (name == null) {
            JSNamepathImpl.$$$reportNull$$$0(0);
        }
        this(name, parent, '\u0000');
    }

    public JSNamepathImpl(@NotNull String name, @Nullable JSNamepathImpl parent, char contextChar) {
        if (name == null) {
            JSNamepathImpl.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myContextChar = contextChar;
        this.myParent = parent;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSNamepathImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        StringBuilder builder = new StringBuilder();
        this.appendQualifiedName(builder);
        String string = builder.toString();
        if (string == null) {
            JSNamepathImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void appendQualifiedName(@NotNull StringBuilder builder) {
        if (builder == null) {
            JSNamepathImpl.$$$reportNull$$$0(4);
        }
        if (this.myParent != null) {
            this.myParent.appendQualifiedName(builder);
            builder.append('.');
        }
        builder.append(this.myName);
    }

    @Override
    @Nullable
    public JSNamepathImpl getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public List<String> toComponents() {
        List<String> list = JSQualifiedNameImpl.toComponents(this);
        if (list == null) {
            JSNamepathImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    public char getForcedContextChar() {
        return this.myContextChar == '\u0000' ? (char)'.' : (char)this.myContextChar;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.myParent != null) {
            builder.append(this.myParent.getQualifiedName());
            if (this.myParent.myContextChar == '\u0000') {
                builder.append('.');
            }
        }
        builder.append(this.myName);
        if (this.myContextChar != '\u0000') {
            builder.append(this.myContextChar);
        }
        return builder.toString();
    }

    @NotNull
    public static JSNamepathImpl fromNamepath(@NotNull String namepath) {
        if (namepath == null) {
            JSNamepathImpl.$$$reportNull$$$0(6);
        }
        int pos = 0;
        JSNamepathImpl result = null;
        while (pos < namepath.length()) {
            int separatorPos = JSDocumentationUtils.findNextNamepathSeparator(namepath, pos);
            if (separatorPos == -1) {
                separatorPos = namepath.length();
            }
            if (separatorPos > pos) {
                char contextChar = separatorPos < namepath.length() ? namepath.charAt(separatorPos) : (char)'\u0000';
                result = new JSNamepathImpl(namepath.substring(pos, separatorPos), result, contextChar);
            }
            pos = separatorPos + 1;
        }
        JSNamepathImpl jSNamepathImpl = result != null ? result : EMPTY;
        if (jSNamepathImpl == null) {
            JSNamepathImpl.$$$reportNull$$$0(7);
        }
        return jSNamepathImpl;
    }

    @NotNull
    public JSNamepathImpl withName(@NotNull String name) {
        if (name == null) {
            JSNamepathImpl.$$$reportNull$$$0(8);
        }
        return new JSNamepathImpl(name, this.myParent, this.myContextChar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSNamepathImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSNamepathImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toComponents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNamepath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

