/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.detection;

import com.intellij.code.provenance.ChangeKindDetectorEP;
import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.events.detection.ActionsKt;
import com.intellij.code.provenance.core.events.listeners.ProvenanceListenersKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeActionUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0002J\u0017\u0010\u001b\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/code/provenance/core/events/detection/DocumentChangeKindDetector;", "", "<init>", "()V", "UNDO_REDO_COMMAND_PREFIX_PATTERN", "Lkotlin/text/Regex;", "INTENTION_COMMAND_PREFIX_PATTERN", "commandKindMap", "", "", "Lcom/intellij/code/provenance/DocumentChangesKind;", "detect", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "detectKindByFile", "detectKindByRefactoringContext", "detectKindByContent", "detectKindByEP", "detectExternalChangeKind", "detectKindByCurrentCommand", "detectKindByCurrentCommandGroup", "detectKindByEditingContext", "Lorg/jetbrains/annotations/Nullable;", "holder", "Lcom/intellij/openapi/util/UserDataHolder;", "detectKindByCurrentCommandPackageName", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nDocumentChangeKindDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentChangeKindDetector.kt\ncom/intellij/code/provenance/core/events/detection/DocumentChangeKindDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1869#2,2:102\n1869#2,2:104\n1869#2,2:106\n1869#2,2:108\n1869#2,2:110\n1869#2,2:112\n1869#2,2:114\n1869#2,2:116\n1869#2,2:118\n1869#2,2:120\n*S KotlinDebug\n*F\n+ 1 DocumentChangeKindDetector.kt\ncom/intellij/code/provenance/core/events/detection/DocumentChangeKindDetector\n*L\n22#1:102,2\n23#1:104,2\n24#1:106,2\n25#1:108,2\n26#1:110,2\n27#1:112,2\n28#1:114,2\n30#1:116,2\n31#1:118,2\n32#1:120,2\n*E\n"})
public final class DocumentChangeKindDetector {
    @NotNull
    public static final DocumentChangeKindDetector INSTANCE;
    @NotNull
    private static final Regex UNDO_REDO_COMMAND_PREFIX_PATTERN;
    @NotNull
    private static final Regex INTENTION_COMMAND_PREFIX_PATTERN;
    @NotNull
    private static final Map<String, DocumentChangesKind> commandKindMap;

    private DocumentChangeKindDetector() {
    }

    @NotNull
    public final DocumentChangesKind detect(@NotNull Project project, @NotNull Editor editor, @Nullable VirtualFile file, @NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DocumentChangesKind documentChangesKind = this.detectKindByRefactoringContext(editor);
        if (documentChangesKind == null && (documentChangesKind = this.detectKindByCurrentCommandGroup()) == null && (documentChangesKind = this.detectKindByCurrentCommand()) == null && (documentChangesKind = this.detectKindByEditingContext((UserDataHolder)project)) == null && (documentChangesKind = this.detectKindByEditingContext((UserDataHolder)editor)) == null && (documentChangesKind = this.detectKindByFile(file)) == null && (documentChangesKind = this.detectKindByCurrentCommandPackageName()) == null && (documentChangesKind = this.detectExternalChangeKind()) == null && (documentChangesKind = this.detectKindByContent(event)) == null && (documentChangesKind = this.detectKindByEP(event)) == null) {
            documentChangesKind = DocumentChangesKind.UNKNOWN;
        }
        return documentChangesKind;
    }

    private final DocumentChangesKind detectKindByFile(VirtualFile file) {
        return file != null && ChangesUtil.isInternalOperation((VirtualFile)file) ? DocumentChangesKind.VCS : null;
    }

    private final DocumentChangesKind detectKindByRefactoringContext(Editor editor) {
        return editor.getUserData(InplaceRefactoring.INPLACE_RENAMER) != null || editor.getUserData(StartMarkAction.START_MARK_ACTION_KEY) != null ? DocumentChangesKind.REFACTORING : null;
    }

    private final DocumentChangesKind detectKindByContent(DocumentEvent event) {
        CharSequence charSequence = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
        CharSequence charSequence2 = StringsKt.trim((CharSequence)charSequence);
        CharSequence charSequence3 = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getNewFragment(...)");
        return Intrinsics.areEqual((Object)charSequence2, (Object)StringsKt.trimEnd((CharSequence)charSequence3)) ? DocumentChangesKind.FORMATTER : null;
    }

    private final DocumentChangesKind detectKindByEP(DocumentEvent event) {
        return ChangeKindDetectorEP.Companion.detectKind(event);
    }

    private final DocumentChangesKind detectExternalChangeKind() {
        if (ExternalChangeActionUtil.isExternalChangeInProgress() || ExternalChangeActionUtil.isExternalDocumentChangeInProgress()) {
            return DocumentChangesKind.EXTERNAL;
        }
        return null;
    }

    private final DocumentChangesKind detectKindByCurrentCommand() {
        DocumentChangesKind documentChangesKind;
        String string = CommandProcessor.getInstance().getCurrentCommandName();
        if (string != null) {
            String commandName = string;
            boolean bl = false;
            documentChangesKind = UNDO_REDO_COMMAND_PREFIX_PATTERN.matches((CharSequence)commandName) ? DocumentChangesKind.UNDO : (INTENTION_COMMAND_PREFIX_PATTERN.matches((CharSequence)commandName) ? DocumentChangesKind.REFACTORING : commandKindMap.get(commandName));
        } else {
            documentChangesKind = null;
        }
        return documentChangesKind;
    }

    private final DocumentChangesKind detectKindByCurrentCommandGroup() {
        return Intrinsics.areEqual((Object)CommandProcessor.getInstance().getCurrentCommandGroupId(), (Object)"AI_APPLY_SNIPPET_COMMAND_GROUP_ID") ? DocumentChangesKind.AI_APPLY_SNIPPET : null;
    }

    private final DocumentChangesKind detectKindByEditingContext(UserDataHolder holder) {
        return (DocumentChangesKind)holder.getUserData(ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY());
    }

    private final DocumentChangesKind detectKindByCurrentCommandPackageName() {
        String string;
        Object object = CommandProcessor.getInstance().getCurrentCommand();
        String string2 = object != null && (object = object.getClass()) != null ? ((Class)object).getPackageName() : (string = null);
        return Intrinsics.areEqual((Object)string, (Object)"com.intellij.codeInsight.completion") ? DocumentChangesKind.COMPLETION : (Intrinsics.areEqual((Object)string, (Object)"com.intellij.openapi.editor.actionSystem") ? DocumentChangesKind.TYPING : null);
    }

    static {
        String it;
        Map map;
        INSTANCE = new DocumentChangeKindDetector();
        UNDO_REDO_COMMAND_PREFIX_PATTERN = new Regex("^_?(Undo|Redo).*");
        INTENTION_COMMAND_PREFIX_PATTERN = new Regex("^Intention.*");
        Map $this$commandKindMap_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)ActionsKt.getTypingActions(), (Object)"Typing");
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl2 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.TYPING);
        }
        $this$forEach$iv = ActionsKt.getRefactoringActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl3 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.REFACTORING);
        }
        $this$forEach$iv = ActionsKt.getTemplateActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl4 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.TEMPLATE);
        }
        $this$forEach$iv = ActionsKt.getFormattingActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl5 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.FORMATTER);
        }
        $this$forEach$iv = ActionsKt.getCompletionActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl6 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.COMPLETION);
        }
        $this$forEach$iv = ActionsKt.getPasteActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl7 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.PASTE);
        }
        $this$forEach$iv = ActionsKt.getAiAssistantInlineCompletionActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl8 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.AI_INLINE_COMPLETION);
        }
        $this$forEach$iv = ActionsKt.getJunieCodeGenerationActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl9 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.JUNIE_CODE_GENERATION);
        }
        $this$forEach$iv = ActionsKt.getVcsActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl10 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.VCS);
        }
        $this$forEach$iv = ActionsKt.getNewFileActions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl11 = false;
            $this$commandKindMap_u24lambda_u240.put(it, DocumentChangesKind.NEW_FILE);
        }
        commandKindMap = MapsKt.build((Map)map);
    }
}

