/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners;

import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.ProvenanceEvent;
import com.intellij.code.provenance.core.events.ProvenanceEvents;
import com.intellij.ide.IdleTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceIdleListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "idleToken", "Lcom/intellij/openapi/application/AccessToken;", "recordIdleEvent", "", "dispose", "Companion", "intellij.code.provenance.core"})
public final class ProvenanceIdleListener
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AccessToken idleToken;
    private static final long IDLE_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);

    public ProvenanceIdleListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.idleToken = IdleTracker.Companion.getInstance().addIdleListener((int)IDLE_TIMEOUT_MS, () -> ProvenanceIdleListener.idleToken$lambda$0(this));
    }

    private final void recordIdleEvent() {
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        ProvenanceEvents.Companion.getInstance(this.project).add(new ProvenanceEvent.Atomic(new ProvenanceEntry.Idle(0L, 1, null)));
    }

    public void dispose() {
        this.idleToken.finish();
    }

    private static final void idleToken$lambda$0(ProvenanceIdleListener this$0) {
        this$0.recordIdleEvent();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceIdleListener$Companion;", "", "<init>", "()V", "IDLE_TIMEOUT_MS", "", "intellij.code.provenance.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

