/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.rewrite;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.openRewrite.OpenRewriteRecipeLibraryContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.rewrite.SpringBootRecipeLibraryContributorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/boot/rewrite/SpringBootRecipeLibraryContributor;", "Lcom/intellij/openRewrite/OpenRewriteRecipeLibraryContributor;", "<init>", "()V", "getRecipeLibraries", "", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "project", "Lcom/intellij/openapi/project/Project;", "hasLibrary", "", "module", "Lcom/intellij/openapi/module/Module;", "isUpdateAvailable", "updateMatches", "recipeName", "", "intellij.spring.boot.rewrite"})
public final class SpringBootRecipeLibraryContributor
implements OpenRewriteRecipeLibraryContributor {
    @NotNull
    public List<UnifiedCoordinates> getRecipeLibraries(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return CollectionsKt.listOf((Object)new UnifiedCoordinates("org.openrewrite.recipe", "rewrite-spring", "5.4.0"));
        }
        return CollectionsKt.emptyList();
    }

    public boolean hasLibrary(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringBootLibraryUtil.hasSpringBootLibrary((Module)module);
    }

    public boolean isUpdateAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringBootLibraryUtil.isBelowVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_3_0_0);
    }

    public boolean updateMatches(@NotNull String recipeName) {
        Intrinsics.checkNotNullParameter((Object)recipeName, (String)"recipeName");
        return SpringBootRecipeLibraryContributorKt.access$getRECIPE_REGEX$p().matches((CharSequence)recipeName);
    }
}

