/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.extension;

import com.intellij.java.codeserver.highlighting.JavaErrorFilter;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LombokHighlightErrorFilter
implements JavaErrorFilter {
    private static final Pattern UNDERSCORES = Pattern.compile("_+");
    private static final Collection<String> ONXABLE_ANNOTATIONS = Arrays.asList("lombok.Getter", "lombok.Setter", "lombok.With", "lombok.experimental.Wither", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.EqualsAndHashCode");
    private static final Collection<String> ONX_PARAMETERS = Arrays.asList("onConstructor", "onMethod", "onParam");

    public boolean shouldSuppressError(@NotNull PsiFile file, @NotNull JavaCompilationError<?, ?> error) {
        Project project;
        if (file == null) {
            LombokHighlightErrorFilter.$$$reportNull$$$0(0);
        }
        if (error == null) {
            LombokHighlightErrorFilter.$$$reportNull$$$0(1);
        }
        return LombokLibraryUtil.hasLombokLibrary(project = file.getProject()) && LombokHighlightErrorFilter.isOnXParameterAnnotation(error);
    }

    private static boolean isOnXParameterAnnotation(@NotNull JavaCompilationError<?, ?> error) {
        PsiAnnotation annotation;
        if (error == null) {
            LombokHighlightErrorFilter.$$$reportNull$$$0(2);
        }
        if (!LombokHighlightErrorFilter.isMyError(error)) {
            return false;
        }
        PsiElement highlightedElement = error.psi();
        PsiNameValuePair nameValuePair = LombokHighlightErrorFilter.findContainingNameValuePair(highlightedElement);
        if (nameValuePair == null || !(nameValuePair.getContext() instanceof PsiAnnotationParameterList)) {
            return false;
        }
        String parameterName = nameValuePair.getName();
        if (null != parameterName && parameterName.contains("_")) {
            parameterName = parameterName.substring(0, parameterName.indexOf(95));
        }
        if (!ONX_PARAMETERS.contains(parameterName)) {
            return false;
        }
        PsiElement containingAnnotation = nameValuePair.getContext().getContext();
        return containingAnnotation instanceof PsiAnnotation && ONXABLE_ANNOTATIONS.contains((annotation = (PsiAnnotation)containingAnnotation).getQualifiedName());
    }

    private static boolean isMyError(@NotNull JavaCompilationError<?, ?> error) {
        if (error == null) {
            LombokHighlightErrorFilter.$$$reportNull$$$0(3);
        }
        return error.kind() == JavaErrorKinds.ANNOTATION_TYPE_EXPECTED || error.forKind(new JavaErrorKind[]{JavaErrorKinds.REFERENCE_UNRESOLVED}).filter(e -> LombokHighlightErrorFilter.isUnderscore((PsiJavaCodeReferenceElement)e.psi())).isPresent() || error.forKind(new JavaErrorKind[]{JavaErrorKinds.ANNOTATION_ATTRIBUTE_INCOMPATIBLE_TYPE}).filter(e -> {
            PsiAnnotation anno;
            PsiElement patt0$temp;
            return LombokHighlightErrorFilter.isAnyAnnotation(((JavaErrorKinds.AnnotationValueErrorContext)e.context()).expectedType()) && (patt0$temp = e.psi()) instanceof PsiAnnotation && LombokHighlightErrorFilter.isUnderscore((anno = (PsiAnnotation)patt0$temp).getNameReferenceElement());
        }).isPresent();
    }

    private static boolean isUnderscore(@Nullable PsiJavaCodeReferenceElement e) {
        return e != null && e.getReferenceName() != null && UNDERSCORES.matcher(e.getReferenceName()).matches();
    }

    private static boolean isAnyAnnotation(@NotNull PsiType type) {
        PsiClassType classType;
        PsiArrayType arrayType;
        PsiType psiType;
        if (type == null) {
            LombokHighlightErrorFilter.$$$reportNull$$$0(4);
        }
        return type instanceof PsiArrayType && (psiType = (arrayType = (PsiArrayType)type).getComponentType()) instanceof PsiClassType && (classType = (PsiClassType)psiType).getClassName().equals("AnyAnnotation") && classType.getCanonicalText().startsWith("lombok.");
    }

    @Nullable
    private static PsiNameValuePair findContainingNameValuePair(PsiElement highlightedElement) {
        PsiElement nameValuePair;
        for (nameValuePair = highlightedElement; nameValuePair != null && !(nameValuePair instanceof PsiNameValuePair); nameValuePair = nameValuePair.getContext()) {
        }
        return (PsiNameValuePair)nameValuePair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSuppressError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isOnXParameterAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyError";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnyAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

