/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.folding;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class XmlPropertyPlaceholderFoldingBuilder
extends FoldingBuilderEx {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (!(root instanceof XmlFile) || quick || !this.isEnabled()) {
            if (FoldingDescriptor.EMPTY_ARRAY == null) {
                XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY_ARRAY;
        }
        DomFileElement fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)((XmlFile)root));
        if (fileElement == null) {
            if (FoldingDescriptor.EMPTY_ARRAY == null) {
                XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(3);
            }
            return FoldingDescriptor.EMPTY_ARRAY;
        }
        final PlaceholderUtils placeholderUtils = PlaceholderUtils.getInstance();
        SmartList regions = new SmartList();
        fileElement.accept(new DomElementVisitor(){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
            }

            public void visitDomElement(DomElement element) {
                if (!DomUtil.hasXml((DomElement)element)) {
                    return;
                }
                if (element instanceof GenericDomValue) {
                    if (placeholderUtils.isRawTextPlaceholder((GenericDomValue)element)) {
                        XmlElement xmlElement = element.getXmlElement();
                        if (xmlElement instanceof XmlAttribute) {
                            XmlAttributeValue value = ((XmlAttribute)xmlElement).getValueElement();
                            if (value != null) {
                                this.val$regions.addAll(XmlPropertyPlaceholderFoldingBuilder.this.createReferenceFoldingDescriptors((PsiElement)value));
                            }
                        } else if (xmlElement instanceof XmlTag) {
                            this.val$regions.addAll(XmlPropertyPlaceholderFoldingBuilder.this.createReferenceFoldingDescriptors((PsiElement)xmlElement));
                        }
                    }
                } else {
                    element.acceptChildren((DomElementVisitor)this);
                }
            }
        });
        FoldingDescriptor[] foldingDescriptorArray = regions.isEmpty() ? FoldingDescriptor.EMPTY_ARRAY : regions.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(4);
        }
        return foldingDescriptorArray;
    }

    protected boolean isEnabled() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    protected Collection<FoldingDescriptor> createReferenceFoldingDescriptors(@NotNull PsiElement element) {
        if (element == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(5);
        }
        return ContainerUtil.mapNotNull(XmlPropertyPlaceholderFoldingBuilder.getInnerReferences(element), reference -> {
            if (!(reference instanceof PlaceholderPropertyReference)) {
                return null;
            }
            PlaceholderPropertyReference placeholderPropertyReference = (PlaceholderPropertyReference)((Object)reference);
            String value = placeholderPropertyReference.getFoldingValue();
            if (value == null) {
                return null;
            }
            FoldingDescriptor descriptor = new FoldingDescriptor(element.getNode(), this.getRangeForFolding(element, placeholderPropertyReference), null, XmlPropertyPlaceholderFoldingBuilder.getFoldingDependencies(element.getProject()));
            descriptor.setPlaceholderText(XmlPropertyPlaceholderFoldingBuilder.getPlaceholderText(value, element));
            return descriptor;
        });
    }

    @NotNull
    private static Iterable<PsiReference> getInnerReferences(PsiElement element) {
        Stream<PsiReference> references = Arrays.stream(XmlPropertyPlaceholderFoldingBuilder.getReferences(element));
        if (element instanceof PsiLanguageInjectionHost) {
            Stream innerReferences = Arrays.stream(element.getChildren()).flatMap(e -> Arrays.stream(e.getReferences()));
            references = Stream.concat(references, innerReferences);
        }
        Iterable<PsiReference> iterable = references::iterator;
        if (iterable == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(6);
        }
        return iterable;
    }

    private static PsiReference @NotNull [] getReferences(PsiElement element) {
        if (element instanceof HintedReferenceHost) {
            HintedReferenceHost hintedReferenceHost = (HintedReferenceHost)element;
            PsiReference[] psiReferenceArray = hintedReferenceHost.getReferences(PsiReferenceService.Hints.HIGHLIGHTED_REFERENCES);
            if (psiReferenceArray == null) {
                XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(7);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = element.getReferences();
        if (psiReferenceArray == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @NotNull
    protected TextRange getRangeForFolding(PsiElement element, PlaceholderPropertyReference reference) {
        TextRange textRange = reference.getFullTextRange().shiftRight(element.getTextRange().getStartOffset());
        if (textRange == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @NotNull
    private static String getPlaceholderText(@NotNull String value, @NotNull PsiElement element) {
        if (value == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (element == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(12);
        }
        if (value.trim().isEmpty()) {
            return "<empty>";
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            int maxLength = XmlPropertyPlaceholderFoldingBuilder.getPlaceholderTextMaxLength(psiFile);
            value = StringUtil.shortenTextWithEllipsis((String)value, (int)maxLength, (int)0);
        }
        String string = value;
        if (string == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(14);
        }
        return true;
    }

    private static int getPlaceholderTextMaxLength(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(15);
        }
        return Math.max(CodeStyle.getSettings((PsiFile)psiFile).getRightMargin(psiFile.getLanguage()) / 2, "...".length());
    }

    private static Set<Object> getFoldingDependencies(@NotNull Project project) {
        if (project == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(16);
        }
        Set<String> languages = Set.of(PropertiesLanguage.INSTANCE.getID(), "yaml");
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.getInstance((Project)project);
        return Set.of(psiModificationTracker.forLanguages(language -> languages.contains(language.getID())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/folding/XmlPropertyPlaceholderFoldingBuilder";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/folding/XmlPropertyPlaceholderFoldingBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeForFolding";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceFoldingDescriptors";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderTextMaxLength";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9, 13 -> new IllegalStateException(string);
        };
    }
}

