/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.profiles.ChangeActiveProfileDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

public class SpringChangeActiveProfilesAction
extends DumbAwareAction {
    public static final String ACTION_ID = "SpringChangeActiveProfiles";

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SpringChangeActiveProfilesAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (project = e.getProject()) != null && !DumbService.getInstance((Project)project).isDumb() && SpringLibraryUtil.hasSpringLibrary((Project)project);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SpringChangeActiveProfilesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ChangeActiveProfileDialog dialog;
        Project project;
        if (e == null) {
            SpringChangeActiveProfilesAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        SpringFileSet fileSet = null;
        boolean includeTests = false;
        if (module != null) {
            PsiFile psiFile;
            Object data = e.getData(PlatformCoreDataKeys.SELECTED_ITEM);
            if (data instanceof SpringFileSet) {
                fileSet = (SpringFileSet)data;
            }
            if ((psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null) {
                VirtualFile virtualFile;
                SpringModel model;
                if (fileSet == null && (model = SpringChangeActiveProfilesAction.getSpringModel(psiFile)) != null) {
                    fileSet = model.getFileSet();
                }
                VirtualFile virtualFile2 = virtualFile = psiFile.isValid() ? psiFile.getVirtualFile() : null;
                if (virtualFile != null) {
                    includeTests = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile);
                }
            }
        }
        if ((dialog = new ChangeActiveProfileDialog(project, module, fileSet, includeTests)).showAndGet()) {
            SpringProfileUtils.notifyProfilesChanged((Project)project);
        }
    }

    @Nullable
    static SpringModel getSpringModel(PsiFile psiFile) {
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            SpringManager springManager = SpringManager.getInstance((Project)psiFile.getProject());
            return springManager.getSpringModelByFile(psiFile);
        }
        UFile uFile = (UFile)UastContextKt.toUElement((PsiElement)psiFile, UFile.class);
        if (uFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return null;
        }
        if (!SpringChangeActiveProfilesAction.hasConfigurations(uFile)) {
            return null;
        }
        return SpringManager.getInstance((Project)psiFile.getProject()).getSpringModelByFile(psiFile);
    }

    private static boolean hasConfigurations(UFile uFile) {
        for (UClass uClass : uFile.getClasses()) {
            PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class);
            if (psiClass == null || !SpringChangeActiveProfilesAction.containsConfigurations(psiClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConfigurations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringChangeActiveProfilesAction.$$$reportNull$$$0(3);
        }
        if (SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) {
            return true;
        }
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (!innerClass.hasModifierProperty("static") || psiClass.hasModifierProperty("private") || !SpringChangeActiveProfilesAction.containsConfigurations(innerClass)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringChangeActiveProfilesAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringChangeActiveProfilesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsConfigurations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

