/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.thymeleaf.references.paths.ThymeleafTemplateResolverMethodsSearchHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ViewResolverUtils {
    @NotNull
    public static Set<ViewResolver> getConfiguredViewResolvers(@NotNull String resolverClass, @NotNull Module module, @NotNull SearchScope scope) {
        if (resolverClass == null) {
            ViewResolverUtils.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ViewResolverUtils.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            ViewResolverUtils.$$$reportNull$$$0(2);
        }
        HashSet<ViewResolver> resolvers = new HashSet<ViewResolver>();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(resolverClass, SpringGlobalSearchScopes.runtime((Module)module));
        for (Pair pair : ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixExpressions((PsiClass)aClass, (String)"setPrefix", (SearchScope)scope)) {
            String prefix = (String)pair.second;
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)pair.getFirst()), PsiMethod.class);
            if (psiMethod == null) continue;
            Set suffixes = ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes((PsiClass)aClass, (String)"setSuffix", (SearchScope)new LocalSearchScope((PsiElement)psiMethod));
            if (suffixes.isEmpty()) {
                ViewResolver viewResolver = SpringControllerUtils.createURLBasedViewResolver(module, prefix, "");
                resolvers.add(viewResolver);
                continue;
            }
            resolvers.addAll(ContainerUtil.map((Collection)suffixes, suffix -> SpringControllerUtils.createURLBasedViewResolver(module, prefix, suffix)));
        }
        HashSet<ViewResolver> hashSet = resolvers;
        if (hashSet == null) {
            ViewResolverUtils.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/ViewResolverUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/ViewResolverUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredViewResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredViewResolvers";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

