/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.library;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBootLibraryUtil {
    public static final PatternCondition<PsiElement> SB_1_3_OR_HIGHER = SpringBootLibraryUtil.createVersionPatternCondition(SpringBootVersion.VERSION_1_3_0);
    public static final PatternCondition<PsiElement> SB_1_5_OR_HIGHER = SpringBootLibraryUtil.createVersionPatternCondition(SpringBootVersion.VERSION_1_5_0);
    public static final String SPRING_BOOT_MAVEN = "org.springframework.boot:spring-boot";
    private static final String SPRING_BOOT_DEV_TOOLS_MAVEN = "org.springframework.boot:spring-boot-devtools";
    private static final String SPRING_BOOT_ACTUATOR_MAVEN = "org.springframework.boot:spring-boot-actuator";
    private static final String SPRING_WEB_MVC_MAVEN = "org.springframework:spring-webmvc";
    private static final String SPRING_WEB_FLUX_MAVEN = "org.springframework:spring-webflux";

    public static PatternCondition<PsiElement> createVersionPatternCondition(final @NotNull SpringBootVersion minimumVersion) {
        if (minimumVersion == null) {
            SpringBootLibraryUtil.$$$reportNull$$$0(0);
        }
        return new PatternCondition<PsiElement>("SB" + minimumVersion.name() + "OrHigher"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                return SpringBootLibraryUtil.isAtLeastVersion(module, minimumVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/library/SpringBootLibraryUtil$1", "accepts"));
            }
        };
    }

    public static boolean hasSpringBootLibrary(@Nullable Project project) {
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_BOOT_MAVEN);
    }

    public static boolean hasSpringBootLibrary(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_BOOT_MAVEN);
    }

    public static boolean isBelowVersion(@Nullable Module module, SpringBootVersion version) {
        return !SpringBootLibraryUtil.isAtLeastVersion(module, version);
    }

    public static boolean isAtLeastVersion(@Nullable Module module, SpringBootVersion version) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module.getProject())) {
            return false;
        }
        SpringBootVersion cached = SpringBootLibraryUtil.getSpringBootVersion(module);
        return cached != null && cached.isAtLeast(version);
    }

    @Nullable
    public static String getVersionFromJar(@NotNull Module module) {
        if (module == null) {
            SpringBootLibraryUtil.$$$reportNull$$$0(1);
        }
        if (module.isDisposed() || module.getProject().isDefault()) {
            return null;
        }
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            String libraryVersion = JavaLibraryUtil.getLibraryVersion((Module)module, (String)SPRING_BOOT_MAVEN);
            return CachedValueProvider.Result.create((Object)libraryVersion, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    public static boolean hasDevtools(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_BOOT_DEV_TOOLS_MAVEN);
    }

    public static boolean hasActuators(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_BOOT_ACTUATOR_MAVEN);
    }

    public static boolean hasRequestMappings(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_WEB_MVC_MAVEN) || JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_WEB_FLUX_MAVEN);
    }

    @Nullable
    public static SpringBootVersion getSpringBootVersion(@NotNull Module module) {
        if (module == null) {
            SpringBootLibraryUtil.$$$reportNull$$$0(2);
        }
        if (module.isDisposed() || module.getProject().isDefault()) {
            return null;
        }
        return (SpringBootVersion)((Object)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            String libraryVersion = JavaLibraryUtil.getLibraryVersion((Module)module, (String)SPRING_BOOT_MAVEN);
            SpringBootVersion detected = libraryVersion == null ? null : (SpringBootVersion)((Object)((Object)ContainerUtil.find((Object[])((SpringBootVersion[])ArrayUtil.reverseArray((Object[])SpringBootVersion.values())), version -> VersionComparatorUtil.compare((String)version.myVersion, (String)libraryVersion) <= 0)));
            return CachedValueProvider.Result.create((Object)((Object)detected), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/library/SpringBootLibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVersionPatternCondition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersionFromJar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpringBootVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum SpringBootVersion {
        ANY("1.0.0"),
        VERSION_1_2_0("1.2.0"),
        VERSION_1_3_0("1.3.0"),
        VERSION_1_4_0("1.4.0"),
        VERSION_1_5_0("1.5.0"),
        VERSION_2_0_0("2.0.0"),
        VERSION_2_1_0("2.1.0"),
        VERSION_2_2_0("2.2.0"),
        VERSION_2_4_0("2.4.0"),
        VERSION_2_5_0("2.5.0"),
        VERSION_2_7_0("2.7.0"),
        VERSION_3_0_0("3.0.0"),
        VERSION_3_4_0("3.4.0");

        private final String myVersion;

        private SpringBootVersion(String version) {
            this.myVersion = version;
        }

        public boolean isAtLeast(SpringBootVersion reference) {
            if (reference == ANY) {
                return true;
            }
            return this.compareTo(reference) >= 0;
        }
    }
}

