/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.commands.CommandsProcessingKt;
import org.jetbrains.kotlinx.jupyter.common.CommandsUtilKt;
import org.jetbrains.kotlinx.jupyter.config.NotebookMetadataKt;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.execution.ExecutionResult;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.messaging.AbstractMessageRequestProcessor;
import org.jetbrains.kotlinx.jupyter.messaging.Comm;
import org.jetbrains.kotlinx.jupyter.messaging.CommCloseMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.CommInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.CommMsgMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CommOpenMessage;
import org.jetbrains.kotlinx.jupyter.messaging.CompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectReply;
import org.jetbrains.kotlinx.jupyter.messaging.ConnectRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteInput;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionCounter;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryReply;
import org.jetbrains.kotlinx.jupyter.messaging.HistoryRequest;
import org.jetbrains.kotlinx.jupyter.messaging.IdeCompatibleMessageRequestProcessor;
import org.jetbrains.kotlinx.jupyter.messaging.InputReply;
import org.jetbrains.kotlinx.jupyter.messaging.InterruptRequest;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteReply;
import org.jetbrains.kotlinx.jupyter.messaging.IsCompleteRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponseKt;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoReply;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoReplyMetadata;
import org.jetbrains.kotlinx.jupyter.messaging.KernelInfoRequest;
import org.jetbrains.kotlinx.jupyter.messaging.ListErrorsRequest;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProvider;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.OkJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ShutdownRequest;
import org.jetbrains.kotlinx.jupyter.messaging.StdIOSubstitutionManager;
import org.jetbrains.kotlinx.jupyter.messaging.UpdateClientMetadataErrorReply;
import org.jetbrains.kotlinx.jupyter.messaging.UpdateClientMetadataRequest;
import org.jetbrains.kotlinx.jupyter.messaging.UpdateClientMetadataSuccessReply;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterServerSockets;
import org.jetbrains.kotlinx.jupyter.protocol.api.JsonExtensionsKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.repl.CompletionResult;
import org.jetbrains.kotlinx.jupyter.repl.EvalRequestData;
import org.jetbrains.kotlinx.jupyter.repl.ListErrorsResult;
import org.jetbrains.kotlinx.jupyter.repl.OutputConfig;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.repl.notebook.MutableCodeCell;
import org.jetbrains.kotlinx.jupyter.repl.result.EvalResultEx;
import org.jetbrains.kotlinx.jupyter.streams.CapturingOutputStream;
import org.jetbrains.kotlinx.jupyter.streams.DisabledStdinInputStream;
import org.jetbrains.kotlinx.jupyter.streams.StdinInputStream;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u00101\u001a\u00020,2\u0006\u0010-\u001a\u000202H\u0014J\u0010\u00103\u001a\u00020,2\u0006\u0010-\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020,2\u0006\u0010-\u001a\u000206H\u0014J\u0010\u00107\u001a\u00020,2\u0006\u0010-\u001a\u000208H\u0014J\u0010\u00109\u001a\u00020,2\u0006\u0010-\u001a\u00020:H\u0014J\u0010\u0010;\u001a\u00020,2\u0006\u0010-\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020,2\u0006\u0010-\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u00020,2\u0006\u0010-\u001a\u00020@H\u0014J\u0010\u0010A\u001a\u00020,2\u0006\u0010-\u001a\u00020BH\u0014J\u0010\u0010C\u001a\u00020,2\u0006\u0010-\u001a\u00020DH\u0014J\u0010\u0010E\u001a\u00020,2\u0006\u0010-\u001a\u00020FH\u0014J\u0010\u0010G\u001a\u00020,2\u0006\u0010-\u001a\u00020HH\u0014J\u0010\u0010I\u001a\u00020,2\u0006\u0010-\u001a\u00020JH\u0014J\u0010\u0010K\u001a\u00020,2\u0006\u0010-\u001a\u00020LH\u0014J\u0010\u0010M\u001a\u00020,2\u0006\u0010-\u001a\u00020NH\u0014J\u001e\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020U0TH\u0014J\"\u0010Z\u001a\u00020[2\b\u0010\\\u001a\u0004\u0018\u00010[2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0002J\f\u0010a\u001a\u00020[*\u00020bH\u0002J!\u0010c\u001a\u0002Hd\"\u0004\b\u0000\u0010d2\f\u0010e\u001a\b\u0012\u0004\u0012\u0002Hd0TH\u0002\u00a2\u0006\u0002\u0010fJ!\u0010g\u001a\u0002Hd\"\u0004\b\u0000\u0010d2\f\u0010e\u001a\b\u0012\u0004\u0012\u0002Hd0TH\u0002\u00a2\u0006\u0002\u0010fJ)\u0010h\u001a\u0002Hd\"\u0004\b\u0000\u0010d2\u0006\u0010i\u001a\u00020`2\f\u0010e\u001a\b\u0012\u0004\u0012\u0002Hd0TH\u0002\u00a2\u0006\u0002\u0010jJ)\u0010k\u001a\u0002Hd\"\u0004\b\u0000\u0010d2\u0006\u0010i\u001a\u00020`2\f\u0010e\u001a\b\u0012\u0004\u0012\u0002Hd0TH\u0014\u00a2\u0006\u0002\u0010jJ\u0010\u0010l\u001a\u00020R*\u00060Rj\u0002`mH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u0014\u0010V\u001a\u00020W8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010Y\u00a8\u0006n"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/IdeCompatibleMessageRequestProcessor;", "Lorg/jetbrains/kotlinx/jupyter/messaging/AbstractMessageRequestProcessor;", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "rawIncomingMessage", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "messageFactoryProvider", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;", "socketManager", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterServerSockets;", "commManager", "Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;", "executor", "Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "executionCounter", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "repl", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactoryProvider;Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterServerSockets;Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;)V", "getSocketManager", "()Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterServerSockets;", "getCommManager", "()Lorg/jetbrains/kotlinx/jupyter/messaging/comms/CommManagerInternal;", "getExecutor", "()Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "getExecutionCounter", "()Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCounter;", "getRepl", "()Lorg/jetbrains/kotlinx/jupyter/repl/ReplForJupyter;", "logger", "Lorg/slf4j/Logger;", "messageFactory", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactory;", "getMessageFactory", "()Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactory;", "stdinIn", "Ljava/io/InputStream;", "getStdinIn$annotations", "()V", "getStdinIn", "()Ljava/io/InputStream;", "processUnknownShellMessage", "", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageContent;", "processUnknownControlMessage", "processUnknownStdinMessage", "processIsCompleteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/IsCompleteRequest;", "processListErrorsRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ListErrorsRequest;", "processCompleteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/CompleteRequest;", "processCommMsg", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommMsgMessage;", "processCommClose", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommCloseMessage;", "processCommOpen", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommOpenMessage;", "processCommInfoRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/CommInfoRequest;", "processExecuteRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteRequest;", "processConnectRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ConnectRequest;", "processHistoryRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/HistoryRequest;", "processKernelInfoRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/KernelInfoRequest;", "processUpdateClientMetadata", "Lorg/jetbrains/kotlinx/jupyter/messaging/UpdateClientMetadataRequest;", "processShutdownRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/ShutdownRequest;", "processInterruptRequest", "Lorg/jetbrains/kotlinx/jupyter/messaging/InterruptRequest;", "processInputReply", "Lorg/jetbrains/kotlinx/jupyter/messaging/InputReply;", "runExecution", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;", "executionName", "", "execution", "Lkotlin/Function0;", "Lorg/jetbrains/kotlinx/jupyter/repl/result/EvalResultEx;", "replOutputConfig", "Lorg/jetbrains/kotlinx/jupyter/repl/OutputConfig;", "getReplOutputConfig", "()Lorg/jetbrains/kotlinx/jupyter/repl/OutputConfig;", "getCapturingStream", "Ljava/io/PrintStream;", "parentStream", "outType", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterOutType;", "captureOutput", "", "asPrintStream", "Ljava/io/OutputStream;", "withForkedOut", "T", "body", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withForkedErr", "withForkedIn", "allowStdIn", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "evalWithIO", "presentableForThreadName", "Lorg/jetbrains/kotlinx/jupyter/api/Code;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nIdeCompatibleMessageRequestProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeCompatibleMessageRequestProcessor.kt\norg/jetbrains/kotlinx/jupyter/messaging/IdeCompatibleMessageRequestProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,401:1\n1193#2,2:402\n1267#2,4:404\n324#3:408\n*S KotlinDebug\n*F\n+ 1 IdeCompatibleMessageRequestProcessor.kt\norg/jetbrains/kotlinx/jupyter/messaging/IdeCompatibleMessageRequestProcessor\n*L\n139#1:402,2\n139#1:404,4\n212#1:408\n*E\n"})
public class IdeCompatibleMessageRequestProcessor
extends AbstractMessageRequestProcessor
implements JupyterCommunicationFacility {
    @NotNull
    private final JupyterServerSockets socketManager;
    @NotNull
    private final CommManagerInternal commManager;
    @NotNull
    private final JupyterExecutor executor;
    @NotNull
    private final ExecutionCounter executionCounter;
    @NotNull
    private final ReplForJupyter repl;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MessageFactory messageFactory;
    @NotNull
    private final InputStream stdinIn;

    public IdeCompatibleMessageRequestProcessor(@NotNull RawMessage rawIncomingMessage, @NotNull MessageFactoryProvider messageFactoryProvider, @NotNull JupyterServerSockets socketManager, @NotNull CommManagerInternal commManager, @NotNull JupyterExecutor executor, @NotNull ExecutionCounter executionCounter, @NotNull KernelLoggerFactory loggerFactory, @NotNull ReplForJupyter repl) {
        Intrinsics.checkNotNullParameter((Object)rawIncomingMessage, (String)"rawIncomingMessage");
        Intrinsics.checkNotNullParameter((Object)messageFactoryProvider, (String)"messageFactoryProvider");
        Intrinsics.checkNotNullParameter((Object)socketManager, (String)"socketManager");
        Intrinsics.checkNotNullParameter((Object)commManager, (String)"commManager");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)executionCounter, (String)"executionCounter");
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        super(rawIncomingMessage);
        this.socketManager = socketManager;
        this.commManager = commManager;
        this.executor = executor;
        this.executionCounter = executionCounter;
        this.repl = repl;
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        StdIOSubstitutionManager.INSTANCE.setSubstitutionEngineType(this.repl.getNotebook().getKernelRunMode().getStreamSubstitutionType());
        StdIOSubstitutionManager.INSTANCE.setUseThreadLocal(this.repl.getNotebook().getKernelRunMode().getThreadLocalStreamSubstitution());
        IdeCompatibleMessageRequestProcessor ideCompatibleMessageRequestProcessor = this;
        IdeCompatibleMessageRequestProcessor ideCompatibleMessageRequestProcessor2 = this;
        boolean bl = false;
        messageFactoryProvider.update(rawIncomingMessage);
        Object t = messageFactoryProvider.provide();
        Intrinsics.checkNotNull(t);
        ideCompatibleMessageRequestProcessor2.messageFactory = (MessageFactory)t;
        this.stdinIn = new StdinInputStream(this);
    }

    @Override
    @NotNull
    public final JupyterServerSockets getSocketManager() {
        return this.socketManager;
    }

    @NotNull
    protected final CommManagerInternal getCommManager() {
        return this.commManager;
    }

    @NotNull
    protected final JupyterExecutor getExecutor() {
        return this.executor;
    }

    @NotNull
    protected final ExecutionCounter getExecutionCounter() {
        return this.executionCounter;
    }

    @NotNull
    protected final ReplForJupyter getRepl() {
        return this.repl;
    }

    @Override
    @NotNull
    public final MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @NotNull
    protected final InputStream getStdinIn() {
        return this.stdinIn;
    }

    protected static /* synthetic */ void getStdinIn$annotations() {
    }

    @Override
    protected void processUnknownShellMessage(@NotNull MessageContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        MessageKt.sendMessage(this.socketManager.getShell(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.NONE, null, null, null, null, null, null, 126, null));
    }

    @Override
    protected void processUnknownControlMessage(@NotNull MessageContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @Override
    protected void processUnknownStdinMessage(@NotNull MessageContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @Override
    protected void processIsCompleteRequest(@NotNull IsCompleteRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        MessageKt.sendMessage(this.socketManager.getShell(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.IS_COMPLETE_REPLY, null, null, null, null, new IsCompleteReply("complete", null, 2, null), null, 94, null));
    }

    @Override
    protected void processListErrorsRequest(@NotNull ListErrorsRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.executor.launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, content, null){
            int label;
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ ListErrorsRequest $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getRepl().listErrors(this.$content.getCode(), (Function1<? super ListErrorsResult, Unit>)((Function1)arg_0 -> processListErrorsRequest.1.invokeSuspend$lambda$0(this.this$0, arg_0)), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(IdeCompatibleMessageRequestProcessor this$0, ListErrorsResult result2) {
                JupyterCommunicationFacilityKt.sendWrapped(this$0, MessageFactoryKt.makeReplyMessage$default(this$0.getMessageFactory(), MessageType.LIST_ERRORS_REPLY, null, null, null, null, result2.getMessage(), null, 94, null));
                return Unit.INSTANCE;
            }
        }));
    }

    @Override
    protected void processCompleteRequest(@NotNull CompleteRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.executor.launchJob((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, content, null){
            int label;
            final /* synthetic */ IdeCompatibleMessageRequestProcessor this$0;
            final /* synthetic */ CompleteRequest $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getRepl().complete(this.$content.getCode(), this.$content.getCursorPos(), (Function1<? super CompletionResult, Unit>)((Function1)arg_0 -> processCompleteRequest.1.invokeSuspend$lambda$0(this.this$0, arg_0)), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(IdeCompatibleMessageRequestProcessor this$0, CompletionResult result2) {
                JupyterCommunicationFacilityKt.sendWrapped(this$0, MessageFactoryKt.makeReplyMessage$default(this$0.getMessageFactory(), MessageType.COMPLETE_REPLY, null, null, null, null, result2.getMessage(), null, 94, null));
                return Unit.INSTANCE;
            }
        }));
    }

    @Override
    protected void processCommMsg(@NotNull CommMsgMessage content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterExecutor.runExecution$default(this.executor, "Execution of comm_msg request for " + content.getCommId(), null, () -> IdeCompatibleMessageRequestProcessor.processCommMsg$lambda$0(this, content), 2, null);
    }

    @Override
    protected void processCommClose(@NotNull CommCloseMessage content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterExecutor.runExecution$default(this.executor, "Execution of comm_close request for " + content.getCommId(), null, () -> IdeCompatibleMessageRequestProcessor.processCommClose$lambda$0(this, content), 2, null);
    }

    @Override
    protected void processCommOpen(@NotNull CommOpenMessage content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterExecutor.runExecution$default(this.executor, "Execution of comm_open request for " + content.getCommId() + " of target " + content.getTargetName(), null, () -> IdeCompatibleMessageRequestProcessor.processCommOpen$lambda$0(this, content), 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processCommInfoRequest(@NotNull CommInfoRequest content) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Collection<org.jetbrains.kotlinx.jupyter.api.libraries.Comm> comms = this.commManager.getComms(content.getTargetName());
        Iterable $this$associate$iv = comms;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            org.jetbrains.kotlinx.jupyter.api.libraries.Comm comm = (org.jetbrains.kotlinx.jupyter.api.libraries.Comm)element$iv$iv;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)comm.getId(), (Object)new Comm(comm.getTarget()));
            map.put(pair2.getFirst(), pair2.getSecond());
        }
        Map replyMap = destination$iv$iv;
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.COMM_INFO_REPLY, null, null, null, null, new CommInfoReply(replyMap), null, 94, null));
    }

    @Override
    protected void processExecuteRequest(@NotNull ExecuteRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        int count = this.executionCounter.next-7ImE1O0(content.getStoreHistory());
        String startedTime = MessageKt.getISO8601DateNow();
        JupyterCommunicationFacilityKt.doWrappedInBusyIdle(this, (Function0<Unit>)((Function0)() -> IdeCompatibleMessageRequestProcessor.processExecuteRequest$lambda$0(content, this, count, startedTime)));
    }

    @Override
    protected void processConnectRequest(@NotNull ConnectRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.CONNECT_REPLY, null, null, null, null, new ConnectReply(JsonExtensionsKt.getEMPTY((Json)((Json)Json.Default))), null, 94, null));
    }

    @Override
    protected void processHistoryRequest(@NotNull HistoryRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.HISTORY_REPLY, null, null, null, null, new HistoryReply(CollectionsKt.emptyList()), null, 94, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processKernelInfoRequest(@NotNull KernelInfoRequest content) {
        void value$iv;
        void $this$encodeToJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterCommunicationFacility jupyterCommunicationFacility = this;
        MessageFactory messageFactory = this.messageFactory;
        MessageType messageType = MessageType.KERNEL_INFO_REPLY;
        KernelInfoReply kernelInfoReply = new KernelInfoReply("5.3", "Kotlin", KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()), "Kotlin kernel v. " + KotlinKernelVersion.Companion.toMaybeUnspecifiedString(RuntimePropertiesKt.getCurrentKernelVersion()) + ", Kotlin v. " + RuntimePropertiesKt.getCurrentKotlinVersion(), NotebookMetadataKt.getNotebookLanguageInfo(), CollectionsKt.emptyList());
        Json json = (Json)Json.Default;
        KernelInfoReplyMetadata kernelInfoReplyMetadata = new KernelInfoReplyMetadata(this.repl.getCurrentSessionState());
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)KernelInfoReplyMetadata.Companion.serializer(), (Object)value$iv);
        JupyterCommunicationFacilityKt.sendWrapped(jupyterCommunicationFacility, MessageFactoryKt.makeReplyMessage$default(messageFactory, messageType, null, null, null, jsonElement, kernelInfoReply, null, 78, null));
    }

    @Override
    protected void processUpdateClientMetadata(@NotNull UpdateClientMetadataRequest content) {
        MessageContent messageContent;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            Path path2 = content.getAbsoluteNotebookFilePath();
            this.repl.getNotebook().updateFilePath(path2);
            messageContent = new UpdateClientMetadataSuccessReply();
        }
        catch (InvalidPathException ex) {
            this.logger.error("Invalid notebook file path: " + content.getAbsoluteNotebookFilePath(), (Throwable)ex);
            messageContent = new UpdateClientMetadataErrorReply(ex);
        }
        MessageContent replyContent = messageContent;
        JupyterCommunicationFacilityKt.sendWrapped(this, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.UPDATE_CLIENT_METADATA_REPLY, null, null, null, null, replyContent, null, 94, null));
    }

    @Override
    protected void processShutdownRequest(@NotNull ShutdownRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.repl.evalOnShutdown();
        this.executor.close();
        MessageKt.sendMessage(this.socketManager.getControl(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.SHUTDOWN_REPLY, null, null, null, null, this.getIncomingMessage().getContent(), null, 94, null));
        if (this.repl.getKernelRunMode().getShouldKillProcessOnShutdown()) {
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        this.logger.info("Interrupting controlThread to trigger kernel shutdown");
        throw new InterruptedException();
    }

    @Override
    protected void processInterruptRequest(@NotNull InterruptRequest content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.executor.interruptExecution();
        MessageKt.sendMessage(this.socketManager.getControl(), MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.INTERRUPT_REPLY, null, null, null, null, this.getIncomingMessage().getContent(), null, 94, null));
    }

    @Override
    protected void processInputReply(@NotNull InputReply content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @NotNull
    protected JupyterResponse runExecution(@NotNull String executionName, @NotNull Function0<? extends EvalResultEx> execution2) {
        JupyterResponse jupyterResponse;
        Intrinsics.checkNotNullParameter((Object)executionName, (String)"executionName");
        Intrinsics.checkNotNullParameter(execution2, (String)"execution");
        ExecutionResult<? extends EvalResultEx> res = this.executor.runExecution(executionName, this.repl.getCurrentClassLoader(), execution2);
        if (res instanceof ExecutionResult.Success) {
            JupyterResponse jupyterResponse2;
            try {
                JupyterResponse jupyterResponse3;
                EvalResultEx replResult = (EvalResultEx)((ExecutionResult.Success)res).getResult();
                if (replResult instanceof EvalResultEx.Success) {
                    jupyterResponse3 = new OkJupyterResponse(((EvalResultEx.Success)replResult).getDisplayValue(), ((EvalResultEx.Success)replResult).getMetadata());
                } else if (replResult instanceof EvalResultEx.Error) {
                    jupyterResponse3 = JupyterResponseKt.toErrorJupyterResponse(((EvalResultEx.Error)replResult).getError(), ((EvalResultEx.Error)replResult).getMetadata());
                } else if (replResult instanceof EvalResultEx.RenderedError) {
                    jupyterResponse3 = new OkJupyterResponse(((EvalResultEx.RenderedError)replResult).getDisplayError(), ((EvalResultEx.RenderedError)replResult).getMetadata());
                } else if (replResult instanceof EvalResultEx.Interrupted) {
                    jupyterResponse3 = new ErrorJupyterResponse("The execution was interrupted", null, ((EvalResultEx.Interrupted)replResult).getMetadata(), 2, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                jupyterResponse2 = jupyterResponse3;
            }
            catch (Throwable e) {
                jupyterResponse2 = new ErrorJupyterResponse("error:  Unable to convert result to a string: " + e, null, null, 6, null);
            }
            jupyterResponse = jupyterResponse2;
        } else if (res instanceof ExecutionResult.Failure) {
            jupyterResponse = JupyterResponseKt.toErrorJupyterResponse$default(((ExecutionResult.Failure)res).getThrowable(), null, 1, null);
        } else if (Intrinsics.areEqual(res, (Object)ExecutionResult.Interrupted.INSTANCE)) {
            jupyterResponse = new ErrorJupyterResponse("The execution was interrupted", null, null, 6, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jupyterResponse;
    }

    private final OutputConfig getReplOutputConfig() {
        return this.repl.getOptions().getOutputConfig();
    }

    private final PrintStream getCapturingStream(PrintStream parentStream, JupyterOutType outType, boolean captureOutput) {
        return this.asPrintStream(new CapturingOutputStream(parentStream, this.getReplOutputConfig(), captureOutput, (Function1<? super String, Unit>)((Function1)arg_0 -> IdeCompatibleMessageRequestProcessor.getCapturingStream$lambda$0(this, outType, arg_0))));
    }

    private final PrintStream asPrintStream(OutputStream $this$asPrintStream) {
        return new PrintStream($this$asPrintStream, false, "UTF-8");
    }

    private final <T> T withForkedOut(Function0<? extends T> body) {
        return StdIOSubstitutionManager.INSTANCE.getStdoutContext().withSubstitutedStreams(arg_0 -> IdeCompatibleMessageRequestProcessor.withForkedOut$lambda$0(this, arg_0), IdeCompatibleMessageRequestProcessor::withForkedOut$lambda$1, body);
    }

    private final <T> T withForkedErr(Function0<? extends T> body) {
        return StdIOSubstitutionManager.INSTANCE.getStderrContext().withSubstitutedStreams(arg_0 -> IdeCompatibleMessageRequestProcessor.withForkedErr$lambda$0(this, arg_0), arg_0 -> IdeCompatibleMessageRequestProcessor.withForkedErr$lambda$1(this, arg_0), body);
    }

    private final <T> T withForkedIn(boolean allowStdIn, Function0<? extends T> body) {
        return StdIOSubstitutionManager.INSTANCE.getStdinContext().withSubstitutedStreams(arg_0 -> IdeCompatibleMessageRequestProcessor.withForkedIn$lambda$0(allowStdIn, this, arg_0), IdeCompatibleMessageRequestProcessor::withForkedIn$lambda$1, body);
    }

    protected <T> T evalWithIO(boolean allowStdIn, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.repl.getNotebook().beginEvalSession();
        return this.withForkedOut(() -> IdeCompatibleMessageRequestProcessor.evalWithIO$lambda$0(this, allowStdIn, body));
    }

    private final String presentableForThreadName(String $this$presentableForThreadName) {
        String newName = StringsKt.take((String)StringsKt.substringBefore$default((String)$this$presentableForThreadName, (char)'\n', null, (int)2, null), (int)20);
        return newName.length() < $this$presentableForThreadName.length() ? newName + "..." : $this$presentableForThreadName;
    }

    private static final Unit processCommMsg$lambda$0(IdeCompatibleMessageRequestProcessor this$0, CommMsgMessage $content) {
        this$0.commManager.processCommMessage(this$0.getIncomingMessage(), $content);
        return Unit.INSTANCE;
    }

    private static final Unit processCommClose$lambda$0(IdeCompatibleMessageRequestProcessor this$0, CommCloseMessage $content) {
        this$0.commManager.processCommClose(this$0.getIncomingMessage(), $content);
        return Unit.INSTANCE;
    }

    private static final org.jetbrains.kotlinx.jupyter.api.libraries.Comm processCommOpen$lambda$0(IdeCompatibleMessageRequestProcessor this$0, CommOpenMessage $content) {
        org.jetbrains.kotlinx.jupyter.api.libraries.Comm comm = this$0.commManager.processCommOpen(this$0.getIncomingMessage(), $content);
        if (comm == null) {
            throw new ReplException("Cannot open comm for " + $content.getCommId() + " of target " + $content.getTargetName(), null, 2, null);
        }
        return comm;
    }

    private static final Unit processExecuteRequest$lambda$0(ExecuteRequest $content, IdeCompatibleMessageRequestProcessor this$0, int $count, String $startedTime) {
        String code = $content.getCode();
        MessageKt.sendMessage(this$0.socketManager.getIopub(), MessageFactoryKt.makeReplyMessage$default(this$0.messageFactory, MessageType.EXECUTE_INPUT, null, null, null, null, new ExecuteInput(code, $count, null), null, 94, null));
        JupyterResponse response = CommandsUtilKt.looksLikeReplCommand(code) ? CommandsProcessingKt.runCommand(code, this$0.repl) : this$0.runExecution("Execution of code '" + this$0.presentableForThreadName(code) + "'", (Function0<? extends EvalResultEx>)((Function0)() -> IdeCompatibleMessageRequestProcessor.processExecuteRequest$lambda$0$0(this$0, $content, code, $count)));
        JupyterResponseKt.sendResponse-zEAq3HY(this$0, response, $count, $startedTime);
        return Unit.INSTANCE;
    }

    private static final EvalResultEx processExecuteRequest$lambda$0$0(IdeCompatibleMessageRequestProcessor this$0, ExecuteRequest $content, String $code, int $count) {
        return (EvalResultEx)this$0.evalWithIO($content.getAllowStdin(), () -> IdeCompatibleMessageRequestProcessor.processExecuteRequest$lambda$0$0$0(this$0, $code, $count, $content));
    }

    private static final EvalResultEx processExecuteRequest$lambda$0$0$0(IdeCompatibleMessageRequestProcessor this$0, String $code, int $count, ExecuteRequest $content) {
        return this$0.repl.evalEx(new EvalRequestData($code, $count, $content.getStoreHistory(), $content.getSilent(), null));
    }

    private static final Unit getCapturingStream$lambda$0(IdeCompatibleMessageRequestProcessor this$0, JupyterOutType $outType, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MutableCodeCell mutableCodeCell = this$0.repl.getNotebook().getCurrentCell();
        if (mutableCodeCell != null) {
            mutableCodeCell.appendStreamOutput(text);
        }
        JupyterCommunicationFacilityKt.sendOut(this$0, $outType, text);
        return Unit.INSTANCE;
    }

    private static final PrintStream withForkedOut$lambda$0(IdeCompatibleMessageRequestProcessor this$0, PrintStream out2) {
        return this$0.getCapturingStream(out2, JupyterOutType.STDOUT, this$0.getReplOutputConfig().getCaptureOutput());
    }

    private static final PrintStream withForkedOut$lambda$1(PrintStream it) {
        return null;
    }

    private static final PrintStream withForkedErr$lambda$0(IdeCompatibleMessageRequestProcessor this$0, PrintStream err) {
        return this$0.getCapturingStream(err, JupyterOutType.STDERR, false);
    }

    private static final PrintStream withForkedErr$lambda$1(IdeCompatibleMessageRequestProcessor this$0, PrintStream it) {
        return this$0.getCapturingStream(null, JupyterOutType.STDERR, true);
    }

    private static final InputStream withForkedIn$lambda$0(boolean $allowStdIn, IdeCompatibleMessageRequestProcessor this$0, InputStream it) {
        return $allowStdIn ? this$0.stdinIn : (InputStream)DisabledStdinInputStream.INSTANCE;
    }

    private static final InputStream withForkedIn$lambda$1(InputStream it) {
        return null;
    }

    private static final Object evalWithIO$lambda$0(IdeCompatibleMessageRequestProcessor this$0, boolean $allowStdIn, Function0 $body) {
        return this$0.withForkedErr(() -> IdeCompatibleMessageRequestProcessor.evalWithIO$lambda$0$0(this$0, $allowStdIn, $body));
    }

    private static final Object evalWithIO$lambda$0$0(IdeCompatibleMessageRequestProcessor this$0, boolean $allowStdIn, Function0 $body) {
        return this$0.withForkedIn($allowStdIn, $body);
    }
}

