/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.google.common.collect.ImmutableSet;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.util.DirectoryModificationTrackerManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.SmartHashSet;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class SearchHelper
extends UserDataHolderBase {
    public static final Logger log = Logger.getInstance(SearchHelper.class);
    public static final Comparator<Module> MODULES_BY_DEPENDENCY_COMPARATOR = (m1, m2) -> {
        if (SearchHelper.deepDependsOn(m1, m2)) {
            return -1;
        }
        if (SearchHelper.deepDependsOn(m2, m1)) {
            return 1;
        }
        return 0;
    };
    private final JavaPsiFacade javaPsiFacade;
    private final ProjectRootManager projectRootManager;
    private final ProjectFileIndex projectFileIndex;
    private final Project project;
    private final CachedValuesManager cachedValuesManager;
    private final SmartPointerManager smartPointerManager;
    private final PsiManager psiManager;
    private final Map<String, Key<CachedValue<SmartPsiElementPointer<? extends PsiFileSystemItem>>>> cacheKeysMap;

    public SearchHelper(Project project) {
        this.project = project;
        this.projectRootManager = ProjectRootManager.getInstance((Project)project);
        this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        this.projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        this.cachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.smartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.psiManager = PsiManager.getInstance((Project)project);
        this.cacheKeysMap = new HashMap<String, Key<CachedValue<SmartPsiElementPointer<? extends PsiFileSystemItem>>>>();
    }

    public static SearchHelper getInstance(@NotNull Project project) {
        if (project == null) {
            SearchHelper.$$$reportNull$$$0(0);
        }
        return (SearchHelper)((Object)project.getService(SearchHelper.class));
    }

    @Nullable
    public PsiDirectory findDirectory(@NotNull String path, @NotNull GlobalSearchScope searchScope) {
        Path parsedPath;
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            SearchHelper.$$$reportNull$$$0(2);
        }
        if ((parsedPath = this.parsePath(path)) == null) {
            return null;
        }
        return this.findDirectory(parsedPath, searchScope);
    }

    @Nullable
    public PsiDirectory findDirectory(@NotNull Path path, @NotNull GlobalSearchScope searchScope) {
        GlobalSearchScopeWrapper scopeWrapper;
        SmartPsiElementPointer pointer;
        String keyString;
        Key key;
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            SearchHelper.$$$reportNull$$$0(4);
        }
        if ((key = this.cacheKeysMap.get(keyString = new StringJoiner(":").add(path.toString()).add(searchScope.getDisplayName()).add("CACHED_KEY").toString())) == null) {
            key = Key.create((String)keyString);
            this.cacheKeysMap.put(keyString, (Key<CachedValue<SmartPsiElementPointer<? extends PsiFileSystemItem>>>)key);
        }
        if ((pointer = (SmartPsiElementPointer)this.cachedValuesManager.getCachedValue((UserDataHolder)this, key, () -> this.lambda$findDirectory$2(path, scopeWrapper = new GlobalSearchScopeWrapper(searchScope)), false)) == null) {
            return null;
        }
        PsiDirectory foundFile = (PsiDirectory)ReadAction.compute(() -> ((SmartPsiElementPointer)pointer).getElement());
        if (foundFile == null) {
            log.debug("Pointer found, but element is null! Directory: " + String.valueOf(path));
        }
        return foundFile;
    }

    @Nullable
    private PsiDirectory findDirectoryByAbsolutePath(@NotNull Path path, @NotNull GlobalSearchScope scope) {
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            SearchHelper.$$$reportNull$$$0(6);
        }
        log.debug("Find dir: " + String.valueOf(path));
        VirtualFile vFile = VfsUtil.findFile((Path)path, (boolean)true);
        if (vFile == null) {
            log.debug("VirtualFile is null");
            return null;
        }
        if (!scope.accept(vFile)) {
            log.debug("Scope non accept");
            return null;
        }
        PsiDirectory foundDirectory = this.psiManager.findDirectory(vFile);
        if (foundDirectory == null) {
            log.debug("PsiDirectory is null");
            return null;
        }
        return foundDirectory;
    }

    @Nullable
    private PsiDirectory findDirectoryFromRelativePath(@NotNull Path path, @NotNull GlobalSearchScope scope) {
        VirtualFile foundVf;
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            SearchHelper.$$$reportNull$$$0(8);
        }
        return (foundVf = (VirtualFile)((StreamEx)StreamEx.of(this.findDirectoriesByName(path.getFileName().toString(), scope)).filter(file -> Paths.get(file.getPath(), new String[0]).endsWith(path))).min(Comparator.comparing(virtualFile -> ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.project), Comparator.nullsLast(MODULES_BY_DEPENDENCY_COMPARATOR))).orElse(null)) == null ? null : PsiManager.getInstance((Project)this.project).findDirectory(foundVf);
    }

    @NotNull
    public List<VirtualFile> findDirectoriesByName(@NotNull String dirName, @NotNull GlobalSearchScope searchScope) {
        if (dirName == null) {
            SearchHelper.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            SearchHelper.$$$reportNull$$$0(10);
        }
        Collection foundFiles = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((String)dirName, (GlobalSearchScope)searchScope));
        List list = ((StreamEx)StreamEx.of((Collection)foundFiles).filter(VirtualFile::isDirectory)).toList();
        if (list == null) {
            SearchHelper.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public <T extends PsiFile> T findFile(@Nullable String path, @NotNull Class<T> fileType, @NotNull GlobalSearchScope searchScope) {
        Path parsedPath;
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            SearchHelper.$$$reportNull$$$0(13);
        }
        if ((parsedPath = this.parsePath(path)) == null) {
            return null;
        }
        return this.findFile(parsedPath, fileType, searchScope);
    }

    @Nullable
    public <T extends PsiFile> T findFile(@NotNull Path path, @NotNull Class<T> fileType, @NotNull GlobalSearchScope searchScope) {
        GlobalSearchScopeWrapper scopeWrapper;
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(14);
        }
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            SearchHelper.$$$reportNull$$$0(16);
        }
        String keyString = new StringJoiner(":").add(path.toString()).add(fileType.getSimpleName()).add(searchScope.getDisplayName()).add("CACHED_KEY").toString();
        Key key = CacheKeyStore.getKeys(this.project, (UserDataHolder)this).get(keyString);
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)this.cachedValuesManager.getCachedValue((UserDataHolder)this, key, () -> this.lambda$findFile$7(path, fileType, scopeWrapper = new GlobalSearchScopeWrapper(searchScope)), false);
        if (pointer == null) {
            return null;
        }
        PsiFile foundFile = (PsiFile)ReadAction.compute(() -> ((SmartPsiElementPointer)pointer).getElement());
        if (foundFile == null) {
            log.debug("Pointer found, but element is null! File: " + String.valueOf(path));
        }
        return (T)foundFile;
    }

    @Nullable
    public <T extends PsiFile> T findFileFromAbsolutePath(@NotNull Path path, @NotNull Class<T> fileType, @NotNull GlobalSearchScope scope) {
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(17);
        }
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            SearchHelper.$$$reportNull$$$0(19);
        }
        log.debug("Find file: " + String.valueOf(path));
        VirtualFile vFile = VfsUtil.findFile((Path)path, (boolean)true);
        if (vFile == null) {
            log.debug("VirtualFile is null");
            return null;
        }
        VirtualFile canonicalFile = vFile.getCanonicalFile();
        if (canonicalFile == null || !scope.accept(vFile) && !scope.accept(canonicalFile)) {
            log.debug("Scope non accept");
            return null;
        }
        PsiFile foundFile = this.psiManager.findFile(vFile);
        if (foundFile == null) {
            log.debug("PsiFile is null");
            return null;
        }
        if (!fileType.isInstance(foundFile)) {
            log.debug("PsiFile is not cast to '" + String.valueOf(fileType) + "' type");
            return null;
        }
        return (T)foundFile;
    }

    @Nullable
    private <T extends PsiFile> T findFileFromRelativePath(@NotNull Path path, @NotNull Class<T> fileType, @NotNull GlobalSearchScope scope) {
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(20);
        }
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            SearchHelper.$$$reportNull$$$0(22);
        }
        return (T)((PsiFile)((StreamEx)StreamEx.of(this.findFilesByName(path.getFileName().toString(), fileType, scope)).filter(file -> Paths.get(file.getVirtualFile().getPath(), new String[0]).endsWith(path))).min(Comparator.comparing(ModuleUtilCore::findModuleForFile, Comparator.nullsLast(MODULES_BY_DEPENDENCY_COMPARATOR))).orElse(null));
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public <T extends PsiFile> T findFile(@Nullable String path, @NotNull Class<T> fileType, boolean includeLibraries) {
        Path parsedPath;
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(23);
        }
        if ((parsedPath = this.parsePath(path)) == null) {
            return null;
        }
        return this.findFile(parsedPath, fileType, includeLibraries);
    }

    @Nullable
    public <T extends PsiFile> T findFile(@NotNull Path path, @NotNull Class<T> fileType, boolean includeLibraries) {
        if (path == null) {
            SearchHelper.$$$reportNull$$$0(24);
        }
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(25);
        }
        return this.findFile(path, fileType, this.getScope(includeLibraries));
    }

    public Collection<VirtualFile> findFilesByName(Set<String> fileNamesWithoutExt, Set<String> fileExtensions, @NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            SearchHelper.$$$reportNull$$$0(26);
        }
        if (fileNamesWithoutExt.isEmpty() || fileExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        Set fileNames = StreamEx.of(fileNamesWithoutExt).flatMap(fileName -> StreamEx.of((Collection)fileExtensions).map(ext -> fileName + "." + ext)).toSet();
        return (Collection)ReadAction.compute(() -> {
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            FilenameIndex.processFilesByNames((Set)fileNames, (boolean)true, (GlobalSearchScope)searchScope, null, (Processor)processor);
            return processor.getResults();
        });
    }

    @NotNull
    public <T extends PsiFile> Set<T> findFilesByName(@NotNull String fileName, @NotNull Class<T> fileType, @NotNull GlobalSearchScope searchScope) {
        if (fileName == null) {
            SearchHelper.$$$reportNull$$$0(27);
        }
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(28);
        }
        if (searchScope == null) {
            SearchHelper.$$$reportNull$$$0(29);
        }
        SmartHashSet files = new SmartHashSet();
        Collection foundFiles = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)searchScope));
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        for (VirtualFile vf : foundFiles) {
            PsiFile psiFile;
            if (vf.isDirectory() || (psiFile = psiManager.findFile(vf)) == null || !fileType.isAssignableFrom(psiFile.getClass())) continue;
            files.add(psiFile);
        }
        SmartHashSet smartHashSet = files;
        if (smartHashSet == null) {
            SearchHelper.$$$reportNull$$$0(30);
        }
        return smartHashSet;
    }

    @NotNull
    public <T extends PsiFile> Set<T> findFilesByName(@NotNull String name, @NotNull Class<T> fileType, boolean includeLibraries) {
        if (name == null) {
            SearchHelper.$$$reportNull$$$0(31);
        }
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(32);
        }
        Set<T> set = this.findFilesByName(name, fileType, this.getScope(includeLibraries));
        if (set == null) {
            SearchHelper.$$$reportNull$$$0(33);
        }
        return set;
    }

    private boolean isRoot(PsiDirectory directory, Set<String> rootUrls) {
        String url = directory.getVirtualFile().getUrl();
        return rootUrls.contains(url);
    }

    private Set<String> getRootUrls(PsiDirectory directory) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ProjectFileIndex fileIndex = this.projectRootManager.getFileIndex();
        PsiManager manager = directory.getManager();
        if (manager.isInProject((PsiElement)directory)) {
            Module module = fileIndex.getModuleForFile(directory.getVirtualFile());
            if (module != null) {
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                builder.add((Object[])rootManager.getSourceRootUrls());
                builder.add((Object[])rootManager.getContentRootUrls());
            }
        } else {
            Library library = this.findLibraryContainingFile(directory.getVirtualFile());
            if (library != null) {
                builder.add((Object[])library.getUrls(OrderRootType.CLASSES));
                builder.add((Object[])library.getUrls(OrderRootType.SOURCES));
            }
        }
        return builder.build();
    }

    @Nullable
    public Library findLibraryContainingFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            SearchHelper.$$$reportNull$$$0(34);
        }
        List entries = this.projectFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry oe : entries) {
            if (!(oe instanceof LibraryOrderEntry)) continue;
            return ((LibraryOrderEntry)oe).getLibrary();
        }
        return null;
    }

    @Nullable
    public PsiDirectory getSourceRoot(@NotNull PsiDirectory invokeDir) {
        PsiDirectory dir;
        if (invokeDir == null) {
            SearchHelper.$$$reportNull$$$0(35);
        }
        Set<String> rootUrls = this.getRootUrls(invokeDir);
        for (dir = invokeDir; dir != null && !this.isRoot(dir, rootUrls); dir = dir.getParentDirectory()) {
        }
        return dir;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            SearchHelper.$$$reportNull$$$0(36);
        }
        try {
            PsiClass result = this.javaPsiFacade.findClass(qualifiedName, GlobalSearchScope.projectScope((Project)this.project));
            if (result == null) {
                result = this.javaPsiFacade.findClass(qualifiedName, ProjectScope.getLibrariesScope((Project)this.project));
            }
            return result;
        }
        catch (IndexNotReadyException e) {
            log.warn("Index not ready exception during search helper", (Throwable)e);
            return null;
        }
    }

    @Contract(value="null -> null")
    @Nullable
    private Path parsePath(@Nullable String path) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        try {
            return path.startsWith("\\") || path.startsWith("/") ? Paths.get(path.substring(1), new String[0]) : Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            log.debug("Invalid path: '" + path + "'");
            return null;
        }
    }

    @NotNull
    private GlobalSearchScope getScope(boolean includeLibraries) {
        GlobalSearchScope correctProjectScope = ProjectScope.getProjectScope((Project)this.project);
        GlobalSearchScope globalSearchScope = includeLibraries ? GlobalSearchScope.union((GlobalSearchScope[])new GlobalSearchScope[]{correctProjectScope, ProjectScope.getLibrariesScope((Project)this.project)}) : correctProjectScope;
        if (globalSearchScope == null) {
            SearchHelper.$$$reportNull$$$0(37);
        }
        return globalSearchScope;
    }

    public static boolean deepDependsOn(Module one, Module another) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)one);
        if (rootManager.isDependsOn(another)) {
            return true;
        }
        return Arrays.stream(rootManager.getDependencies()).anyMatch(module -> SearchHelper.deepDependsOn(module, another));
    }

    @NotNull
    public List<PsiFile> findFilesByExt(@NotNull String ext, GlobalSearchScope scope) {
        if (ext == null) {
            SearchHelper.$$$reportNull$$$0(38);
        }
        List<PsiFile> list = this.findFilesByExt(ext, PsiFile.class, scope);
        if (list == null) {
            SearchHelper.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public <T extends PsiFile> List<T> findFilesByExt(@NotNull String ext, @NotNull Class<T> fileType, GlobalSearchScope scope) {
        if (ext == null) {
            SearchHelper.$$$reportNull$$$0(40);
        }
        if (fileType == null) {
            SearchHelper.$$$reportNull$$$0(41);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        List list = StreamEx.of((Collection)FilenameIndex.getAllFilesByExt((Project)this.project, (String)ext, (GlobalSearchScope)scope)).map(arg_0 -> ((PsiManager)psiManager).findFile(arg_0)).select(fileType).toList();
        if (list == null) {
            SearchHelper.$$$reportNull$$$0(42);
        }
        return list;
    }

    private /* synthetic */ CachedValueProvider.Result lambda$findFile$7(Path path, Class fileType, GlobalSearchScopeWrapper scopeWrapper) {
        return (CachedValueProvider.Result)ReadAction.compute(() -> {
            Object psiFile = path.isAbsolute() ? this.findFileFromAbsolutePath(path, fileType, scopeWrapper.getScope()) : this.findFileFromRelativePath(path, fileType, scopeWrapper.getScope());
            SmartPsiElementPointer result = psiFile == null ? null : this.smartPointerManager.createSmartPsiElementPointer(psiFile);
            ArrayList<ModificationTracker> dependencies = new ArrayList<ModificationTracker>();
            dependencies.add(DirectoryModificationTrackerManager.getDirectoryTracker(this.project, path));
            return CachedValueProvider.Result.create((Object)result, dependencies);
        });
    }

    private /* synthetic */ CachedValueProvider.Result lambda$findDirectory$2(Path path, GlobalSearchScopeWrapper scopeWrapper) {
        return (CachedValueProvider.Result)ReadAction.compute(() -> {
            PsiDirectory psiDirectory = path.isAbsolute() ? this.findDirectoryByAbsolutePath(path, scopeWrapper.getScope()) : this.findDirectoryFromRelativePath(path, scopeWrapper.getScope());
            SmartPsiElementPointer result = psiDirectory == null ? null : this.smartPointerManager.createSmartPsiElementPointer((PsiElement)psiDirectory);
            ArrayList<ModificationTracker> dependencies = new ArrayList<ModificationTracker>();
            dependencies.add(DirectoryModificationTrackerManager.getDirectoryTracker(this.project, path));
            return CachedValueProvider.Result.create((Object)result, dependencies);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 30, 33, 37, 39, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: 
            case 8: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 11: 
            case 30: 
            case 33: 
            case 37: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/util/SearchHelper";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeDir";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/util/SearchHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectoriesByName";
                break;
            }
            case 30: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 39: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryByAbsolutePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryFromRelativePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoriesByName";
                break;
            }
            case 11: 
            case 30: 
            case 33: 
            case 37: 
            case 39: 
            case 42: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFileFromAbsolutePath";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findFileFromRelativePath";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryContainingFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoot";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 38: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByExt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 30, 33, 37, 39, 42 -> new IllegalStateException(string);
        };
    }

    private static class GlobalSearchScopeWrapper {
        private final GlobalSearchScope scope;

        private GlobalSearchScopeWrapper(GlobalSearchScope scope) {
            this.scope = scope;
        }

        public GlobalSearchScope getScope() {
            return this.scope;
        }

        @Contract(value="null -> false", pure=true)
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj || this.getClass() == obj.getClass() && this.scope.getDisplayName().equals(((GlobalSearchScopeWrapper)obj).scope.getDisplayName());
        }

        public int hashCode() {
            return this.scope.hashCode();
        }
    }
}

