/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class ElComponentTypeUtil {
    @Nullable
    public static PsiClass getCachedClass(PsiFile psiFile, String clazzName) {
        return JavaPsiFacade.getInstance((Project)psiFile.getProject()).findClass(clazzName, ElComponentTypeUtil.getElementDependenciesScope((PsiElement)psiFile));
    }

    public static GlobalSearchScope getElementDependenciesScope(PsiElement psiFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        return module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false) : GlobalSearchScope.allScope((Project)psiFile.getProject());
    }

    static PsiSubstitutor fillSubstitutionMapFromSupers(PsiClass psiClass, PsiSubstitutor substitutor) {
        return ElComponentTypeUtil.fillSubstitutionMapFromSupers(psiClass, substitutor, new HashSet<PsiClass>(Collections.singleton(psiClass)));
    }

    public static PsiSubstitutor fillSubstitutionMapFromSupers(PsiClass psiClass, PsiSubstitutor substitutor, Set<PsiClass> visited) {
        PsiClassType[] classTypes;
        for (PsiClassType superType : classTypes = psiClass.getSuperTypes()) {
            if (superType == null) continue;
            PsiClassType.ClassResolveResult classResolveResult = superType.resolveGenerics();
            substitutor = substitutor.putAll(classResolveResult.getSubstitutor());
            PsiClass superClass = classResolveResult.getElement();
            if (superClass == null || visited.contains(superClass)) continue;
            substitutor = ElComponentTypeUtil.fillSubstitutionMapFromSupers(superClass, substitutor);
        }
        return substitutor;
    }

    @Nullable
    public static PsiType evaluateComponentType(PsiType fromResolved, PsiElement context) {
        PsiClassType psiClassType;
        PsiClassType.ClassResolveResult classResolveResult;
        if (fromResolved instanceof PsiArrayType) {
            return ((PsiArrayType)fromResolved).getComponentType();
        }
        if (fromResolved instanceof PsiClassType && (classResolveResult = (psiClassType = (PsiClassType)fromResolved).resolveGenerics()).getElement() != null) {
            PsiFile psiFile = context.getContainingFile();
            Project project = psiFile.getProject();
            PsiManager manager = PsiManager.getInstance((Project)project);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiType type = ElComponentTypeUtil.evaluateSpecialType(ElComponentTypeUtil.getCachedClass(psiFile, "java.util.List"), classResolveResult, manager, scope, 0);
            if (type != null) {
                return type;
            }
            type = ElComponentTypeUtil.evaluateSpecialType(ElComponentTypeUtil.getCachedClass(psiFile, "java.util.Collection"), classResolveResult, manager, scope, 0);
            if (type != null) {
                return type;
            }
            return ElComponentTypeUtil.evaluateSpecialType(ElComponentTypeUtil.getCachedClass(psiFile, "java.util.Map"), classResolveResult, manager, scope, 1);
        }
        return null;
    }

    @Nullable
    static PsiType evaluateSpecialType(PsiClass listClass, PsiClassType.ClassResolveResult classResolveResult, PsiManager manager, GlobalSearchScope scope, int typeParameterIndex) {
        if (ElComponentTypeUtil.isInheritor(listClass, classResolveResult)) {
            PsiTypeParameter[] typeParameters = listClass.getTypeParameters();
            if (typeParameters.length > typeParameterIndex) {
                PsiSubstitutor psiSubstitutor = ElComponentTypeUtil.getSubstitutions(classResolveResult);
                PsiType type = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParameters[typeParameterIndex]);
                if (type != null) {
                    return type;
                }
                PsiClass psiClass = classResolveResult.getElement();
                assert (psiClass != null);
                PsiTypeParameter[] typeParametersFromResolveResult = psiClass.getTypeParameters();
                if (typeParametersFromResolveResult.length > typeParameterIndex && (type = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParametersFromResolveResult[typeParameterIndex])) != null) {
                    return type;
                }
            }
            return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Object", scope);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutions(PsiClassType.ClassResolveResult classResolveResult) {
        PsiSubstitutor psiSubstitutor = classResolveResult.getSubstitutor();
        if (psiSubstitutor.getSubstitutionMap().isEmpty()) {
            psiSubstitutor = ElComponentTypeUtil.fillSubstitutionMapFromSupers(classResolveResult.getElement(), psiSubstitutor);
        }
        return psiSubstitutor;
    }

    public static boolean isInheritor(PsiClass listClass, PsiClassType.ClassResolveResult classResolveResult) {
        PsiClass element = classResolveResult.getElement();
        return listClass != null && (element == listClass || element != null && element.isInheritor(listClass, true));
    }
}

