/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.util.processors;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.el.ELElementProcessor;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.references.ELReference;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ELElementCollectProcessor
extends ELElementProcessor {
    protected final boolean allowMethodNameCompletion;
    protected final Collection<Object> myResult;

    public ELElementCollectProcessor(@NotNull ELExpression element) {
        if (element == null) {
            ELElementCollectProcessor.$$$reportNull$$$0(0);
        }
        this.myResult = new HashSet<Object>();
        this.allowMethodNameCompletion = ELResolveUtil.allowPropertyMethodName((PsiElement)element);
    }

    @NotNull
    public Collection<Object> getResult() {
        Collection<Object> collection = this.myResult;
        if (collection == null) {
            ELElementCollectProcessor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    public boolean processMethod(PsiMethod method) {
        if (ELElementCollectProcessor.acceptMethodCompletion(method)) {
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
            if (propertyName != null && !this.allowMethodNameCompletion) {
                PsiType type = PropertyUtilBase.getPropertyType((PsiMember)method);
                if (type != null) {
                    this.myResult.add(LookupElementBuilder.create((String)propertyName).withIcon(AllIcons.Nodes.Property).withTypeText(type.getPresentableText()));
                }
            } else {
                this.myResult.add(JavaLookupElementBuilder.forMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY).withInsertHandler(ELElementCollectProcessor.getMethodInsertHandler(method)));
            }
        }
        return true;
    }

    @Override
    public boolean processField(PsiField field) {
        this.myResult.add(JavaLookupElementBuilder.forField((PsiField)field).withTypeText(field.getType().getPresentableText()));
        return true;
    }

    @Override
    public boolean processProperty(IProperty property) {
        this.myResult.add(property);
        return true;
    }

    @Override
    public void setSubstitutor(PsiSubstitutor substitutor) {
    }

    @Override
    @Nullable
    public String getNameHint() {
        return null;
    }

    @Override
    public boolean processNSPrefix(String prefix) {
        return true;
    }

    @Override
    public boolean processVariable(PsiVariable variable) {
        this.myResult.add(variable);
        return true;
    }

    @Override
    public boolean processVariable(ELVariable variable) {
        this.myResult.add(variable);
        return true;
    }

    public static boolean acceptMethodCompletion(PsiMethod psiMethod) {
        PsiClass containingClass = psiMethod.getContainingClass();
        return containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName());
    }

    private static InsertHandler<LookupElement> getMethodInsertHandler(PsiMethod method) {
        if (method.getParameterList().getParametersCount() == 0) {
            return ParenthesesInsertHandler.NO_PARAMETERS;
        }
        return ELReference.METHOD_WITH_PARAMETERS_INSERT_HANDLER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/el/util/processors/ELElementCollectProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/el/util/processors/ELElementCollectProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

