/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.transport;

import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportHostTarget;
import com.intellij.javaee.transport.TransportHostTargetEditor;
import com.intellij.javaee.transport.TransportManagerConfigurable;
import com.intellij.javaee.transport.TransportManagerConfigurableListener;
import com.intellij.javaee.transport.TransportTarget;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TransportTargetConfigurable {
    private JPanel myMainPanel;
    private TransportManagerConfigurable myParentConfigurable;
    private TransportHostTargetEditor myHostTargetEditor;
    private TransportHost myHost;
    private TransportTarget myTarget;

    public TransportTargetConfigurable() {
        this.$$$setupUI$$$();
    }

    public void setParentConfigurable(TransportManagerConfigurable parentConfigurable) {
        this.myParentConfigurable = parentConfigurable;
        this.myParentConfigurable.addListener(new TransportManagerConfigurableListener(){

            @Override
            public void hostSelectionChanged() {
                TransportTargetConfigurable.this.resetContent();
            }
        });
        this.resetContent();
    }

    private void resetContent() {
        if (this.myHost != null) {
            this.myMainPanel.remove(this.myHostTargetEditor.getMainPanel());
        }
        this.myHost = this.myParentConfigurable.getHost();
        if (this.myHost != null) {
            this.myHostTargetEditor = this.myHost.getType().createTargetEditor();
            this.myMainPanel.add(this.myHostTargetEditor.getMainPanel());
            this.myHostTargetEditor.setHost(this.myHost);
            this.loadState();
        }
    }

    public void setTarget(TransportTarget target) {
        this.myTarget = target;
        this.loadState();
    }

    private TransportHostTarget getState() {
        if (this.myHost == null || this.myTarget == null) {
            return null;
        }
        return this.myHost.findOrCreateHostTarget(this.myTarget);
    }

    private void loadState() {
        TransportHostTarget state = this.getState();
        if (state == null) {
            return;
        }
        this.myHostTargetEditor.resetStateFrom(state);
    }

    public void saveState() {
        TransportHostTarget state = this.getState();
        if (state == null) {
            return;
        }
        this.myHostTargetEditor.applyStateTo(state);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

