/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessTextDecompositionBuilder;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StatelessTextDecomposition
implements StatelessParametersHolder {
    private final ListChoiceNode myNode;
    private final Map<String, ParameterNode> myParameters;

    public static StatelessTextDecomposition build(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns) throws InvalidTemplateException {
        if (template == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(1);
        }
        return new StatelessTextDecomposition(StatelessTextDecompositionBuilder.build(template, patterns));
    }

    private StatelessTextDecomposition(@NotNull Node node) throws InvalidTemplateException {
        if (node == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(2);
        }
        this.myNode = new ListChoiceNode(node, true);
        this.myParameters = new LinkedHashMap<String, ParameterNode>();
        this.findParameters(this.myNode);
    }

    public ListChoiceNode getNode() {
        return this.myNode;
    }

    public boolean isTextValid(@NotNull String text2) {
        Matcher matcher;
        if (text2 == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(3);
        }
        if (!(matcher = this.myNode.compilePattern().matcher(text2)).matches()) {
            return false;
        }
        return !this.hasMandatoryMismatch(matcher);
    }

    private boolean hasMandatoryMismatch(@NotNull Matcher matcher) {
        if (matcher == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(4);
        }
        Object2BooleanOpenHashMap possibleMismatches = new Object2BooleanOpenHashMap();
        StatelessTextDecomposition.collectMandatoryMismatch(matcher, this.myNode, 0, (Object2BooleanMap<Node>)possibleMismatches);
        return possibleMismatches.containsValue(false);
    }

    private static void collectMandatoryMismatch(@NotNull Matcher matcher, @NotNull Node node, int group, @NotNull Object2BooleanMap<Node> possibleMismatches) {
        if (matcher == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(5);
        }
        if (node == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(6);
        }
        if (possibleMismatches == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(7);
        }
        if (node instanceof ListChoiceNode && ((ListChoiceNode)node).isMandatory()) {
            boolean mismatch;
            boolean bl = mismatch = matcher.start(group + 1) == -1;
            if (mismatch) {
                possibleMismatches.putIfAbsent((Object)node, (Object)false);
            } else {
                possibleMismatches.put((Object)node, true);
            }
        }
        Node[] children = node.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            int offset;
            Node child = children[i2];
            int alt = 0;
            while ((offset = node.getChildGroupOffset(i2, alt)) != -1) {
                StatelessTextDecomposition.collectMandatoryMismatch(matcher, child, group + offset, possibleMismatches);
                ++alt;
            }
        }
    }

    private void findParameters(@NotNull Node node) throws InvalidTemplateException {
        ParameterNode param;
        if (node == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(8);
        }
        if ((param = (ParameterNode)ObjectUtils.tryCast((Object)node, ParameterNode.class)) != null && param.getName() != null && null != this.myParameters.put(param.getName(), param)) {
            throw new InvalidTemplateException("Duplicate parameter: " + param.getName(), null);
        }
        for (Node c2 : node.getChildren()) {
            this.findParameters(c2);
        }
    }

    @Override
    @Nullable
    public StatelessParametersHolder.ParameterInfo getParameterInfo(@NotNull String key) {
        if (key == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(9);
        }
        return this.myParameters.get(key);
    }

    @Override
    @NotNull
    public Collection<String> getParameterNames() {
        Set<String> set = this.myParameters.keySet();
        if (set == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(10);
        }
        return set;
    }

    @TestOnly
    @NotNull
    public String getPattern() {
        String string = this.myNode.getPattern();
        if (string == null) {
            StatelessTextDecomposition.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleMismatches";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTextValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMandatoryMismatch";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectMandatoryMismatch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findParameters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterInfo";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }

    public static abstract class Node {
        protected static final Node[] NO_CHILDREN = new Node[0];
        private final Node[] children;
        private final String myPattern;
        private String myIncrementalPattern;
        private String myRecoverPattern;
        private final int myContainingGroups;
        private final boolean myEarlyMatchable;

        public Node(Node @NotNull [] children, @NotNull String pattern, int groups, boolean earlyMatchable) {
            if (pattern == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (children == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.children = children;
            this.myPattern = pattern;
            this.myContainingGroups = groups;
            this.myEarlyMatchable = earlyMatchable;
        }

        public abstract int getChildGroupOffset(int var1, int var2);

        public boolean isEarlyMatchable() {
            return this.myEarlyMatchable;
        }

        public Node @NotNull [] getChildren() {
            if (this.children == null) {
                Node.$$$reportNull$$$0(2);
            }
            return this.children;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                Node.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Pattern compilePattern() {
            Pattern pattern = PatternBuilder.compile(this.getPattern());
            if (pattern == null) {
                Node.$$$reportNull$$$0(4);
            }
            return pattern;
        }

        public boolean matches(@NotNull String text2) {
            if (text2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            return this.compilePattern().matcher(text2).matches();
        }

        @NotNull
        public String getIncrementalPattern() {
            String string = this.myIncrementalPattern;
            if (string == null) {
                Node.$$$reportNull$$$0(6);
            }
            return string;
        }

        public int getContainingGroups() {
            return this.myContainingGroups;
        }

        private void setIncrementalPattern(String incrementalPattern) {
            this.myIncrementalPattern = incrementalPattern;
        }

        @NotNull
        public String getRecoverPattern() {
            String string = this.myRecoverPattern;
            if (string == null) {
                Node.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public Pattern compileIncrementalPattern() {
            Pattern pattern = PatternBuilder.compile(this.getIncrementalPattern());
            if (pattern == null) {
                Node.$$$reportNull$$$0(8);
            }
            return pattern;
        }

        @NotNull
        public Pattern compileRecoverPattern() {
            Pattern pattern = PatternBuilder.compile(this.getRecoverPattern());
            if (pattern == null) {
                Node.$$$reportNull$$$0(9);
            }
            return pattern;
        }

        private void setRecoverPattern(String recoverPattern) {
            this.myRecoverPattern = recoverPattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compilePattern";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIncrementalPattern";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecoverPattern";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compileIncrementalPattern";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compileRecoverPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }

        public static enum NodeType {
            TEXT,
            OPTIONAL,
            COMPOSITE,
            PARAMETER,
            PROPERTIES;

        }
    }

    public static class ListChoiceNode
    extends Node {
        private final boolean myMandatory;

        public ListChoiceNode(@NotNull Node child, boolean mandatory) {
            if (child == null) {
                ListChoiceNode.$$$reportNull$$$0(0);
            }
            super(new Node[]{child}, ListChoiceNode.createPattern(child), ListChoiceNode.countGroups(child), child.isEarlyMatchable());
            this.myMandatory = mandatory;
        }

        public boolean isMandatory() {
            return this.myMandatory;
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            return alt == 0 ? (this.getChildren()[0] instanceof OptionalNode ? 1 : 0) : -1;
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                ListChoiceNode.$$$reportNull$$$0(1);
            }
            return child.getContainingGroups() + (child instanceof OptionalNode ? 1 : 0);
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                ListChoiceNode.$$$reportNull$$$0(2);
            }
            PatternBuilder builder = PatternBuilder.build(child.getPattern());
            if (child instanceof OptionalNode) {
                builder.matchingGroup();
            }
            return builder.toString();
        }

        public String toString() {
            return "&" + String.valueOf(this.getChildren()[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "child";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoiceNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ParameterNode
    extends Node
    implements StatelessParametersHolder.ParameterInfo {
        private final String myName;
        private final String myType;
        private final String myDefValue;
        private final String myConfiguration;
        private final QuoteHandler myQuote;

        public ParameterNode(@Nullable String name, @NotNull String type, @Nullable String defValue, @Nullable String configuration, @Nullable QuoteHandler quote, @NotNull Pattern pattern) {
            if (type == null) {
                ParameterNode.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                ParameterNode.$$$reportNull$$$0(1);
            }
            super(NO_CHILDREN, PatternBuilder.build(pattern).orQuoted(quote).matchingGroup().toString(), PatternBuilder.countGroups(pattern) + 1, true);
            this.myName = name;
            this.myType = type;
            this.myDefValue = defValue;
            this.myConfiguration = configuration;
            this.myQuote = quote;
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            return alt == 0 ? 1 : -1;
        }

        @Override
        @NotNull
        public String getType() {
            String string = ParameterNode.clearTypeName(this.myType);
            if (string == null) {
                ParameterNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        public static String clearTypeName(String type) {
            boolean hidden;
            boolean extra = type.startsWith("##");
            boolean bl = hidden = extra || type.startsWith("#");
            return hidden ? type.substring(extra ? 2 : 1) : type;
        }

        @Override
        @Nullable
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        public String getDefValue() {
            return this.myDefValue;
        }

        @Override
        @Nullable
        public String getConfiguration() {
            return this.myConfiguration;
        }

        @Override
        @Nullable
        public QuoteHandler getQuote() {
            return this.myQuote;
        }

        @Override
        public boolean isValueValid(@NotNull String value) {
            if (value == null) {
                ParameterNode.$$$reportNull$$$0(3);
            }
            return this.matches(value);
        }

        @Override
        public boolean isHidden() {
            return !this.isExtra() && this.myType.startsWith("#");
        }

        @Override
        public boolean isExtra() {
            return this.myType.startsWith("##");
        }

        public String toString() {
            return "{" + this.myName + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ParameterNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ParameterNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isValueValid";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class InvalidTemplateException
    extends Exception {
        public InvalidTemplateException(@NotNull String msg, @Nullable Throwable cause) {
            if (msg == null) {
                InvalidTemplateException.$$$reportNull$$$0(0);
            }
            super(msg, cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$InvalidTemplateException", "<init>"));
        }
    }

    static enum QuoteHandler {
        SQUARE{

            @Override
            @NotNull
            public String getPattern() {
                return "\\[(?:[^]]|]])*]";
            }

            @Override
            public boolean isQuoted(@NotNull String string) {
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string.startsWith("[") && string.endsWith("]");
            }

            @Override
            @NotNull
            public String quote(@NotNull String string) {
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string2 = "[" + string.replace("]", "]]") + "]";
                if (string2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string2;
            }

            @Override
            @NotNull
            public String unquote(@NotNull String string) {
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                String string2 = string.substring(1, string.length() - 1).replace("]]", "]");
                if (string2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string2;
            }

            @Override
            public boolean forceQuote(@NotNull String text2) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "string";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$QuoteHandler$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$QuoteHandler$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "quote";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "unquote";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isQuoted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "quote";
                        break;
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "unquote";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "forceQuote";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4 -> new IllegalStateException(string);
                };
            }
        }
        ,
        URL_ENCODE{

            @Override
            @NotNull
            public String getPattern() {
                return "[A-Za-z0-9.*_%-]+";
            }

            @Override
            public boolean isQuoted(@NotNull String string) {
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            @NotNull
            public String quote(@NotNull String string) {
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                String string2 = URLEncoder.encode(string, StandardCharsets.UTF_8);
                if (string2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string2;
            }

            @Override
            @NotNull
            public String unquote(@NotNull String string) {
                String string2;
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                try {
                    string2 = URLDecoder.decode(string, StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException e) {
                    String string3 = string;
                    if (string3 == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return string3;
                }
                if (string2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                return string2;
            }

            @Override
            public boolean forceQuote(@NotNull String text2) {
                if (text2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "string";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$QuoteHandler$2";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$QuoteHandler$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "quote";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "unquote";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isQuoted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "quote";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "unquote";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "forceQuote";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4, 5 -> new IllegalStateException(string);
                };
            }
        };


        @Language(value="RegExp")
        @NotNull
        public abstract String getPattern();

        public abstract boolean isQuoted(@NotNull String var1);

        @NotNull
        public abstract String quote(@NotNull String var1);

        @NotNull
        public abstract String unquote(@NotNull String var1);

        public abstract boolean forceQuote(@NotNull String var1);

        @Nullable
        static QuoteHandler byName(@NotNull String name) {
            if (name == null) {
                QuoteHandler.$$$reportNull$$$0(0);
            }
            return name.equals("[") ? SQUARE : (name.equals("%") ? URL_ENCODE : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$QuoteHandler", "byName"));
        }
    }

    public static final class FollowBuilder {
        Map<Node, Set<String>> myFirsts;
        Map<Node, Set<String>> myFollows;
        Map<Node, Boolean> myCanBeEmpty;

        public static void buildFollow(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(0);
            }
            new FollowBuilder(node);
        }

        private FollowBuilder(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(1);
            }
            this.myFirsts = new HashMap<Node, Set<String>>();
            this.myFollows = new HashMap<Node, Set<String>>();
            this.myCanBeEmpty = new HashMap<Node, Boolean>();
            this.addFollow(node, Collections.singleton("$"));
            this.collectChildFollows(node);
            this.assignIncrementalPatterns(node);
        }

        public boolean assignIncrementalPatterns(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(2);
            }
            boolean greedyRecover = false;
            for (Node c2 : node.getChildren()) {
                greedyRecover = this.assignIncrementalPatterns(c2);
            }
            greedyRecover |= node instanceof ListNode;
            PatternBuilder lookahead = PatternBuilder.build("");
            boolean first2 = true;
            Set<String> follow = this.getFollow(node);
            for (String s : follow) {
                if (!first2) {
                    lookahead.append("|");
                } else {
                    first2 = false;
                }
                lookahead.append(s);
            }
            lookahead.positiveLookahead();
            PatternBuilder incremental = PatternBuilder.build(node.getPattern()).group();
            if (!(node instanceof TextNode)) {
                incremental.append(lookahead);
            }
            node.setIncrementalPattern(incremental.toString());
            String recover = greedyRecover ? ".*" : ".*?";
            node.setRecoverPattern(PatternBuilder.build(recover).group().append(lookahead).toString());
            return greedyRecover;
        }

        public void collectChildFollows(@NotNull Node parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(3);
            }
            if (parent.getClass() == CompositeNode.class) {
                this.collectChildFollows((CompositeNode)parent);
            } else if (parent.getClass() == OptionalNode.class) {
                this.collectChildFollows((OptionalNode)parent);
            } else if (parent.getClass() == ParameterNode.class) {
                this.collectChildFollows((ParameterNode)parent);
            } else if (parent.getClass() == TextNode.class) {
                this.collectChildFollows((TextNode)parent);
            } else if (parent.getClass() == ListChoicesNode.class) {
                this.collectChildFollows((ListChoicesNode)parent);
            } else if (parent.getClass() == ListChoiceNode.class) {
                this.collectChildFollows((ListChoiceNode)parent);
            } else if (parent.getClass() == ListNode.class) {
                this.collectChildFollows((ListNode)parent);
            } else if (parent.getClass() == AntiNode.class) {
                this.collectChildFollows((AntiNode)parent);
            } else assert (false);
        }

        public void collectChildFollows(@NotNull AntiNode parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(4);
            }
            this.addFollow(parent.getChildren()[0], this.getFollow(parent));
            this.collectChildFollows(parent.getChildren()[0]);
            Set<String> filter = this.getFirst(parent.getChildren()[0]);
            this.setCanBeEmpty(parent, true);
            this.filterFirst(parent, filter);
            this.filterFollow(parent, filter);
        }

        public void collectChildFollows(@NotNull ParameterNode parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(5);
            }
            this.setCanBeEmpty(parent, parent.matches(""));
            this.addFirst(parent, Collections.singleton(parent.getPattern()));
        }

        public void collectChildFollows(@NotNull ListChoiceNode parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(6);
            }
            Node node = parent.getChildren()[0];
            this.addFollow(node, this.getFollow(parent));
            this.collectChildFollows(node);
            this.setCanBeEmpty(parent, this.canBeEmpty(node));
            this.addFirst(parent, this.getFirst(node));
        }

        public void collectChildFollows(@NotNull TextNode parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(7);
            }
            this.setCanBeEmpty(parent, StringUtil.isEmpty((String)parent.getText()));
            this.addFirst(parent, Collections.singleton(parent.getPattern()));
        }

        public void collectChildFollows(@NotNull OptionalNode parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(8);
            }
            this.addFollow(parent.getChildren()[0], this.getFollow(parent));
            this.collectChildFollows(parent.getChildren()[0]);
            this.setCanBeEmpty(parent, true);
            this.addFirst(parent, this.getFirst(parent.getChildren()[0]));
        }

        public void collectChildFollows(@NotNull ListChoicesNode parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(9);
            }
            Node[] children = parent.getChildren();
            for (int i2 = children.length - 1; i2 >= 0; --i2) {
                Node node = children[i2];
                this.addFollow(node, this.getFollow(parent));
                this.collectChildFollows(node);
            }
            boolean canBeEmpty = false;
            for (Node child : children) {
                this.addFirst(parent, this.getFirst(child));
                if (canBeEmpty || !this.canBeEmpty(child)) continue;
                canBeEmpty = true;
            }
            this.setCanBeEmpty(parent, canBeEmpty);
        }

        public void collectChildFollows(@NotNull ListNode parent) {
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(10);
            }
            this.addFollow(parent.getChoice(), Collections.singleton(parent.getSeparatorPattern()));
            this.addFollow(parent.getChoice(), Collections.singleton("$"));
            this.collectChildFollows(parent.getChoice());
            this.setCanBeEmpty(parent, this.canBeEmpty(parent.getChoice()));
            this.addFirst(parent, this.getFirst(parent.getChoice()));
        }

        public void collectChildFollows(@NotNull CompositeNode parent) {
            Node[] children;
            if (parent == null) {
                FollowBuilder.$$$reportNull$$$0(11);
            }
            if ((children = parent.getChildren()).length != 0) {
                Node last = children[children.length - 1];
                this.addFollow(last, this.getFollow(parent));
                this.collectChildFollows(last);
            }
            for (int i2 = children.length - 2; i2 >= 0; --i2) {
                Node node = children[i2];
                Node next = children[i2 + 1];
                this.addFollow(node, this.getFirst(next));
                if (this.canBeEmpty(next)) {
                    this.addFollow(node, this.getFollow(next));
                }
                this.collectChildFollows(node);
            }
            boolean canBeEmpty = true;
            for (Node child : children) {
                this.addFirst(parent, this.getFirst(child));
                if (this.canBeEmpty(child)) continue;
                canBeEmpty = false;
                break;
            }
            this.setCanBeEmpty(parent, canBeEmpty);
        }

        private void addFirst(@NotNull Node node, @NotNull Collection<String> add) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(12);
            }
            if (add == null) {
                FollowBuilder.$$$reportNull$$$0(13);
            }
            FollowBuilder.addToMap(this.myFirsts, node, add);
        }

        private void filterFirst(@NotNull Node node, @NotNull Collection<String> filter) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(14);
            }
            if (filter == null) {
                FollowBuilder.$$$reportNull$$$0(15);
            }
            FollowBuilder.filterMap(this.myFirsts, node, filter);
        }

        private void addFollow(@NotNull Node node, @NotNull Collection<String> add) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(16);
            }
            if (add == null) {
                FollowBuilder.$$$reportNull$$$0(17);
            }
            FollowBuilder.addToMap(this.myFollows, node, add);
        }

        private void filterFollow(@NotNull Node node, @NotNull Collection<String> filter) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(18);
            }
            if (filter == null) {
                FollowBuilder.$$$reportNull$$$0(19);
            }
            FollowBuilder.filterMap(this.myFollows, node, filter);
        }

        @NotNull
        private Set<String> getFirst(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(20);
            }
            Set<String> set = Objects.requireNonNull(this.myFirsts.get(node));
            if (set == null) {
                FollowBuilder.$$$reportNull$$$0(21);
            }
            return set;
        }

        @NotNull
        private Set<String> getFollow(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(22);
            }
            Set<String> set = Objects.requireNonNull(this.myFollows.get(node));
            if (set == null) {
                FollowBuilder.$$$reportNull$$$0(23);
            }
            return set;
        }

        private void setCanBeEmpty(@NotNull Node node, boolean can) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(24);
            }
            this.myCanBeEmpty.put(node, can);
        }

        private boolean canBeEmpty(@NotNull Node node) {
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(25);
            }
            return this.myCanBeEmpty.get(node);
        }

        private static void addToMap(@NotNull Map<Node, Set<String>> map, @NotNull Node node, @NotNull Collection<String> add) {
            Set<String> subset;
            if (map == null) {
                FollowBuilder.$$$reportNull$$$0(26);
            }
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(27);
            }
            if (add == null) {
                FollowBuilder.$$$reportNull$$$0(28);
            }
            if ((subset = map.get(node)) == null) {
                subset = new HashSet<String>();
                map.put(node, subset);
            }
            subset.addAll(add);
        }

        private static void filterMap(@NotNull Map<Node, Set<String>> map, @NotNull Node node, @NotNull Collection<String> filter) {
            Set<String> subset;
            if (map == null) {
                FollowBuilder.$$$reportNull$$$0(29);
            }
            if (node == null) {
                FollowBuilder.$$$reportNull$$$0(30);
            }
            if (filter == null) {
                FollowBuilder.$$$reportNull$$$0(31);
            }
            if ((subset = map.get(node)) == null) {
                subset = new HashSet<String>();
                map.put(node, subset);
            }
            subset.removeAll(filter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 21, 23 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 13: 
                case 17: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "add";
                    break;
                }
                case 15: 
                case 19: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder";
                    break;
                }
                case 26: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirst";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFollow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFollow";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "assignIncrementalPatterns";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "collectChildFollows";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addFirst";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFirst";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "addFollow";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFollow";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getFirst";
                    break;
                }
                case 21: 
                case 23: {
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "getFollow";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "setCanBeEmpty";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEmpty";
                    break;
                }
                case 26: 
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "addToMap";
                    break;
                }
                case 29: 
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "filterMap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 21, 23 -> new IllegalStateException(string);
            };
        }
    }

    public static class ListNode
    extends Node {
        private final String mySeparatorText;
        private final String mySeparatorPattern;

        public ListNode(@NotNull ListChoicesNode choice, @NotNull String separator) {
            if (choice == null) {
                ListNode.$$$reportNull$$$0(0);
            }
            if (separator == null) {
                ListNode.$$$reportNull$$$0(1);
            }
            this(choice, TextNode.textForText(separator), TextNode.patternForText(separator));
        }

        private ListNode(@NotNull ListChoicesNode choice, @NotNull String separatorText, @NotNull String separatorPattern) {
            if (choice == null) {
                ListNode.$$$reportNull$$$0(2);
            }
            if (separatorText == null) {
                ListNode.$$$reportNull$$$0(3);
            }
            if (separatorPattern == null) {
                ListNode.$$$reportNull$$$0(4);
            }
            super(new Node[]{choice}, ListNode.createPattern(choice.getPattern(), separatorPattern), 2 * PatternBuilder.countGroups(choice.getPattern()) + 1, false);
            this.mySeparatorPattern = separatorPattern;
            this.mySeparatorText = separatorText;
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            if (alt > 1) {
                return -1;
            }
            int start2 = alt == 0 ? 1 : this.getContainingGroups() / 2 + 1;
            return start2 + ListChoicesNode.accumulateOffset(this.getChildren(), childIdx);
        }

        @NotNull
        public String getSeparatorText() {
            String string = this.mySeparatorText;
            if (string == null) {
                ListNode.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getSeparatorPattern() {
            String string = this.mySeparatorPattern;
            if (string == null) {
                ListNode.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public ListChoicesNode getChoice() {
            ListChoicesNode listChoicesNode = (ListChoicesNode)this.getChildren()[0];
            if (listChoicesNode == null) {
                ListNode.$$$reportNull$$$0(7);
            }
            return listChoicesNode;
        }

        private static String createPattern(@NotNull String p, @NotNull String sep) {
            if (p == null) {
                ListNode.$$$reportNull$$$0(8);
            }
            if (sep == null) {
                ListNode.$$$reportNull$$$0(9);
            }
            return PatternBuilder.build(p).group().push().append(sep).push().append(p).group().pop().group().any().pop().matchingGroup().toString();
        }

        public String toString() {
            return "<" + this.getSeparatorText() + "; " + String.valueOf(this.getChildren()[0]) + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "choice";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separatorText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separatorPattern";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparatorText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparatorPattern";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChoice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createPattern";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static class ListChoicesNode
    extends Node {
        public ListChoicesNode(ListChoiceNode @NotNull [] choices) {
            if (choices == null) {
                ListChoicesNode.$$$reportNull$$$0(0);
            }
            super(choices, ListChoicesNode.createPattern(choices), ListChoicesNode.countGroups(choices), false);
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            if (alt != 0) {
                return -1;
            }
            return ListChoicesNode.accumulateOffset(this.getChildren(), childIdx);
        }

        public static int accumulateOffset(Node[] nodes, int childIdx) {
            int g = 0;
            for (int i2 = 0; i2 < childIdx; ++i2) {
                g += nodes[i2].getContainingGroups();
            }
            return g;
        }

        private static String createPattern(ListChoiceNode @NotNull [] choices) {
            if (choices == null) {
                ListChoicesNode.$$$reportNull$$$0(1);
            }
            PatternBuilder b = PatternBuilder.build("");
            boolean first2 = true;
            for (ListChoiceNode choice : choices) {
                if (!first2) {
                    b.append("|");
                } else {
                    first2 = false;
                }
                b.append(choice.getPattern());
            }
            return b.toString();
        }

        private static int countGroups(ListChoiceNode @NotNull [] choices) {
            if (choices == null) {
                ListChoicesNode.$$$reportNull$$$0(2);
            }
            return ListChoicesNode.accumulateOffset(choices, choices.length);
        }

        public String toString() {
            return StringUtil.join((Object[])this.getChildren(), Object::toString, (String)"; ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "choices";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoicesNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class CompositeNode
    extends Node {
        public CompositeNode(Node @NotNull [] children) {
            if (children == null) {
                CompositeNode.$$$reportNull$$$0(0);
            }
            super(children, CompositeNode.createPattern(children), CompositeNode.countGroups(children), CompositeNode.allEarlyMatchable(children));
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            if (alt != 0) {
                return -1;
            }
            return ListChoicesNode.accumulateOffset(this.getChildren(), childIdx) + 1;
        }

        private static String createPattern(Node @NotNull [] children) {
            if (children == null) {
                CompositeNode.$$$reportNull$$$0(1);
            }
            PatternBuilder b = PatternBuilder.build("");
            for (Node child : children) {
                b.append(child.getPattern());
            }
            return b.matchingGroup().toString();
        }

        private static boolean allEarlyMatchable(Node @NotNull [] children) {
            if (children == null) {
                CompositeNode.$$$reportNull$$$0(2);
            }
            boolean earlyMatchable = true;
            for (Node child : children) {
                earlyMatchable &= child.isEarlyMatchable();
            }
            return earlyMatchable;
        }

        private static int countGroups(Node @NotNull [] children) {
            if (children == null) {
                CompositeNode.$$$reportNull$$$0(3);
            }
            return ListChoicesNode.accumulateOffset(children, children.length) + 1;
        }

        public String toString() {
            return "(" + StringUtil.join((Object[])this.getChildren(), Object::toString, (String)" ") + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "children";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$CompositeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "allEarlyMatchable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OptionalNode
    extends Node {
        public OptionalNode(@NotNull Node child) {
            if (child == null) {
                OptionalNode.$$$reportNull$$$0(0);
            }
            super(new Node[]{child}, OptionalNode.createPattern(child), OptionalNode.countGroups(child), child.isEarlyMatchable());
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            return alt == 0 ? 0 : -1;
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                OptionalNode.$$$reportNull$$$0(1);
            }
            return child.getContainingGroups();
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                OptionalNode.$$$reportNull$$$0(2);
            }
            return PatternBuilder.build(child.getPattern()).opt().toString();
        }

        public String toString() {
            return String.valueOf(this.getChildren()[0]) + "?";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "child";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$OptionalNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AntiNode
    extends Node {
        public AntiNode(@NotNull Node child) {
            if (child == null) {
                AntiNode.$$$reportNull$$$0(0);
            }
            super(new Node[]{child}, AntiNode.createPattern(child), AntiNode.countGroups(child), child.isEarlyMatchable());
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            return alt == 0 ? 0 : -1;
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                AntiNode.$$$reportNull$$$0(1);
            }
            return child.getContainingGroups();
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                AntiNode.$$$reportNull$$$0(2);
            }
            return PatternBuilder.build(child.getPattern()).negativeLookahead().toString();
        }

        public String toString() {
            return "!" + String.valueOf(this.getChildren()[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "child";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$AntiNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countGroups";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TextNode
    extends Node {
        private final String myText;
        private final String myTextPattern;

        public TextNode(@NotNull String text2) {
            if (text2 == null) {
                TextNode.$$$reportNull$$$0(0);
            }
            this(TextNode.textForText(text2), TextNode.patternForText(text2));
        }

        public TextNode(@NotNull String text2, @NotNull String pattern) {
            if (text2 == null) {
                TextNode.$$$reportNull$$$0(1);
            }
            if (pattern == null) {
                TextNode.$$$reportNull$$$0(2);
            }
            super(NO_CHILDREN, PatternBuilder.build(pattern).matchingGroup().toString(), 1, true);
            this.myText = text2;
            this.myTextPattern = pattern;
        }

        private static String textForText(@NotNull String text2) {
            if (text2 == null) {
                TextNode.$$$reportNull$$$0(3);
            }
            return text2.replace(" ", "").replace("\u00a0", " ");
        }

        private static String patternForText(@NotNull String text2) {
            if (text2 == null) {
                TextNode.$$$reportNull$$$0(4);
            }
            StringBuilder res = new StringBuilder();
            int i2 = 0;
            int len = text2.length();
            while (i2 < len) {
                if (text2.charAt(i2) == '\u00a0') {
                    ++i2;
                    res.append(" ");
                    continue;
                }
                if (text2.charAt(i2) == ' ') {
                    ++i2;
                    res.append("\\s*");
                    continue;
                }
                int spIdx = StringUtil.indexOfAny((String)text2, (String)" \u00a0", (int)i2, (int)text2.length());
                if (spIdx == -1) {
                    spIdx = len;
                }
                res.append("\\Q").append(text2, i2, spIdx).append("\\E");
                i2 = spIdx;
            }
            return res.toString();
        }

        @Override
        public int getChildGroupOffset(int childIdx, int alt) {
            return alt == 0 ? 0 : -1;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                TextNode.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getTextPattern() {
            String string = this.myTextPattern;
            if (string == null) {
                TextNode.$$$reportNull$$$0(6);
            }
            return string;
        }

        public String toString() {
            return "\"" + this.myText + "\"";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$TextNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$TextNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "textForText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "patternForText";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

