/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.utils;

import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.data.cassandra.jam.EnableCassandraRepositories;
import com.intellij.spring.data.cassandra.jam.EnableReactiveCassandraRepositories;
import com.intellij.spring.data.commons.CustomEnableRepositories;
import com.intellij.spring.data.commons.model.jam.SpringCustomQueryAnnotation;
import com.intellij.spring.data.commons.model.jam.SpringDataDocumentId;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.couchbase.jam.EnableCouchbaseRepositories;
import com.intellij.spring.data.elasticsearch.jam.EnableElasticsearchRepositories;
import com.intellij.spring.data.gemfire.jam.EnableGemfireRepositories;
import com.intellij.spring.data.jdbc.jam.EnableJdbcRepositories;
import com.intellij.spring.data.keyValue.jam.EnableMapRepositories;
import com.intellij.spring.data.ldap.jam.EnableLdapRepositories;
import com.intellij.spring.data.neo4j.jam.EnableNeo4jRepositories;
import com.intellij.spring.data.neo4j.jam.EnableReactiveNeo4jRepositories;
import com.intellij.spring.data.r2dbc.jam.EnableR2dbcRepositories;
import com.intellij.spring.data.redis.jam.EnableRedisRepositories;
import com.intellij.spring.data.rest.SpringProjectionJamComponent;
import com.intellij.spring.data.rest.SpringRepositoryRestResource;
import com.intellij.spring.data.solr.jam.EnableSolrRepositories;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class SpringDataSemContributor
extends SemContributor {
    protected boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            SpringDataSemContributor.$$$reportNull$$$0(0);
        }
        return SpringDataUtil.hasSpringDataSupport(project);
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            SpringDataSemContributor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SpringDataSemContributor.$$$reportNull$$$0(2);
        }
        PsiClassPattern psiClassPattern = PsiJavaPatterns.psiClass();
        SemService semService = SemService.getSemService((Project)project);
        SpringRepositoryDefinition.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.repository.RepositoryDefinition"));
        SpringDataDocumentId.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.data.annotation.Id"));
        SpringDataDocumentId.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotation("org.springframework.data.annotation.Id"));
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableNeo4jRepositories.META, "org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableReactiveNeo4jRepositories.META, "org.springframework.data.neo4j.repository.config.EnableReactiveNeo4jRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableGemfireRepositories.META, "org.springframework.data.gemfire.repository.config.EnableGemfireRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableJdbcRepositories.META, "org.springframework.data.jdbc.repository.config.EnableJdbcRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableR2dbcRepositories.META, "org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableCassandraRepositories.META, "org.springframework.data.cassandra.repository.config.EnableCassandraRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableReactiveCassandraRepositories.META, "org.springframework.data.cassandra.repository.config.EnableReactiveCassandraRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableElasticsearchRepositories.META, "org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableRedisRepositories.META, "org.springframework.data.redis.repository.configuration.EnableRedisRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableSolrRepositories.META, "org.springframework.data.solr.repository.config.EnableSolrRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableLdapRepositories.META, "org.springframework.ldap.repository.config.EnableLdapRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableCouchbaseRepositories.META, "org.springframework.data.couchbase.repository.config.EnableCouchbaseRepositories");
        SpringDataSemContributor.registerExplicitAndComposeElements(registrar, psiClassPattern, semService, EnableMapRepositories.META, "org.springframework.data.map.repository.config.EnableMapRepositories");
        SpringProjectionJamComponent.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.rest.core.config.Projection"));
        SpringDataSemContributor.registerRestRepositories(registrar, psiClassPattern, semService);
        SpringDataSemContributor.registerQueryAnnotations(registrar, semService);
    }

    public static void registerExplicitAndComposeElements(@NotNull SemRegistrar registrar, PsiClassPattern psiClassPattern, @NotNull SemService semService, JamClassMeta<? extends SpringComponentScan> meta, @NotNull String anno) {
        if (registrar == null) {
            SpringDataSemContributor.$$$reportNull$$$0(3);
        }
        if (semService == null) {
            SpringDataSemContributor.$$$reportNull$$$0(4);
        }
        if (anno == null) {
            SpringDataSemContributor.$$$reportNull$$$0(5);
        }
        meta.register(registrar, (ElementPattern)psiClassPattern.withAnnotation(anno));
        SpringDataSemContributor.registerCustomEnableRepositories(registrar, psiClassPattern, semService, anno, meta);
    }

    public static void registerCustomEnableRepositories(SemRegistrar registrar, PsiClassPattern psiClassPattern, @NotNull SemService semService, @NotNull String definingAnnotation, @NotNull JamClassMeta<? extends SpringComponentScan> definingClassMeta) {
        if (semService == null) {
            SpringDataSemContributor.$$$reportNull$$$0(6);
        }
        if (definingAnnotation == null) {
            SpringDataSemContributor.$$$reportNull$$$0(7);
        }
        if (definingClassMeta == null) {
            SpringDataSemContributor.$$$reportNull$$$0(8);
        }
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, CustomEnableRepositories.META_KEY, CustomEnableRepositories.JAM_KEY, (Function)SpringSemContributorUtil.createFunction(CustomEnableRepositories.JAM_KEY, List.of(definingAnnotation), (anno, psi) -> new CustomEnableRepositories((String)anno, (PsiClass)psi, definingAnnotation, definingClassMeta), null, null, (boolean)true));
    }

    private static void registerQueryAnnotations(SemRegistrar registrar, @NotNull SemService semService) {
        if (semService == null) {
            SpringDataSemContributor.$$$reportNull$$$0(9);
        }
        PsiMethodPattern methodPattern = PsiJavaPatterns.psiMethod().constructor(false);
        List<String> metaAnnotations = List.of("org.springframework.data.annotation.QueryAnnotation", "org.springframework.data.elasticsearch.annotations.Query", "org.springframework.data.solr.repository.Query", "org.apache.deltaspike.data.api.Query");
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)methodPattern, SpringCustomQueryAnnotation.META_KEY, SpringCustomQueryAnnotation.JAM_KEY, (Function)SpringSemContributorUtil.createFunction(SpringCustomQueryAnnotation.JAM_KEY, metaAnnotations, SpringCustomQueryAnnotation::new, null, null, (boolean)true));
    }

    private static void registerRestRepositories(SemRegistrar registrar, PsiClassPattern psiClassPattern, @NotNull SemService semService) {
        if (semService == null) {
            SpringDataSemContributor.$$$reportNull$$$0(10);
        }
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, SpringRepositoryRestResource.META_KEY, SpringRepositoryRestResource.JAM_KEY, (Function)SpringSemContributorUtil.createFunction(SpringRepositoryRestResource.JAM_KEY, List.of("org.springframework.data.rest.core.annotation.RepositoryRestResource"), SpringRepositoryRestResource.getRepositoryRestResourceProducer(), (Consumer)SpringSemContributorUtil.createStereotypeConsumer(), (boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definingAnnotation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definingClassMeta";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/data/utils/SpringDataSemContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSemProviders";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExplicitAndComposeElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCustomEnableRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerQueryAnnotations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRestRepositories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

