/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang.codeInsight.editorActions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.quarkus.qute.lang.psi.PsiQuteSection;
import com.intellij.quarkus.qute.lang.psi.PsiQuteTag;
import com.intellij.quarkus.qute.lang.psi.PsiQuteVisitorGenerated;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/quarkus/qute/lang/codeInsight/editorActions/QuteFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "node", "Lcom/intellij/lang/ASTNode;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/openapi/editor/Document;)[Lcom/intellij/lang/folding/FoldingDescriptor;", "getPlaceholderText", "", "isCollapsedByDefault", "", "computeStartOffset", "", "quteSection", "Lcom/intellij/quarkus/qute/lang/psi/PsiQuteSection;", "computeEndOffset", "(Lcom/intellij/quarkus/qute/lang/psi/PsiQuteSection;)Ljava/lang/Integer;", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQuteFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuteFoldingBuilder.kt\ncom/intellij/quarkus/qute/lang/codeInsight/editorActions/QuteFoldingBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n37#2,2:77\n*S KotlinDebug\n*F\n+ 1 QuteFoldingBuilder.kt\ncom/intellij/quarkus/qute/lang/codeInsight/editorActions/QuteFoldingBuilder\n*L\n43#1:77,2\n*E\n"})
public final class QuteFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        List result = new ArrayList();
        node.getPsi().accept((PsiElementVisitor)new PsiQuteVisitorGenerated(this, result){
            final /* synthetic */ QuteFoldingBuilder this$0;
            final /* synthetic */ List<FoldingDescriptor> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitSection(PsiQuteSection psiQuteSection) {
                Intrinsics.checkNotNullParameter((Object)psiQuteSection, (String)"psiQuteSection");
                int startOffset = QuteFoldingBuilder.access$computeStartOffset(this.this$0, psiQuteSection);
                Integer n = QuteFoldingBuilder.access$computeEndOffset(this.this$0, psiQuteSection);
                if (n == null) {
                    return;
                }
                int endOffset = n;
                if (endOffset <= startOffset) {
                    return;
                }
                TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                TextRange blockRange = textRange;
                if (!blockRange.isEmpty()) {
                    this.$result.add(new FoldingDescriptor(psiQuteSection.getNode(), blockRange, null, " ... ", Boolean.valueOf(false), SetsKt.emptySet()));
                }
                super.visitSection(psiQuteSection);
            }
        });
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FoldingDescriptor[0]);
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    private final int computeStartOffset(PsiQuteSection quteSection) {
        PsiQuteTag psiQuteTag = quteSection.getOpeningTag();
        Intrinsics.checkNotNullExpressionValue((Object)psiQuteTag, (String)"getOpeningTag(...)");
        PsiQuteTag openingTag = psiQuteTag;
        TextRange openingTagTextRange = openingTag.getTextRange();
        if (openingTag.hasVisibleTagOpener()) {
            PsiElement openingTagCloseBrace;
            PsiElement psiElement = openingTagCloseBrace = openingTag.getTagCloser();
            Integer endOffset = psiElement != null ? Integer.valueOf(psiElement.getTextOffset()) : null;
            Integer n = endOffset;
            return CharArrayUtil.shiftBackward((CharSequence)quteSection.getContainingFile().getNode().getChars(), (int)((n != null ? n : 0) - 1), (String)" \n") + 1;
        }
        return openingTagTextRange.getEndOffset();
    }

    private final Integer computeEndOffset(PsiQuteSection quteSection) {
        PsiElement closingTagCloseBrace;
        PsiQuteTag psiQuteTag = quteSection.getClosingTag();
        if (psiQuteTag == null) {
            return quteSection.getTextRange().getEndOffset();
        }
        PsiQuteTag closingTag = psiQuteTag;
        TextRange textRange = closingTag.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange closingTagTextRange = textRange;
        if (!closingTag.hasVisibleTagOpener()) {
            return closingTagTextRange.getStartOffset();
        }
        PsiElement psiElement = closingTagCloseBrace = closingTag.getTagCloser();
        return psiElement != null ? Integer.valueOf(psiElement.getTextOffset()) : null;
    }

    public static final /* synthetic */ int access$computeStartOffset(QuteFoldingBuilder $this, PsiQuteSection quteSection) {
        return $this.computeStartOffset(quteSection);
    }

    public static final /* synthetic */ Integer access$computeEndOffset(QuteFoldingBuilder $this, PsiQuteSection quteSection) {
        return $this.computeEndOffset(quteSection);
    }
}

